/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.entities.EntityFluorescentTube;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

import java.util.Random;

public class EntityRenderFluorescentTube extends Render<EntityFluorescentTube>
{
	static double sqrt2Half = Math.sqrt(2)/2;
	public static final double[][] octagon = {
			{1, 0}, {sqrt2Half, sqrt2Half}, {0, 1}, {-sqrt2Half, sqrt2Half},
			{-1, 0}, {-sqrt2Half, -sqrt2Half}, {0, -1}, {sqrt2Half, -sqrt2Half}	
	};
	Random r = new Random();
	ResourceLocation modelLocation = new ResourceLocation("immersiveengineering:fluorescent_tube.obj");
	TextureAtlasSprite tex;
	public EntityRenderFluorescentTube(RenderManager renderManager)
	{
		super(renderManager);
		field_76987_f = 0;
		field_76989_e = 0;
	}

	@Override
	protected ResourceLocation func_110775_a(EntityFluorescentTube entity)
	{
		return null;
	}
	@Override
	public void func_76986_a(EntityFluorescentTube entity, double x, double y, double z, float entityYaw,
			float partialTicks)
	{
		Tessellator tes = Tessellator.func_178181_a();
		BufferBuilder wr = tes.func_178180_c();
		GlStateManager.func_179091_B();
		ClientUtils.bindAtlas();
		if (entity.active)
		{
			GlStateManager.func_179101_C();
			GlStateManager.func_179123_a();
			GlStateManager.func_179147_l();
			GlStateManager.func_179140_f();
			GlStateManager.func_179112_b(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
		}
		if (entity.rgb!=null&&entity.rgb.length>=3)
		{
			float mult = .5F+(entity.active?r.nextFloat()*.5F:0);
			GlStateManager.func_179124_c(entity.rgb[0]*mult, entity.rgb[1]*mult, entity.rgb[2]*mult);
		}
		GlStateManager.func_179094_E();
		GlStateManager.func_179137_b(x, y+1, z);
		GlStateManager.func_179114_b(entityYaw+90, 0, 1, 0);
		GlStateManager.func_179090_x();
		GlStateManager.func_179094_E();
		GlStateManager.func_179137_b(0, 0, .03125);
		GlStateManager.func_179114_b(entity.angleHorizontal, 1, 0, 0);
		GlStateManager.func_179139_a(.0625, 1, .0625);
		wr.func_181668_a(GL11.GL_QUADS, DefaultVertexFormats.field_181705_e);
		float size = entity.tubeLength/2;
		//sides
		for (int i = 0;i<8;i++)
		{
			wr.func_181662_b(octagon[i][0], size, octagon[i][1]).func_181675_d();
			wr.func_181662_b(octagon[(i+1)%8][0], size, octagon[(i+1)%8][1]).func_181675_d();
			wr.func_181662_b(octagon[(i+1)%8][0], -size, octagon[(i+1)%8][1]).func_181675_d();
			wr.func_181662_b(octagon[i][0], -size, octagon[i][1]).func_181675_d();
		}
		tes.func_78381_a();
		GlStateManager.func_179084_k();
		GlStateManager.func_179145_e();
		if (!entity.active)
			GlStateManager.func_179101_C();
		//caps
		GlStateManager.func_179124_c(0, 0, 0);
		wr.func_181668_a(GL11.GL_QUADS, DefaultVertexFormats.field_181705_e);
		wr.func_181662_b(octagon[0][0], -size, octagon[0][1]).func_181675_d();
		wr.func_181662_b(octagon[1][0], -size, octagon[1][1]).func_181675_d();
		wr.func_181662_b(octagon[2][0], -size, octagon[2][1]).func_181675_d();
		wr.func_181662_b(octagon[3][0], -size, octagon[3][1]).func_181675_d();

		wr.func_181662_b(octagon[3][0], -size, octagon[3][1]).func_181675_d();
		wr.func_181662_b(octagon[4][0], -size, octagon[4][1]).func_181675_d();
		wr.func_181662_b(octagon[7][0], -size, octagon[7][1]).func_181675_d();
		wr.func_181662_b(octagon[0][0], -size, octagon[0][1]).func_181675_d();

		wr.func_181662_b(octagon[4][0], -size, octagon[4][1]).func_181675_d();
		wr.func_181662_b(octagon[5][0], -size, octagon[5][1]).func_181675_d();
		wr.func_181662_b(octagon[6][0], -size, octagon[6][1]).func_181675_d();
		wr.func_181662_b(octagon[7][0], -size, octagon[7][1]).func_181675_d();


		wr.func_181662_b(octagon[3][0], size, octagon[3][1]).func_181675_d();
		wr.func_181662_b(octagon[2][0], size, octagon[2][1]).func_181675_d();
		wr.func_181662_b(octagon[1][0], size, octagon[1][1]).func_181675_d();
		wr.func_181662_b(octagon[0][0], size, octagon[0][1]).func_181675_d();

		wr.func_181662_b(octagon[0][0], size, octagon[0][1]).func_181675_d();
		wr.func_181662_b(octagon[7][0], size, octagon[7][1]).func_181675_d();
		wr.func_181662_b(octagon[4][0], size, octagon[4][1]).func_181675_d();
		wr.func_181662_b(octagon[3][0], size, octagon[3][1]).func_181675_d();

		wr.func_181662_b(octagon[7][0], size, octagon[7][1]).func_181675_d();
		wr.func_181662_b(octagon[6][0], size, octagon[6][1]).func_181675_d();
		wr.func_181662_b(octagon[5][0], size, octagon[5][1]).func_181675_d();
		wr.func_181662_b(octagon[4][0], size, octagon[4][1]).func_181675_d();

		tes.func_78381_a();
		if (entity.active)
			GlStateManager.func_179099_b();
		GlStateManager.func_179098_w();
		GlStateManager.func_179121_F();
		GlStateManager.func_179137_b(-0.25, -1, 0);
		GlStateManager.func_179124_c(1, 1, 1);
		if (tex==null)
			tex = Minecraft.func_71410_x().func_147117_R().func_110572_b("minecraft:blocks/iron_block");

		wr.func_181668_a(GL11.GL_QUADS, DefaultVertexFormats.field_181707_g);
		ClientUtils.renderTexturedBox(wr, 0, 0, 0, .0625, 1, .0625, tex.func_94209_e(), tex.func_94206_g(), tex.func_94212_f(), tex.func_94210_h());
		ClientUtils.renderTexturedBox(wr, .0625, .9375, 0, .25, 1, .0625, tex.func_94209_e(), tex.func_94206_g(), tex.func_94212_f(), tex.func_94210_h());
		tes.func_78381_a();

		GlStateManager.func_179121_F();
	}
}
