/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.entities.EntityChemthrowerShot;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class EntityRenderChemthrowerShot extends Render
{
	public EntityRenderChemthrowerShot(RenderManager renderManager)
	{
		super(renderManager);
	}

	@Override
	public void func_76986_a(Entity entity, double x, double y, double z, float f0, float f1)
	{
		FluidStack f = ((EntityChemthrowerShot)entity).getFluid();
		if(f==null)
		{
			f = ((EntityChemthrowerShot)entity).getFluidSynced();
			if(f==null)
				return;
		}

		GlStateManager.func_179094_E();
		GlStateManager.func_179137_b(x, y, z);
		GlStateManager.func_179091_B();
		GlStateManager.func_179147_l();
		GlStateManager.func_187401_a(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
		RenderHelper.func_74518_a();

		Tessellator tessellator = ClientUtils.tes();

		GlStateManager.func_179114_b(180.0F - this.field_76990_c.field_78735_i, 0.0F, 1.0F, 0.0F);
		GlStateManager.func_179114_b(-this.field_76990_c.field_78732_j, 1.0F, 0.0F, 0.0F);

		TextureAtlasSprite sprite = ClientUtils.mc().func_147117_R().func_110572_b(f.getFluid().getStill(f).toString());
		if(sprite!=null)
		{
			int colour = f.getFluid().getColor(f);
			float a = (colour>>24&255)/255f;
			float r = (colour>>16&255)/255f;
			float g = (colour>>8&255)/255f;
			float b = (colour&255)/255f;
			ClientUtils.bindAtlas();
			int lightAll = entity.func_70070_b();
			int lightA = (lightAll>>0x10)&0xffff;
			int lightB = lightAll&0xffff;
			GlStateManager.func_179152_a(.25f, .25f, .25f);
			BufferBuilder worldrenderer = ClientUtils.tes().func_178180_c();
			worldrenderer.func_181668_a(GL11.GL_QUADS, DefaultVertexFormats.field_181711_k);
			worldrenderer.func_181662_b(-.25,-.25, 0).func_187315_a(sprite.func_94214_a(4), sprite.func_94207_b(4)).func_187314_a(lightA, lightB).func_181666_a(r,g,b,a).func_181675_d();
			worldrenderer.func_181662_b( .25,-.25, 0).func_187315_a(sprite.func_94214_a(0), sprite.func_94207_b(4)).func_187314_a(lightA, lightB).func_181666_a(r,g,b,a).func_181675_d();
			worldrenderer.func_181662_b( .25, .25, 0).func_187315_a(sprite.func_94214_a(0), sprite.func_94207_b(0)).func_187314_a(lightA, lightB).func_181666_a(r,g,b,a).func_181675_d();
			worldrenderer.func_181662_b(-.25, .25, 0).func_187315_a(sprite.func_94214_a(4), sprite.func_94207_b(0)).func_187314_a(lightA, lightB).func_181666_a(r,g,b,a).func_181675_d();
			tessellator.func_78381_a();
		}
		RenderHelper.func_74519_b();
		GlStateManager.func_179084_k();
		GlStateManager.func_179101_C();
		GlStateManager.func_179121_F();
	}

	@Override
	protected ResourceLocation func_110775_a(Entity p_110775_1_)
	{
		return new ResourceLocation("immersiveengineering:textures/models/bullet.png");
	}

}
