/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client.models.smart;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.energy.wires.WireApi;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_Connector;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityFeedthrough;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.*;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.lwjgl.util.vector.Vector3f;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

import static blusunrize.immersiveengineering.api.energy.wires.WireApi.INFOS;
import static blusunrize.immersiveengineering.common.blocks.metal.TileEntityFeedthrough.MIDDLE_STATE;
import static blusunrize.immersiveengineering.common.blocks.metal.TileEntityFeedthrough.WIRE;
import static net.minecraft.util.EnumFacing.Axis.Y;

public class FeedthroughModel implements IBakedModel
{
	public static final Cache<FeedthroughCacheKey, SpecificFeedthroughModel> CACHE = CacheBuilder.newBuilder()
			.expireAfterAccess(2, TimeUnit.MINUTES)
			.maximumSize(100)
			.build();
	public FeedthroughModel()
	{
		//TODO find a better place to put this
		Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter =
				(rl) -> Minecraft.func_71410_x().func_147117_R().func_110572_b(rl.toString());
		for (WireApi.FeedthroughModelInfo f : INFOS.values())
			f.onResourceReload(bakedTextureGetter, DefaultVertexFormats.field_176599_b);
	}


	@Nonnull
	@Override
	public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand)
	{
		IBlockState baseState = Blocks.field_150348_b.func_176223_P();
		WireType wire = WireType.COPPER;
		EnumFacing facing = EnumFacing.NORTH;
		int offset = 1;
		BlockPos p = null;
		World w = null;
		if (state instanceof IExtendedBlockState)
		{
			TileEntity te = ((IExtendedBlockState) state).getValue(IEProperties.TILEENTITY_PASSTHROUGH);
			if (te instanceof TileEntityFeedthrough)
			{
				baseState = ((TileEntityFeedthrough) te).stateForMiddle;
				wire = ((TileEntityFeedthrough) te).reference;
				facing = ((TileEntityFeedthrough) te).getFacing();
				offset = ((TileEntityFeedthrough) te).offset;
				p = te.func_174877_v();
				w = te.func_145831_w();
			}
		}
		final BlockPos pFinal = p;
		final World wFinal = w;
		FeedthroughCacheKey key = new FeedthroughCacheKey(wire, baseState, offset, facing, MinecraftForgeClient.getRenderLayer());
		try
		{
			return CACHE.get(key,
					()->new SpecificFeedthroughModel(key, wFinal, pFinal)).func_188616_a(state, side, rand);
		}
		catch (ExecutionException e)
		{
			e.printStackTrace();
			return ImmutableList.of();
		}
	}

	@Override
	public boolean func_177555_b()
	{
		return true;
	}

	@Override
	public boolean func_177556_c()
	{
		return true;
	}

	@Override
	public boolean func_188618_c()
	{
		return false;
	}

	@Nonnull
	@Override
	public TextureAtlasSprite func_177554_e()
	{
		return ModelLoader.White.INSTANCE;
	}

	private ItemCameraTransforms transform = new ItemCameraTransforms(
			new ItemTransformVec3f(new Vector3f(75, 45, 0), new Vector3f(0, 0, 0), new Vector3f(.375F, .375F, .375F)),//3Left
			new ItemTransformVec3f(new Vector3f(75, 45, 0), new Vector3f(0, 0, 0), new Vector3f(.375F, .375F, .375F)),//3Right
			new ItemTransformVec3f(new Vector3f(0, 225, 0), new Vector3f(0, 0, 0), new Vector3f(.4F, .4F, .4F)),//1Left
			new ItemTransformVec3f(new Vector3f(0, 45, 0), new Vector3f(0, 0, 0), new Vector3f(.4F, .4F, .4F)),//1Right
			new ItemTransformVec3f(new Vector3f(), new Vector3f(), new Vector3f()),//Head?
			new ItemTransformVec3f(new Vector3f(30, 225, 0), new Vector3f(0, 0, 0), new Vector3f(.6F, .6F, .6F)),//GUI
			new ItemTransformVec3f(new Vector3f(), new Vector3f(0, .3F, 0), new Vector3f(.25F, .25F, .25F)),//Ground
			new ItemTransformVec3f(new Vector3f(0, 180, 45), new Vector3f(0, 0, -.1875F), new Vector3f(.5F, .5F, .5F)));
	@Nonnull
	@Override
	public ItemCameraTransforms func_177552_f()
	{
		return transform;
	}

	private static final FeedthroughItemOverride INSTANCE = new FeedthroughItemOverride();

	@Nonnull
	@Override
	public ItemOverrideList func_188617_f()
	{
		return INSTANCE;
	}
	private static class FeedthroughItemOverride extends ItemOverrideList
	{

		private static Cache<ItemStack, FeedthroughModel> ITEM_MODEL_CACHE = CacheBuilder.newBuilder()
				.maximumSize(100)
				.expireAfterAccess(60, TimeUnit.SECONDS)
				.build();


		public FeedthroughItemOverride()
		{
			super(ImmutableList.of());
		}

		@Nonnull
		@Override
		public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity)
		{
			Item connItem = Item.func_150898_a(IEContent.blockConnectors);
			if (stack != null && stack.func_77973_b() == connItem && stack.func_77960_j() == BlockTypes_Connector.FEEDTHROUGH.ordinal())
			{
				try
				{
					return ITEM_MODEL_CACHE.get(stack, () ->
							new SpecificFeedthroughModel(stack));
				}
				catch (ExecutionException e)
				{
					e.printStackTrace();
				}
			}
			return originalModel;
		}

	}

	private static class FeedthroughCacheKey
	{
		final WireType type;
		final IBlockState baseState;
		final int offset;
		final EnumFacing facing;
		final BlockRenderLayer layer;

		public FeedthroughCacheKey(WireType type, IBlockState baseState, int offset, EnumFacing facing,
								   BlockRenderLayer layer)
		{
			this.type = type;
			this.baseState = baseState;
			this.offset = offset;
			this.facing = facing;
			this.layer = layer;
		}

		@Override
		public boolean equals(Object o)
		{
			if (this == o) return true;
			if (o == null || getClass() != o.getClass()) return false;
			FeedthroughCacheKey that = (FeedthroughCacheKey) o;
			return offset == that.offset &&
					Objects.equals(type, that.type) &&
					Utils.areStatesEqual(baseState, that.baseState, ImmutableSet.of(), false) &&
					facing == that.facing &&
					Objects.equals(layer, that.layer);
		}

		@Override
		public int hashCode()
		{
			int ret = Utils.hashBlockstate(baseState, ImmutableSet.of(), false);
			return 31*ret+Objects.hash(type, offset, facing, layer);
		}
	}
	private static class SpecificFeedthroughModel extends FeedthroughModel
	{
		List<List<BakedQuad>> quads = new ArrayList<>(6);
		public SpecificFeedthroughModel(ItemStack stack)
		{
			WireType w = WireType.getValue(ItemNBTHelper.getString(stack, WIRE));
			IBlockState state = Utils.stateFromNBT(ItemNBTHelper.getTagCompound(stack, MIDDLE_STATE));
			init(new FeedthroughCacheKey(w, state, Integer.MAX_VALUE, EnumFacing.NORTH, null), null, null);
		}

		public SpecificFeedthroughModel(FeedthroughCacheKey key, World w, BlockPos p)
		{
			init(key, w, p);
		}

		private void init(FeedthroughCacheKey k, @Nullable World world, @Nullable BlockPos pos)
		{
			IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a()
					.func_178125_b(k.baseState);
			Function<Integer, Integer> colorMultiplier = null;
			if (world!=null&&pos!=null)
			{
				BlockColors colors = Minecraft.func_71410_x().func_184125_al();
				colorMultiplier = (i)->colors.func_186724_a(k.baseState, world, pos, i);
			}
			else
			{
				ItemColors colors = Minecraft.func_71410_x().getItemColors();
				ItemStack stack = new ItemStack(k.baseState.func_177230_c(), 1, k.baseState.func_177230_c().func_176201_c(k.baseState));
				colorMultiplier = (i)->colors.func_186728_a(stack, i);
			}
			for (int j = 0; j < 7; j++)
			{
				EnumFacing side = j<6?EnumFacing.field_82609_l[j]:null;
				EnumFacing facing = k.facing;
				switch (k.offset)
				{
					case 0:
						if (k.layer==null||k.baseState.func_177230_c().canRenderInLayer(k.baseState, k.layer))
						{
							Function<BakedQuad, BakedQuad> tintTransformer = ApiUtils.transformQuad(new Matrix4(),
									DefaultVertexFormats.field_176599_b, colorMultiplier);
							quads.add(model.func_188616_a(k.baseState, side, 0).stream().map(tintTransformer)
									.collect(Collectors.toCollection(ArrayList::new)));
						}
						break;
					case 1:
						facing = facing.func_176734_d();
					case -1:
						if (k.layer==BlockRenderLayer.SOLID)
							quads.add(getConnQuads(facing, side, k.type, new Matrix4()));
						break;
					case Integer.MAX_VALUE:
						Matrix4 mat = new Matrix4();
						mat.translate(0, 0, 1);
						List<BakedQuad> all = new ArrayList<>(getConnQuads(facing, side, k.type, mat));
						mat = new Matrix4();
						mat.translate(0, 0, -1);
						all.addAll(getConnQuads(facing.func_176734_d(), side, k.type, mat));
						Function<BakedQuad, BakedQuad> tintTransformer = ApiUtils.transformQuad(new Matrix4(),
								DefaultVertexFormats.field_176599_b, colorMultiplier);
						all.addAll(model.func_188616_a(k.baseState, side, 0).stream().map(tintTransformer)
								.collect(Collectors.toCollection(ArrayList::new)));
						quads.add(all);
						break;
				}
				if (quads.size()<=j)
					quads.add(ImmutableList.of());
			}
		}

		private List<BakedQuad> getConnQuads(EnumFacing facing, EnumFacing side, WireType type, Matrix4 mat)
		{
			//connector model+feedthrough border
			WireApi.FeedthroughModelInfo info = INFOS.get(type);
			mat.translate(.5, .5, .5);
			if (facing.func_176740_k() == Y)
			{
				if (facing == EnumFacing.UP)
					mat.rotate(Math.PI, 1, 0, 0);
			}
			else
			{
				EnumFacing rotateAround = facing.func_176732_a(Y);
				mat.rotate(Math.PI / 2, rotateAround.func_82601_c(), rotateAround.func_96559_d(),
						rotateAround.func_82599_e());
			}
			mat.translate(-.5, -.5, -.5);
			List<BakedQuad> conn = new ArrayList<>(info.model.func_188616_a(null, side, 0));
			if (side == facing)
			{
				UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(DefaultVertexFormats.field_176599_b);
				TextureAtlasSprite tex = info.tex;
				builder.setTexture(tex);
				builder.setQuadOrientation(facing);
				builder.setQuadTint(-1);
				for (int i = 0; i < 4; i++)
				{
					int x = i < 2 ? 1 : 0;
					int y = i == 0 || i == 3 ? 1 : 0;
					builder.put(0, .25F + .5F * x, .001F, .25F + .5F * y);
					builder.put(1, 1, 1, 1, 1);
					builder.put(2, tex.func_94214_a(info.uvs[x * 2]), tex.func_94207_b(info.uvs[y * 2 + 1]));
					builder.put(3, 0, 1, 0);
					builder.put(4, 0);
				}
				conn.add(builder.build());
			}
			Function<BakedQuad, BakedQuad> transf = ApiUtils.transformQuad(mat, DefaultVertexFormats.field_176599_b,
					null);//I hope no one uses tint index for connectors
			if (transf != null)
				return conn.stream().map(transf).collect(Collectors.toList());
			else
				return conn;
		}

		@Nonnull
		@Override
		public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand)
		{
			return quads.get(side==null?6:side.func_176745_a());
		}
	}
}
