/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client.models;

import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderCase.ShaderLayer;
import blusunrize.immersiveengineering.api.shader.ShaderCaseMinecart;
import blusunrize.immersiveengineering.client.ClientUtils;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelMinecart;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

import java.util.ArrayList;
import java.util.HashMap;

public class ModelShaderMinecart extends ModelMinecart
{
	public static HashMap<Integer, ItemStack> shadedCarts = new HashMap<Integer, ItemStack>();
	public static boolean rendersReplaced = false;

	public ModelRenderer[] sideModelsMirrored = new ModelRenderer[7];
	//	public HashMap<IIcon,ModelShaderMinecart> remappedModels = new HashMap();

	public ModelShaderMinecart(ModelMinecart model)
	{
		super();
		this.field_78154_a = ClientUtils.copyModelRenderers(model, model.field_78154_a);
		this.sideModelsMirrored = ClientUtils.copyModelRenderers(model, model.field_78154_a);
		sideModelsMirrored[4].field_78809_i = true;
		ArrayList<ModelBox> newCubes = new ArrayList<ModelBox>();
		for(ModelBox cube : sideModelsMirrored[4].field_78804_l)
			newCubes.add(new ModelBox(sideModelsMirrored[4], 0,0, cube.field_78252_a,cube.field_78250_b,cube.field_78251_c, (int)(cube.field_78248_d-cube.field_78252_a),(int)(cube.field_78249_e-cube.field_78250_b),(int)(cube.field_78246_f-cube.field_78251_c), 0));
		sideModelsMirrored[4].field_78804_l = newCubes;
	}

	@Override
	public void func_78088_a(Entity entity, float f0, float f1, float f2, float f3, float f4, float f5)
	{
		ShaderCase sCase = null;
		ItemStack shader = ItemStack.field_190927_a;
		if(shadedCarts.containsKey(entity.func_145782_y()))
		{
			shader = shadedCarts.get(entity.func_145782_y());
			if(shader != null && !shader.func_190926_b() && shader.func_77973_b() instanceof IShaderItem)
				sCase = ((IShaderItem)shader.func_77973_b()).getShaderCase(shader,null,"immersiveengineering:minecart");
		}
		if(sCase!=null)
		{
			GL11.glEnable(GL11.GL_BLEND);
			OpenGlHelper.func_148821_a(770, 771, 0, 1);

			field_78154_a[5].field_78797_d = 4.0F - f2;
			sideModelsMirrored[5].field_78797_d = 4.0F - f2;
			for(int part=0;part<field_78154_a.length-1;part++)
				if(field_78154_a[part]!=null)
				{
					float scale = 1;
					ShaderLayer[] layers = sCase.getLayers();

					//identify part 1+2, they shouldn'T render with additional?!

					for(int pass=0; pass<layers.length; pass++)
						if(sCase.renderModelPartForPass(shader, null, ""+part, pass))
						{
							int col = sCase.getARGBColourModifier(shader, null, ""+part, pass);
							boolean upScale = pass!=layers.length-2;
							GL11.glScalef(scale,scale,scale);
							GL11.glColor4f((col>>16&255)/255f,(col>>8&255)/255f,(col&255)/255f,(col>>24&255)/255f);

//							if(pass==maxPasses-1)
//								ClientUtils.bindTexture("immersiveengineering:textures/models/shaders/minecart_uncoloured.png");
//							else if(pass==maxPasses-2 && ((ShaderCaseMinecart)sCase).additionalTexture!=null)
//								ClientUtils.bindTexture(sCase.getBaseTexturePath()+((ShaderCaseMinecart)sCase).additionalTexture+".png");
//							else if(pass==0)
//								ClientUtils.bindTexture("immersiveengineering:textures/models/shaders/minecart_0.png");
//							else
//							{
//								ClientUtils.bindTexture(sCase.getBaseTexturePath()+"1_"+sCase.getOverlayType()+".png");
//								upScale = false;
//							}

							ClientUtils.mc().func_110434_K().func_110577_a(sCase.getReplacementSprite(shader, null, ""+part, pass));

							sCase.modifyRender(shader, null, ""+part, pass, true, false);
								if(((ShaderCaseMinecart)sCase).mirrorSideForPass[pass])
									sideModelsMirrored[part].func_78785_a(f5);
								else
									field_78154_a[part].func_78785_a(f5);
							sCase.modifyRender(shader, null, ""+part, pass, false, false);

							GL11.glColor4f(1,1,1,1);
							GL11.glScalef(1/scale,1/scale,1/scale);
							if(upScale)
								scale += .001f;
						}
				}

			GL11.glDisable(GL11.GL_BLEND);
		}
		else
			super.func_78088_a(entity, f0, f1, f2, f3, f4, f5);
	}

//	ModelShaderMinecart getRemappedModel(IIcon icon)
//	{
//		if(remappedModels.containsKey(icon))
//			return remappedModels.get(icon);
//
//		ModelShaderMinecart modelRemapped = new ModelShaderMinecart(this);
//		int ox = MathHelper.floor_float(icon.getMinU() * ClientEventHandler.itemSheetWidth);
//		int oy = MathHelper.floor_float(icon.getMinV() * ClientEventHandler.itemSheetHeight);
//		modelRemapped.textureWidth = ClientEventHandler.itemSheetWidth;
//		modelRemapped.textureHeight = ClientEventHandler.itemSheetHeight;
//		for(ModelRenderer mr : modelRemapped.sideModels)
//			if(mr!=null)
//				mr.setTextureOffset(mr.textureOffsetX+ox, mr.textureOffsetX+oy);
//		for(ModelRenderer mr : modelRemapped.sideModelsMirrored)
//			if(mr!=null)
//				mr.setTextureOffset(mr.textureOffsetX+ox, mr.textureOffsetX+oy);
//		modelRemapped.sideModels = ClientUtils.copyModelRenderers(modelRemapped, modelRemapped.sideModels);
//		modelRemapped.sideModelsMirrored = ClientUtils.copyModelRenderers(modelRemapped, modelRemapped.sideModelsMirrored);
//		remappedModels.put(icon, modelRemapped);
//		return modelRemapped;
//	}
}
