/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client.models;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.items.ItemPowerpack;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;

import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;

/**
 * @author BluSunrize
 * @since 15.06.2017
 */
public class ModelPowerpack extends ModelIEArmorBase
{
	public ModelRenderer[] modelParts;
	public ModelRenderer[] colouredParts;

	public ModelPowerpack(float modelSize, float p_i1149_2_, int textureWidthIn, int textureHeightIn)
	{
		super(modelSize,p_i1149_2_,textureWidthIn,textureHeightIn);
		modelParts = new ModelRenderer[8];
		colouredParts = new ModelRenderer[4];

		this.modelParts[0] = new ModelRenderer(this, 40, 0);
		this.modelParts[0].func_78790_a(-4f, -5f, -2f, 8, 10, 3, 0);
		this.modelParts[0].func_78793_a(0, 5, 4);
		this.field_78115_e.func_78792_a(modelParts[0]);

		this.modelParts[1] = new ModelRenderer(this, 12, 0);
		this.modelParts[1].func_78790_a(-3f, -2f, -2f, 6, 4, 4, 0);
		this.modelParts[1].func_78793_a(0, 12, 4f);
		this.field_78115_e.func_78792_a(modelParts[1]);

		this.modelParts[2] = new ModelRenderer(this, 0, 0);
		this.modelParts[2].func_78790_a(-1f, -4f, -1f, 2, 8, 2, 0);
		this.modelParts[2].func_78793_a(-5f, 5, 3f);
		this.field_78115_e.func_78792_a(modelParts[2]);

		this.modelParts[3] = new ModelRenderer(this, 0, 0);
		this.modelParts[3].func_78790_a(-1f, -4.0f, -1f, 2, 8, 2, 0);
		this.modelParts[3].func_78793_a(5f, 5, 3f);
		this.modelParts[3].field_78808_h=3.14159f;
		this.field_78115_e.func_78792_a(modelParts[3]);


		ModelRenderer gauge = new ModelRenderer(this, 40, 13);
		gauge.func_78790_a(-.5f, -1.5f, -.5f, 1, 3, 1, 0);
		gauge.func_78793_a(-3f, 5.5f, 5f);
		this.field_78115_e.func_78792_a(gauge);

		gauge = new ModelRenderer(this, 40, 13);
		gauge.func_78790_a(-.5f, -1.5f, -.5f, 1, 3, 1, 0);
		gauge.func_78793_a(1f, 5.5f, 5f);
		this.field_78115_e.func_78792_a(gauge);

		gauge = new ModelRenderer(this, 44, 13);
		gauge.func_78790_a(-2f, -.5f, -.5f, 3, 1, 1, 0);
		gauge.func_78793_a(-.5f, 3.5f, 5f);
		this.field_78115_e.func_78792_a(gauge);

		gauge = new ModelRenderer(this, 44, 13);
		gauge.func_78790_a(-2f, -.5f, -.5f, 3, 1, 1, 0);
		gauge.func_78793_a(-.5f, 7.5f, 5f);
		this.field_78115_e.func_78792_a(gauge);

		this.modelParts[7] = new ModelRenderer(this, 52, 14);
		this.modelParts[7].func_78790_a(-.5f, -3.5f, -.5f, 1, 4, 1, -.25f);
		this.modelParts[7].func_78793_a(-1f, 7.625f, 5f);
		this.modelParts[7].field_78808_h = 0.7853975f;
		this.field_78115_e.func_78792_a(modelParts[7]);

		ModelRenderer connector = new ModelRenderer(this, 17, 9);
		connector.func_78790_a(-1f, -1.5f, -1.5f, 3, 3, 3, 0);
		connector.func_78793_a(-4.5f, 0f, 0f);
		this.modelParts[1].func_78792_a(connector);

		connector = new ModelRenderer(this, 17, 9);
		connector.func_78790_a(-1f, -1.5f, -1.5f, 3, 3, 3, -.375f);
		connector.func_78793_a(-6f, 0f, 0);
		this.modelParts[1].func_78792_a(connector);

		connector = new ModelRenderer(this, 29, 9);
		connector.func_78790_a(-1f, -1.5f, -1.5f, 1, 3, 3, 0);
		connector.func_78793_a(-6.25f, 0f, 0);
		this.modelParts[1].func_78792_a(connector);

		connector = new ModelRenderer(this, 12, 8);
		connector.func_78790_a(-.5f, -1f, -1f, 2, 2, 2, 0);
		connector.func_78793_a(-7.5f, 0f, 0f);
		this.modelParts[1].func_78792_a(connector);


		connector = new ModelRenderer(this, 17, 9);
		connector.func_78790_a(-1f, -1.5f, -1.5f, 3, 3, 3, 0);
		connector.func_78793_a(4.5f, 0f, 0f);
		connector.field_78796_g=3.14159f;
		this.modelParts[1].func_78792_a(connector);

		connector = new ModelRenderer(this, 17, 9);
		connector.func_78790_a(-1f, -1.5f, -1.5f, 3, 3, 3, -.375f);
		connector.func_78793_a(6f, 0f, 0);
		connector.field_78796_g=3.14159f;
		this.modelParts[1].func_78792_a(connector);

		connector = new ModelRenderer(this, 29, 9);
		connector.func_78790_a(-1f, -1.5f, -1.5f, 1, 3, 3, 0);
		connector.func_78793_a(6.25f, 0f, 0);
		connector.field_78796_g=3.14159f;
		this.modelParts[1].func_78792_a(connector);

		connector = new ModelRenderer(this, 12, 8);
		connector.func_78790_a(-.5f, -1f, -1f, 2, 2, 2, 0);
		connector.func_78793_a(7.5f, 0f, 0f);
		connector.field_78796_g=3.14159f;
		this.modelParts[1].func_78792_a(connector);

		for(int i=0; i<3; i++)
		{
			float pos = 3.125f-i*2.25f;
			ModelRenderer tube = new ModelRenderer(this, 56, 19);
			tube.func_78790_a(-1f, -1f, -1f, 2, 2, 2, -.25f);
			tube.func_78793_a(pos, 1, 5);
			tube.field_78795_f = (float)Math.toRadians(-45);
			this.field_78115_e.func_78792_a(tube);

			ModelRenderer tube2 = new ModelRenderer(this, 52, 18);
			tube2.func_78790_a(-.5f, -2f, -.5f, 1, 3, 1, 0);
			tube2.func_78793_a(0, -.5f, 0);
			tube.func_78792_a(tube2);

			tube2 = new ModelRenderer(this, 56, 15);
			tube2.func_78790_a(-1f, -2f, -1f, 2, 2, 2, 0);
			tube2.func_78793_a(0, -.75f, 0);
			tube.func_78792_a(tube2);

			tube2 = new ModelRenderer(this, 56, 13);
			tube2.func_78790_a(-.5f, -1f, -.5f, 1, 1, 1, 0);
			tube2.func_78793_a(0, -2.25f, 0);
			tube.func_78792_a(tube2);

			tube2 = new ModelRenderer(this, 56, 13);
			tube2.func_78790_a(-.5f, -1f, -.5f, 1, 1, 1, -.25f);
			tube2.func_78793_a(0, -3f, 0);
			tube.func_78792_a(tube2);
		}

		this.field_78116_c.field_78807_k = true;
		this.field_178720_f.field_78807_k=true;
		this.field_178724_i.field_78807_k = true;
		this.field_178723_h.field_78807_k = true;
		this.field_178722_k.field_78807_k = true;
		this.field_178721_j.field_78807_k = true;
	}

	@Override
	public void func_78088_a(Entity entity, float p_78088_2_, float p_78088_3_, float p_78088_4_, float p_78088_5_, float p_78088_6_, float scale)
	{
		if(entity instanceof EntityLivingBase)
		{
			ItemStack chest = ((EntityLivingBase)entity).func_184582_a(EntityEquipmentSlot.CHEST);
			float storage = 0;
			if(!chest.func_190926_b() && chest.func_77973_b() instanceof ItemArmor)
			{
				if(!(chest.func_77973_b() instanceof ItemPowerpack))
					chest = ItemNBTHelper.getItemStack(chest, "IE:Powerpack");

				if(chest.func_77973_b() instanceof ItemPowerpack)
				{
					float max = EnergyHelper.getMaxEnergyStored(chest);
					storage = max<=0?0:EnergyHelper.getEnergyStored(chest)/max;
				}
				this.modelParts[7].field_78808_h = 0.5235987f-(1.047197f*storage);
			}
		}
		GlStateManager.func_179147_l();
		super.func_78088_a(entity, p_78088_2_, p_78088_3_, p_78088_4_, p_78088_5_, p_78088_6_, scale);
		GlStateManager.func_179084_k();

		ClientUtils.bindTexture("immersiveengineering:textures/blocks/wire.png");
		GlStateManager.func_179094_E();
		if(entity instanceof EntityLivingBase)
			for(EnumHand hand : EnumHand.values())
			{
				ItemStack stack = ((EntityLivingBase)entity).func_184586_b(hand);
				if(!stack.func_190926_b() && EnergyHelper.isFluxItem(stack))
				{
					boolean right = (hand==EnumHand.MAIN_HAND)==(((EntityLivingBase)entity).func_184591_cq()==EnumHandSide.RIGHT);
					float angleX = (right?field_178723_h:field_178724_i).field_78795_f;
					float angleZ = (right?field_178723_h:field_178724_i).field_78808_h;
					String cacheKey = keyFormat.format(angleX)+"_"+keyFormat.format(angleZ);
					Vec3d[] vex = new Vec3d[0];
					try
					{
						vex = (right?catenaryCacheRight:catenaryCacheLeft).get(cacheKey, ()->
						{
							double armLength = .75f;
							double x = .3125+(right?1: -1)*armLength*Math.sin(angleZ);
							double y = armLength*Math.cos(angleX);
							double z = armLength*Math.sin(angleX);

							return ApiUtils.getConnectionCatenary(new Vec3d(.484375,-.75,.25), new Vec3d(x,-y,z), 1.5);
						});
					} catch(Exception e)
					{
					}

					float vStep = 1f/vex.length;
					int i=0;
					Tessellator tes = ClientUtils.tes();
					BufferBuilder worldrenderer = tes.func_178180_c();

//					float[] colour = {.7f,.42f,.25f,1};
					float[] colour = {.93f,.63f,.27f,1};
					worldrenderer.func_181668_a(GL11.GL_QUAD_STRIP, DefaultVertexFormats.field_181709_i);
					for(Vec3d v : vex)
					{
						worldrenderer.func_181662_b((right?-v.field_72450_a:v.field_72450_a)-.015625, -v.field_72448_b, v.field_72449_c).func_187315_a(vStep*i,0).func_181666_a(colour[0],colour[1],colour[2],colour[3]).func_181675_d();
						worldrenderer.func_181662_b((right?-v.field_72450_a:v.field_72450_a)+.015625, -v.field_72448_b, v.field_72449_c).func_187315_a(vStep*i++,1).func_181666_a(colour[0],colour[1],colour[2],colour[3]).func_181675_d();
					}
					tes.func_78381_a();
					worldrenderer.func_181668_a(GL11.GL_QUAD_STRIP, DefaultVertexFormats.field_181709_i);
					i=0;
					for(Vec3d v : vex)
					{
						worldrenderer.func_181662_b((right?-v.field_72450_a:v.field_72450_a), -v.field_72448_b-.015625, v.field_72449_c).func_187315_a(vStep*i,0).func_181666_a(colour[0],colour[1],colour[2],colour[3]).func_181675_d();
						worldrenderer.func_181662_b((right?-v.field_72450_a:v.field_72450_a), -v.field_72448_b+.015625, v.field_72449_c).func_187315_a(vStep*i++,1).func_181666_a(colour[0],colour[1],colour[2],colour[3]).func_181675_d();
					}
					tes.func_78381_a();
				}
			}
		GlStateManager.func_179121_F();
	}

	static final DecimalFormat keyFormat = new DecimalFormat("0.0000");
	public static final Cache<String,  Vec3d[]> catenaryCacheLeft = CacheBuilder.newBuilder()
			.expireAfterAccess(5, TimeUnit.MINUTES)
			.build();
	public static final Cache<String,  Vec3d[]> catenaryCacheRight = CacheBuilder.newBuilder()
			.expireAfterAccess(5, TimeUnit.MINUTES)
			.build();

	static ModelPowerpack modelInstance;
	public static ModelPowerpack getModel()
	{
		if(modelInstance==null)
			modelInstance = new ModelPowerpack(.0625f,0,64,32);
		return modelInstance;
	}
}
