/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client.models;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import com.google.common.collect.ImmutableList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms.TransformType;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

/**
 * @author BluSunrize - 12.08.2016
 */
public class ModelItemDynamicOverride implements IBakedModel
{
	IBakedModel itemModel;
	ImmutableList<BakedQuad> quads;

	public ModelItemDynamicOverride(IBakedModel itemModel, @Nullable List<ResourceLocation> textures)
	{
		this.itemModel = itemModel;
		if(textures != null)
		{
			ImmutableList.Builder<BakedQuad> builder = ImmutableList.builder();
			Optional<TRSRTransformation> transform = Optional.of(TRSRTransformation.identity());
			for(int i = 0; i < textures.size(); i++)
				builder.addAll(ItemLayerModel.getQuadsForSprite(i, ClientUtils.getSprite(textures.get(i)), DefaultVertexFormats.field_176599_b, transform));
			quads = builder.build();
		}
	}

	@Override
	public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand)
	{
		if(quads != null)
			return quads;
		return itemModel.func_188616_a(state, side, rand);
	}

	@Override
	public boolean func_177555_b()
	{
		return itemModel.func_177555_b();
	}

	@Override
	public boolean func_177556_c()
	{
		return itemModel.func_177556_c();
	}

	@Override
	public boolean func_188618_c()
	{
		return itemModel.func_188618_c();
	}

	@Override
	public TextureAtlasSprite func_177554_e()
	{
		return itemModel.func_177554_e();
	}

	@Override
	public ItemCameraTransforms func_177552_f()
	{
		return itemModel.func_177552_f();
	}

	@Override
	public ItemOverrideList func_188617_f()
	{
		return dynamicOverrides;
	}

	@Override
	public Pair<? extends IBakedModel, Matrix4f> handlePerspective(TransformType cameraTransformType)
	{
		return Pair.of(this, itemModel.handlePerspective(cameraTransformType).getRight());
	}

	public static final HashMap<String, IBakedModel> modelCache = new HashMap();
	static ItemOverrideList dynamicOverrides = new ItemOverrideList(new ArrayList())
	{

		@Override
		public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity)
		{
			if(!stack.func_190926_b() && stack.func_77973_b() instanceof IEItemInterfaces.ITextureOverride)
			{
				IEItemInterfaces.ITextureOverride texOverride = (IEItemInterfaces.ITextureOverride) stack.func_77973_b();
				String key = texOverride.getModelCacheKey(stack);
				if(key != null)
				{
					IBakedModel model = modelCache.get(key);
					if(model == null)
					{
						model = new ModelItemDynamicOverride(originalModel, texOverride.getTextures(stack, key));
						modelCache.put(key, model);
					}
					return model;
				}
			}
			return originalModel;
		}
	};
}
