/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client.models;

import blusunrize.immersiveengineering.client.ClientUtils;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.util.math.MathHelper;

public abstract class ModelIEArmorBase extends ModelBiped
{
	public ModelIEArmorBase(float modelSize, float p_i1149_2_, int textureWidthIn, int textureHeightIn)
	{
		super(modelSize, p_i1149_2_, textureWidthIn, textureHeightIn);
	}
	
	@Override
	public void func_78088_a(Entity entity, float p_78088_2_, float p_78088_3_, float p_78088_4_, float p_78088_5_, float p_78088_6_, float scale)
	{
		if(entity instanceof EntityLivingBase)
		{
			field_78091_s = ((EntityLivingBase)entity).func_70631_g_();
			field_78117_n = entity.func_70093_af();
			field_78093_q = entity.func_184218_aH();
			this.func_78086_a((EntityLivingBase)entity, p_78088_2_, p_78088_3_, ClientUtils.timer().field_194147_b);
		}
		super.func_78088_a(entity, p_78088_2_, p_78088_3_, p_78088_4_, p_78088_5_, p_78088_6_, scale);
	}

	@Override
	public void func_78087_a(float p_78087_1_, float p_78087_2_, float p_78087_3_, float p_78087_4_, float p_78087_5_, float p_78087_6_, Entity entity)
	{
		if(entity instanceof EntityLivingBase)
			field_78095_p = ((EntityLivingBase)entity).func_70678_g(ClientUtils.timer().field_194147_b);
		if(entity instanceof EntityArmorStand)
			setRotationAnglesStand(p_78087_1_, p_78087_2_, p_78087_3_, p_78087_4_, p_78087_5_, p_78087_6_, entity);
		else if(entity instanceof EntitySkeleton || entity instanceof EntityZombie)
			setRotationAnglesZombie(p_78087_1_, p_78087_2_, p_78087_3_, p_78087_4_, p_78087_5_, p_78087_6_, entity);
		else
			super.func_78087_a(p_78087_1_, p_78087_2_, p_78087_3_, p_78087_4_, p_78087_5_, p_78087_6_, entity);
	}

	public void setRotationAnglesZombie(float p_78087_1_, float p_78087_2_, float p_78087_3_, float p_78087_4_, float p_78087_5_, float p_78087_6_, Entity p_78087_7_)
	{
		super.func_78087_a(p_78087_1_, p_78087_2_, p_78087_3_, p_78087_4_, p_78087_5_, p_78087_6_, p_78087_7_);
		float f6 = MathHelper.func_76126_a(this.field_78095_p * 3.141593F);
		float f7 = MathHelper.func_76126_a((1.0F - (1.0F - this.field_78095_p) * (1.0F - this.field_78095_p)) * 3.141593F);
		this.field_178723_h.field_78808_h = 0.0F;
		this.field_178724_i.field_78808_h = 0.0F;
		this.field_178723_h.field_78796_g = (-(0.1F - f6 * 0.6F));
		this.field_178724_i.field_78796_g = (0.1F - f6 * 0.6F);
		this.field_178723_h.field_78795_f = -1.570796F;
		this.field_178724_i.field_78795_f = -1.570796F;
		this.field_178723_h.field_78795_f -= f6 * 1.2F - f7 * 0.4F;
		this.field_178724_i.field_78795_f -= f6 * 1.2F - f7 * 0.4F;
		this.field_178723_h.field_78808_h += MathHelper.func_76134_b(p_78087_3_ * 0.09F) * 0.05F + 0.05F;
		this.field_178724_i.field_78808_h -= MathHelper.func_76134_b(p_78087_3_ * 0.09F) * 0.05F + 0.05F;
		this.field_178723_h.field_78795_f += MathHelper.func_76126_a(p_78087_3_ * 0.067F) * 0.05F;
		this.field_178724_i.field_78795_f -= MathHelper.func_76126_a(p_78087_3_ * 0.067F) * 0.05F;
	}

	public void setRotationAnglesStand(float p_78087_1_, float p_78087_2_, float p_78087_3_, float p_78087_4_, float p_78087_5_, float p_78087_6_, Entity entity)
	{
		if ((entity instanceof EntityArmorStand))
		{
			EntityArmorStand entityarmorstand = (EntityArmorStand)entity;
			this.field_78116_c.field_78795_f = (0.01745329F * entityarmorstand.func_175418_s().func_179415_b());
			this.field_78116_c.field_78796_g = (0.01745329F * entityarmorstand.func_175418_s().func_179416_c());
			this.field_78116_c.field_78808_h = (0.01745329F * entityarmorstand.func_175418_s().func_179413_d());
			this.field_78116_c.func_78793_a(0.0F, 1.0F, 0.0F);
			this.field_78115_e.field_78795_f = (0.01745329F * entityarmorstand.func_175408_t().func_179415_b());
			this.field_78115_e.field_78796_g = (0.01745329F * entityarmorstand.func_175408_t().func_179416_c());
			this.field_78115_e.field_78808_h = (0.01745329F * entityarmorstand.func_175408_t().func_179413_d());
			this.field_178724_i.field_78795_f = (0.01745329F * entityarmorstand.func_175404_u().func_179415_b());
			this.field_178724_i.field_78796_g = (0.01745329F * entityarmorstand.func_175404_u().func_179416_c());
			this.field_178724_i.field_78808_h = (0.01745329F * entityarmorstand.func_175404_u().func_179413_d());
			this.field_178723_h.field_78795_f = (0.01745329F * entityarmorstand.func_175411_v().func_179415_b());
			this.field_178723_h.field_78796_g = (0.01745329F * entityarmorstand.func_175411_v().func_179416_c());
			this.field_178723_h.field_78808_h = (0.01745329F * entityarmorstand.func_175411_v().func_179413_d());
			this.field_178722_k.field_78795_f = (0.01745329F * entityarmorstand.func_175403_w().func_179415_b());
			this.field_178722_k.field_78796_g = (0.01745329F * entityarmorstand.func_175403_w().func_179416_c());
			this.field_178722_k.field_78808_h = (0.01745329F * entityarmorstand.func_175403_w().func_179413_d());
			this.field_178722_k.func_78793_a(1.9F, 11.0F, 0.0F);
			this.field_178721_j.field_78795_f = (0.01745329F * entityarmorstand.func_175407_x().func_179415_b());
			this.field_178721_j.field_78796_g = (0.01745329F * entityarmorstand.func_175407_x().func_179416_c());
			this.field_178721_j.field_78808_h = (0.01745329F * entityarmorstand.func_175407_x().func_179413_d());
			this.field_178721_j.func_78793_a(-1.9F, 11.0F, 0.0F);
			func_178685_a(this.field_78116_c, this.field_178720_f);
		}
	}
}
