/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client.manual;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.IEItemFontRender;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.Config.IEConfig;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.network.MessageShaderManual;
import blusunrize.immersiveengineering.common.util.network.MessageShaderManual.MessageType;
import blusunrize.lib.manual.IManualPage;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import org.lwjgl.input.Keyboard;

import java.util.LinkedHashSet;
import java.util.Locale;

import blusunrize.lib.manual.ManualInstance.ManualEntry;
import blusunrize.lib.manual.ManualInstance.ManualLink;

public class IEManualInstance extends ManualInstance
{
	public IEManualInstance()
	{
		super(new IEItemFontRender(), "immersiveengineering:textures/gui/manual.png");
		this.fontRenderer.field_78285_g[0 + 6] = Lib.COLOUR_I_ImmersiveOrange;
		this.fontRenderer.field_78285_g[16 + 6] = Lib.COLOUR_I_ImmersiveOrangeShadow;
		((IEItemFontRender)this.fontRenderer).createColourBackup();
		if (Minecraft.func_71410_x().field_71474_y.field_74363_ab != null)
		{
			this.fontRenderer.func_78264_a(ClientUtils.mc().func_135016_M().func_135042_a());
			this.fontRenderer.func_78275_b(ClientUtils.mc().func_135016_M().func_135044_b());
		}
		((IReloadableResourceManager)ClientUtils.mc().func_110442_L()).func_110542_a(this.fontRenderer);
	}

	@Override
	public String formatText(String s)
	{
		if(!s.contains(" "))//if it contains spaces, it's probably already translated.
		{
			s = ManualUtils.attemptStringTranslation("ie.manual.entry.%s",s);
//			String translKey =  + s;
//			String translated = I18n.format(translKey);
//			if(!translKey.equals(translated))
//				s = translated;
		}
		String splitKey = ";";

		s = s.replaceAll("<br>", "\n");
		int start;
		int overflow=0;
		while( (start=s.indexOf("<config"))>=0 && overflow<50)
		{
			overflow++;
			int end = s.indexOf(">", start);
			String rep = s.substring(start, end+1);
			String[] segment = rep.substring(0,rep.length()-1).split(splitKey);
			if(segment.length<3)
				break;
			String result = "";
			if(segment[1].equalsIgnoreCase("b"))
			{
				if(segment.length>3)
					result = (Config.manual_bool.get(segment[2])?segment[3]: segment.length>4?segment[4]:"");
				else
					result = ""+ Config.manual_bool.get(segment[2]);
			}
			else if(segment[1].equalsIgnoreCase("i"))
				result = ""+ Config.manual_int.get(segment[2]);
			else if(segment[1].equalsIgnoreCase("iA"))
			{
				int[] iA = Config.manual_intA.get(segment[2]);
				if(segment.length>3)
					try{
						if(segment[3].startsWith("l"))
						{
							int limiter = Integer.parseInt(segment[3].substring(1));
							for(int i=0; i<limiter; i++)
								result += (i>0?", ":"")+iA[i];
						}
						else
						{
							int idx = Integer.parseInt(segment[3]);
							result = ""+iA[idx];
						}
					}catch(Exception ex){
						break;
					}
				else
					for(int i=0; i<iA.length; i++)
						result += (i>0?", ":"")+iA[i];
			}
			else if(segment[1].equalsIgnoreCase("d"))
				result = ""+ Config.manual_double.get(segment[2]);
			else if(segment[1].equalsIgnoreCase("dA"))
			{
				double[] iD = Config.manual_doubleA.get(segment[2]);
				if(segment.length>3)
					try{
						int idx = Integer.parseInt(segment[3]);
						result = ""+Utils.formatDouble(iD[idx], "##0.0##");
					}catch(Exception ex){
						break;
					}
				else
					for(int i=0; i<iD.length; i++)
						result += (i>0?", ":"")+Utils.formatDouble(iD[i], "##0.0##");
			}

			s = s.replaceFirst(rep, result);
		}
		overflow=0;
		while( (start=s.indexOf("<dim"))>=0 && overflow<50)
		{
			overflow++;
			int end = s.indexOf(">", start);
			String rep = s.substring(start, end+1);
			String[] segment = rep.substring(0,rep.length()-1).split(splitKey);
			if(segment.length<2)
				break;
			String result = "";
			try{
				int dim = Integer.parseInt(segment[1]);
				World world = DimensionManager.getWorld(dim);
				if(world!=null && world.field_73011_w!=null)
				{
					String name = world.field_73011_w.func_186058_p().func_186065_b();
					if(name.toLowerCase(Locale.ENGLISH).startsWith("the ") || name.toLowerCase(Locale.ENGLISH).startsWith("the_"))
						name = name.substring(4,5).toUpperCase()+name.substring(5);
					result = name;
				}
				else
					result = "Dimension "+dim;
			}catch(Exception ex){
				ex.printStackTrace();
			}
			s = s.replaceFirst(rep, result);
		}

		overflow=0;
		while( (start=s.indexOf("<keybind"))>=0 && overflow<50)
		{
			overflow++;
			int end = s.indexOf(">", start);
			String rep = s.substring(start, end+1);
			String[] segment = rep.substring(0,rep.length()-1).split(splitKey);
			if(segment.length<2)
				break;
			String result = "";
			for(KeyBinding kb : ClientUtils.mc().field_71474_y.field_74324_K)
				if(segment[1].equalsIgnoreCase(kb.func_151464_g()))
				{
					result = Utils.toCamelCase(Keyboard.getKeyName(kb.func_151463_i()));
					break;
				}
			s = s.replaceFirst(rep, result);
		}

		if(improveReadability())
		{
			overflow=0;
			int end = 0;
			while( (start=s.indexOf(TextFormatting.RESET.toString(),end))>=0 && overflow<50)
			{
				overflow++;
				end = start+ TextFormatting.RESET.toString().length();
				s = s.substring(0,end)+ TextFormatting.BOLD.toString()+s.substring(end);
			}
			s = TextFormatting.BOLD + s;
		}
		return s;
	}

	@Override
	public void openManual()
	{
		if(improveReadability())
		{
			((IEItemFontRender)this.fontRenderer).spacingModifier=-.5f;
			((IEItemFontRender)this.fontRenderer).customSpaceWidth=1f;
		}
	}
	@Override
	public void titleRenderPre()
	{
		if(improveReadability())
		{
			((IEItemFontRender)this.fontRenderer).spacingModifier=.5f;
			((IEItemFontRender)this.fontRenderer).customSpaceWidth=4f;
		}
	}
	@Override
	public void titleRenderPost()
	{
		if(improveReadability())
		{
			((IEItemFontRender)this.fontRenderer).spacingModifier=-.5f;
			((IEItemFontRender)this.fontRenderer).customSpaceWidth=1f;
		}
	}
	@Override
	public void entryRenderPre()
	{
		if(improveReadability())
			((IEItemFontRender)this.fontRenderer).verticalBoldness=true;
	}
	@Override
	public void entryRenderPost()
	{
		if(improveReadability())
			((IEItemFontRender)this.fontRenderer).verticalBoldness=false;
	}
	@Override
	public void tooltipRenderPre()
	{
		if(improveReadability())
		{
			((IEItemFontRender)this.fontRenderer).spacingModifier=0f;
			((IEItemFontRender)this.fontRenderer).customSpaceWidth=4f;
			((IEItemFontRender)this.fontRenderer).verticalBoldness=false;
		}
	}
	@Override
	public void tooltipRenderPost()
	{
		if(improveReadability())
		{
			((IEItemFontRender)this.fontRenderer).spacingModifier=-.5f;
			((IEItemFontRender)this.fontRenderer).customSpaceWidth=1f;
			((IEItemFontRender)this.fontRenderer).verticalBoldness=true;
		}
	}


	@Override
	public String getManualName()
	{
		return I18n.func_135052_a("item.immersiveengineering.tool.manual.name");
	}
	@Override
	public void addEntry(String name, String category, IManualPage... pages)
	{
		super.addEntry(name, category, pages);
		if(!categorySet.contains(category))
			categorySet.add(category);
	}
	LinkedHashSet<String> categorySet = new LinkedHashSet<String>();
	@Override
	public String[] getSortedCategoryList()
	{
		return categorySet.toArray(new String[categorySet.size()]);
	}
	@Override
	public String formatCategoryName(String s)
	{
		return (improveReadability()? TextFormatting.BOLD:"")+ I18n.func_135052_a("ie.manual.category."+s+".name");
	}
	@Override
	public String formatEntryName(String s)
	{
		String unformatted = "ie.manual.entry." + s + ".name";
		String formatted = I18n.func_135052_a(unformatted);
//		return "\uD83D\uDCBB";
		return (improveReadability() ? TextFormatting.BOLD : "") + (unformatted.equals(formatted) ? s : formatted);
	}
	@Override
	public String formatEntrySubtext(String s)
	{
		String unformatted = "ie.manual.entry." + s + ".subtext";
		String formatted = I18n.func_135052_a(unformatted);
		return unformatted.equals(formatted) ? "" : formatted;
	}
	@Override
	public boolean showEntryInList(ManualEntry entry)
	{
		if(entry!=null && ManualHelper.CAT_UPDATE.equalsIgnoreCase(entry.getCategory()))
			return IEConfig.showUpdateNews;
		return !(entry != null && "shaderList".equalsIgnoreCase(entry.getName()));
	}
	@Override
	public boolean showCategoryInList(String category)
	{
		return true;
	}

	@Override
	public String formatLink(ManualLink link)
	{
		return TextFormatting.GOLD+"  -> "+formatEntryName(link.getKey())+", "+(link.getPage()+1);
	}

	@Override
	public void openEntry(String entry)
	{
		if("shaderList".equalsIgnoreCase(entry))
			ImmersiveEngineering.packetHandler.sendToServer(new MessageShaderManual(MessageType.SYNC,ClientUtils.mc().field_71439_g.func_70005_c_()));
	}

	@Override
	public int getTitleColour()
	{
		return 0xf78034;
	}
	@Override
	public int getSubTitleColour()
	{
		return 0xf78034;
	}
	@Override
	public int getTextColour()
	{
		return improveReadability()?0:0x555555;
	}
	@Override
	public int getHighlightColour()
	{
		return 0xd4804a;
	}
	@Override
	public int getPagenumberColour()
	{
		return 0x9c917c;
	}

	@Override
	public boolean allowGuiRescale()
	{
		return IEConfig.adjustManualScale;
	}
	@Override
	public boolean improveReadability()
	{
		return IEConfig.badEyesight;
	}
}
