/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client.gui.elements;

import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.client.ClientUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;

public class GuiButtonState extends GuiButtonIE
{
	public boolean state;
	protected final int offsetDir;
	public int[] textOffset = {0,0};
	public GuiButtonState(int buttonId, int x, int y, int w, int h, String name, boolean state, String texture, int u, int v, int offsetDir)
	{
		super(buttonId, x, y, w,h, name, texture, u,v);
		this.state = state;
		this.offsetDir = offsetDir;
		textOffset = new int[]{field_146120_f+1,field_146121_g/2-3};
	}

	@Override
	public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks)
	{
		if(this.field_146125_m)
		{
			ClientUtils.bindTexture(texture);
			FontRenderer fontrenderer = mc.field_71466_p;
			GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
			this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
			GlStateManager.func_179147_l();
			GlStateManager.func_179120_a(770, 771, 1, 0);
			GlStateManager.func_179112_b(770, 771);
			int u = texU + (!state?0: offsetDir==0?field_146120_f: offsetDir==2?-field_146120_f: 0);
			int v = texV + (!state?0: offsetDir==1?field_146121_g: offsetDir==3?-field_146121_g: 0);
			this.func_73729_b(field_146128_h,field_146129_i, u,v, field_146120_f,field_146121_g);
			this.func_146119_b(mc, mouseX, mouseY);
			if(field_146126_j!=null && !field_146126_j.isEmpty())
			{
				int txtCol = 0xE0E0E0;
				if(!this.field_146124_l)
					txtCol = 0xA0A0A0;
				else if(this.field_146123_n)
					txtCol = Lib.COLOUR_I_ImmersiveOrange;
				this.func_73731_b(fontrenderer, field_146126_j, field_146128_h+textOffset[0], field_146129_i+textOffset[1], txtCol);
			}
		}
	}

	@Override
	public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY)
	{
		boolean b = super.func_146116_c(mc, mouseX, mouseY);
		if(b)
			this.state = !state;
		return b;
	}
}
