/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client.gui.elements;

import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.client.ClientUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;

public class GuiButtonIE extends GuiButton
{
	protected final String texture;
	protected final int texU;
	protected final int texV;
	public GuiButtonIE(int buttonId, int x, int y, int w, int h, String name, String texture, int u, int v)
	{
		super(buttonId, x, y, w,h, name);
		this.texture = texture;
		this.texU = u;
		this.texV = v;
	}

	int[] hoverOffset;
	public GuiButtonIE setHoverOffset(int x, int y)
	{
		this.hoverOffset = new int[]{x,y};
		return this;
	}

	@Override
	public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks)
	{
		if(this.field_146125_m)
		{
			ClientUtils.bindTexture(texture);
			FontRenderer fontrenderer = mc.field_71466_p;
			GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
			this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
			GlStateManager.func_179147_l();
			GlStateManager.func_179120_a(770, 771, 1, 0);
			GlStateManager.func_179112_b(770, 771);
			if(hoverOffset!=null && this.field_146123_n)
				this.func_73729_b(field_146128_h,field_146129_i, texU+hoverOffset[0],texV+hoverOffset[1], field_146120_f,field_146121_g);
			else
				this.func_73729_b(field_146128_h,field_146129_i, texU,texV, field_146120_f,field_146121_g);
			this.func_146119_b(mc, mouseX, mouseY);
			if(field_146126_j!=null && !field_146126_j.isEmpty())
			{
				int txtCol = 0xE0E0E0;
				if(!this.field_146124_l)
					txtCol = 0xA0A0A0;
				else if(this.field_146123_n)
					txtCol = Lib.COLOUR_I_ImmersiveOrange;
				this.func_73732_a(fontrenderer, this.field_146126_j, this.field_146128_h+this.field_146120_f/2, this.field_146129_i+(this.field_146121_g-8)/ 2, txtCol);
			}
		}
	}
}
