/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonCheckbox;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonIE;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonState;
import blusunrize.immersiveengineering.client.gui.elements.GuiReactiveList;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityTurret;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityTurretChem;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityTurretGun;
import blusunrize.immersiveengineering.common.gui.ContainerTurret;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

import java.io.IOException;
import java.util.ArrayList;

public class GuiTurret extends GuiIEContainerBase
{
	public TileEntityTurret tile;
	private GuiTextField nameField;

	public GuiTurret(InventoryPlayer inventoryPlayer, TileEntityTurret tile)
	{
		super(new ContainerTurret(inventoryPlayer, tile));
		this.tile=tile;
		this.field_147000_g = 190;
	}

	@Override
	public void func_73866_w_()
	{
		super.func_73866_w_();
		Keyboard.enableRepeatEvents(true);
		this.nameField = new GuiTextField(0, this.field_146289_q, field_147003_i+11,field_147009_r+88,58,12);
		this.nameField.func_146193_g(-1);
		this.nameField.func_146204_h(-1);
		this.nameField.func_146185_a(false);
		this.nameField.func_146203_f(30);

		this.field_146292_n.clear();
		this.field_146292_n.add(new GuiReactiveList(this, 0, field_147003_i+10,field_147009_r+10, 60,72, tile.targetList.toArray(new String[tile.targetList.size()])).setPadding(0,0,2,2).setFormatting(1,false));
		this.field_146292_n.add(new GuiButtonIE(1, field_147003_i+74,field_147009_r+84, 24,16, I18n.func_135052_a(Lib.GUI_CONFIG+"turret.add"), "immersiveengineering:textures/gui/turret.png", 176,65));
		this.field_146292_n.add(new GuiButtonCheckbox(2, field_147003_i+74,field_147009_r+10, I18n.func_135052_a(Lib.GUI_CONFIG+"turret.blacklist"), !tile.whitelist));
		this.field_146292_n.add(new GuiButtonCheckbox(3, field_147003_i+74,field_147009_r+26, I18n.func_135052_a(Lib.GUI_CONFIG+"turret.animals"), tile.attackAnimals));
		this.field_146292_n.add(new GuiButtonCheckbox(4, field_147003_i+74,field_147009_r+42, I18n.func_135052_a(Lib.GUI_CONFIG+"turret.players"), tile.attackPlayers));
		this.field_146292_n.add(new GuiButtonCheckbox(5, field_147003_i+74,field_147009_r+58, I18n.func_135052_a(Lib.GUI_CONFIG+"turret.neutrals"), tile.attackNeutrals));

		if(tile instanceof TileEntityTurretChem)
			this.field_146292_n.add(new GuiButtonState(6, field_147003_i+135,field_147009_r+68, 14,14, null, ((TileEntityTurretChem)tile).ignite, "immersiveengineering:textures/gui/turret.png",176,51, 0));
		else if(tile instanceof TileEntityTurretGun)
			this.field_146292_n.add(new GuiButtonState(6, field_147003_i+134,field_147009_r+31, 16,16, null, ((TileEntityTurretGun)tile).expelCasings, "immersiveengineering:textures/gui/turret.png",176,81, 0));

	}
	@Override
	protected void func_146284_a(GuiButton button)
	{
		NBTTagCompound tag = new NBTTagCompound();
		int listOffset = -1;
		if(button.field_146127_k==0)
		{
			int rem = ((GuiReactiveList)button).selectedOption;
			tile.targetList.remove(rem);
			tag.func_74768_a("remove", rem);
			listOffset = ((GuiReactiveList)button).getOffset()-1;
		}
		else if(button.field_146127_k==1 && !this.nameField.func_146179_b().isEmpty())
		{
			String name = this.nameField.func_146179_b();
			if(!tile.targetList.contains(name))
			{
				listOffset = ((GuiReactiveList)field_146292_n.get(0)).getMaxOffset();
				tag.func_74778_a("add", name);
				tile.targetList.add(name);
			}
			this.nameField.func_146180_a("");
		}
		else if(button.field_146127_k==2)
		{
			tile.whitelist = !((GuiButtonState)button).state;
			tag.func_74757_a("whitelist", tile.whitelist);
		}
		else if(button.field_146127_k==3)
		{
			tile.attackAnimals = ((GuiButtonState)button).state;
			tag.func_74757_a("attackAnimals", tile.attackAnimals);
		}
		else if(button.field_146127_k==4)
		{
			tile.attackPlayers = ((GuiButtonState)button).state;
			tag.func_74757_a("attackPlayers", tile.attackPlayers);
		}
		else if(button.field_146127_k==5)
		{
			tile.attackNeutrals = ((GuiButtonState)button).state;
			tag.func_74757_a("attackNeutrals", tile.attackNeutrals);
		}
		else if(button.field_146127_k==6 && tile instanceof TileEntityTurretChem)
		{
			((TileEntityTurretChem)tile).ignite = ((GuiButtonState)button).state;
			tag.func_74757_a("ignite", ((TileEntityTurretChem)tile).ignite);
		}
		else if(button.field_146127_k==6 && tile instanceof TileEntityTurretGun)
		{
			((TileEntityTurretGun)tile).expelCasings = ((GuiButtonState)button).state;
			tag.func_74757_a("expelCasings", ((TileEntityTurretGun)tile).expelCasings);
		}
		if(!tag.func_82582_d())
		{
			ImmersiveEngineering.packetHandler.sendToServer(new MessageTileSync(tile, tag));
			this.func_73866_w_();
			if(listOffset>=0)
				((GuiReactiveList)this.field_146292_n.get(0)).setOffset(listOffset);
		}
	}

	@Override
	public void func_73863_a(int mx, int my, float partial)
	{
		super.func_73863_a(mx, my, partial);
		this.nameField.func_146194_f();

		ArrayList<String> tooltip = new ArrayList<String>();
		if(mx>=field_147003_i+158&&mx<field_147003_i+165 && my>=field_147009_r+16&&my<field_147009_r+62)
			tooltip.add(tile.getEnergyStored(null)+"/"+tile.getMaxEnergyStored(null)+" RF");

		if(tile instanceof TileEntityTurretChem)
		{
			ClientUtils.handleGuiTank(((TileEntityTurretChem)tile).tank, field_147003_i+134,field_147009_r+16,16,47, 196,0,20,51, mx,my, "immersiveengineering:textures/gui/turret.png", tooltip);
			if(mx>=field_147003_i+135&&mx<field_147003_i+149 && my>=field_147009_r+68&&my<field_147009_r+82)
				tooltip.add(I18n.func_135052_a(Lib.GUI_CONFIG+"turret.ignite_fluid"));
		}
		else if(tile instanceof TileEntityTurretGun)
		{
			if(mx>=field_147003_i+134&&mx<field_147003_i+150 && my>=field_147009_r+31&&my<field_147009_r+47)
				tooltip.add(I18n.func_135052_a(Lib.GUI_CONFIG+"turret.expel_casings_"+(((TileEntityTurretGun)tile).expelCasings?"on":"off")));
		}
		if(!tooltip.isEmpty())
		{
			ClientUtils.drawHoveringText(tooltip, mx, my, field_146289_q, -1,-1);
			RenderHelper.func_74520_c();
		}

	}

	@Override
	protected void func_146976_a(float f, int mx, int my)
	{
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		ClientUtils.bindTexture("immersiveengineering:textures/gui/turret.png");
		this.func_73729_b(field_147003_i,field_147009_r, 0, 0, field_146999_f, field_147000_g);

		int stored = (int)(46*(tile.getEnergyStored(null)/(float)tile.getMaxEnergyStored(null)));
		ClientUtils.drawGradientRect(field_147003_i+158,field_147009_r+16+(46-stored), field_147003_i+165,field_147009_r+62, 0xffb51500, 0xff600b00);

		if(tile instanceof TileEntityTurretChem)
		{
			this.func_73729_b(field_147003_i+132,field_147009_r+14, 176,0, 20,51);
			ClientUtils.handleGuiTank(((TileEntityTurretChem)tile).tank, field_147003_i+134,field_147009_r+16,16,47, 196,0,20,51, mx,my, "immersiveengineering:textures/gui/turret.png",null);
		}
		else if(tile instanceof TileEntityTurretGun)
		{
			ClientUtils.drawDarkSlot(field_147003_i+134,field_147009_r+13, 16,16);
			ClientUtils.drawDarkSlot(field_147003_i+134,field_147009_r+49, 16,16);
		}
	}

	@Override
	public void func_146281_b()
	{
		super.func_146281_b();
		Keyboard.enableRepeatEvents(false);
	}

	@Override
	protected void func_73869_a(char typedChar, int keyCode) throws IOException
	{
		if(this.nameField.func_146206_l() && keyCode==28)
		{
			String name = this.nameField.func_146179_b();
			if(!tile.targetList.contains(name))
			{
				NBTTagCompound tag = new NBTTagCompound();
				tag.func_74778_a("add", name);
				tile.targetList.add(name);
				ImmersiveEngineering.packetHandler.sendToServer(new MessageTileSync(tile, tag));

				this.func_73866_w_();
				((GuiReactiveList)this.field_146292_n.get(0)).setOffset(((GuiReactiveList)this.field_146292_n.get(0)).getMaxOffset());
			}
		}
		else if(!this.nameField.func_146201_a(typedChar, keyCode))
			super.func_73869_a(typedChar, keyCode);

	}
	@Override
	protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException
	{
		super.func_73864_a(mouseX, mouseY, mouseButton);
		this.nameField.func_146192_a(mouseX, mouseY, mouseButton);
	}
}
