/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.gui.ContainerToolbox;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

import java.util.ArrayList;

public class GuiToolbox extends GuiIEContainerBase
{
	public GuiToolbox(InventoryPlayer inventoryPlayer, World world, EntityEquipmentSlot slot, ItemStack toolbox)
	{
		super(new ContainerToolbox(inventoryPlayer, world, slot, toolbox));
		this.field_147000_g=238;
	}

	@Override
	public void func_73863_a(int mx, int my, float partial)
	{
		super.func_73863_a(mx, my, partial);
		ArrayList<String> tooltip = new ArrayList<String>();
		int slot = -1;
		for(int i=0; i<((ContainerToolbox)this.field_147002_h).internalSlots; i++)
		{
			Slot s = this.field_147002_h.field_75151_b.get(i);
			if(!s.func_75216_d() && mx>field_147003_i+s.field_75223_e&&mx<field_147003_i+s.field_75223_e+16 && my>field_147009_r+s.field_75221_f&&my<field_147009_r+s.field_75221_f+16)
				slot = i;
		}
		String ss = null;
		if(slot>=0)
			ss = slot<3?"food": slot<10?"tool": slot<16?"wire": "any";
		if(ss!=null)
			tooltip.add(TextFormatting.GRAY+ I18n.func_135052_a(Lib.DESC_INFO+"toolbox."+ss));
		if(!tooltip.isEmpty())
		{
			ClientUtils.drawHoveringText(tooltip, mx, my, field_146289_q, field_147003_i+field_146999_f,-1);
			RenderHelper.func_74520_c();
		}
	}

	@Override
	protected void func_146976_a(float par1, int par2, int par3)
	{
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		ClientUtils.bindTexture("immersiveengineering:textures/gui/toolbox.png");
		this.func_73729_b(field_147003_i,field_147009_r-17, 0,0, 176,field_147000_g+17);
	}

}
