/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntitySqueezer;
import blusunrize.immersiveengineering.common.gui.ContainerSqueezer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import org.lwjgl.opengl.GL11;

import java.util.ArrayList;

public class GuiSqueezer extends GuiIEContainerBase
{
	TileEntitySqueezer tile;
	public GuiSqueezer(InventoryPlayer inventoryPlayer, TileEntitySqueezer tile)
	{
		super(new ContainerSqueezer(inventoryPlayer, tile));
		this.tile=tile;
	}

	@Override
	public void func_73863_a(int mx, int my, float partial)
	{
		super.func_73863_a(mx, my, partial);
		ArrayList<String> tooltip = new ArrayList<String>();
		ClientUtils.handleGuiTank(tile.tanks[0], field_147003_i+112,field_147009_r+21, 16,47, 177,31,20,51, mx,my, "immersiveengineering:textures/gui/cokeOven.png", tooltip);
		if(mx>field_147003_i+158&&mx<field_147003_i+165 && my>field_147009_r+22&&my<field_147009_r+68)
			tooltip.add(tile.getEnergyStored(null)+"/"+tile.getMaxEnergyStored(null)+" RF");
		if(!tooltip.isEmpty())
		{
			ClientUtils.drawHoveringText(tooltip, mx, my, field_146289_q, field_147003_i+field_146999_f,-1);
			RenderHelper.func_74520_c();
		}
	}


	@Override
	protected void func_146976_a(float f, int mx, int my)
	{
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		ClientUtils.bindTexture("immersiveengineering:textures/gui/squeezer.png");
		this.func_73729_b(field_147003_i,field_147009_r, 0, 0, field_146999_f, field_147000_g);

		int stored = (int)(46*(tile.getEnergyStored(null)/(float)tile.getMaxEnergyStored(null)));
		ClientUtils.drawGradientRect(field_147003_i+158,field_147009_r+22+(46-stored), field_147003_i+165,field_147009_r+68, 0xffb51500, 0xff600b00);

		//		if(tile.processMax>0&&tile.process>0)
		//		{
		//			int h = (int)(12*(tile.process/(float)tile.processMax));
		//			this.drawTexturedModalRect(guiLeft+59,guiTop+37+12-h, 179, 1+12-h, 9, h);
		//		}

		//		if(tile.tank.getFluid()!=null && tile.tank.getFluid().getFluid()!=null)
		//		{
		//			int h = (int)(47*(tile.tank.getFluid().amount/(float)tile.tank.getCapacity()));
		//			ClientUtils.drawRepeatedFluidIcon(tile.tank.getFluid().getFluid(), guiLeft+129,guiTop+20+47-h, 16, h);
		//			ClientUtils.bindTexture("immersiveengineering:textures/gui/cokeOven.png");
		//		}
		//		this.drawTexturedModalRect(guiLeft+127,guiTop+18, 176,31, 20,51);
		ClientUtils.handleGuiTank(tile.tanks[0], field_147003_i+112,field_147009_r+21, 16,47, 177,31,20,51, mx,my, "immersiveengineering:textures/gui/squeezer.png", null);

	}
}
