/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityRefinery;
import blusunrize.immersiveengineering.common.gui.ContainerRefinery;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import org.lwjgl.opengl.GL11;

import java.util.ArrayList;

public class GuiRefinery extends GuiIEContainerBase
{
	TileEntityRefinery tile;
	public GuiRefinery(InventoryPlayer inventoryPlayer, TileEntityRefinery tile)
	{
		super(new ContainerRefinery(inventoryPlayer, tile));
		this.tile=tile;
	}

	@Override
	public void func_73863_a(int mx, int my, float partial)
	{
		super.func_73863_a(mx, my, partial);
		ArrayList<String> tooltip = new ArrayList();
		ClientUtils.handleGuiTank(tile.tanks[0], field_147003_i+ 13,field_147009_r+20, 16,47, 177,31,20,51, mx,my, "immersiveengineering:textures/gui/refinery.png", tooltip);
		ClientUtils.handleGuiTank(tile.tanks[1], field_147003_i+ 61,field_147009_r+20, 16,47, 177,31,20,51, mx,my, "immersiveengineering:textures/gui/refinery.png", tooltip);
		ClientUtils.handleGuiTank(tile.tanks[2], field_147003_i+109,field_147009_r+20, 16,47, 177,31,20,51, mx,my, "immersiveengineering:textures/gui/refinery.png", tooltip);
		if(mx>field_147003_i+157&&mx<field_147003_i+164 && my>field_147009_r+21&&my<field_147009_r+67)
			tooltip.add(tile.getEnergyStored(null)+"/"+tile.getMaxEnergyStored(null)+" RF");

		if(!tooltip.isEmpty())
		{
			ClientUtils.drawHoveringText(tooltip, mx, my, field_146289_q, field_147003_i+field_146999_f,-1);
			RenderHelper.func_74520_c();
		}
	}


	@Override
	protected void func_146976_a(float f, int mx, int my)
	{
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		ClientUtils.bindTexture("immersiveengineering:textures/gui/refinery.png");
		this.func_73729_b(field_147003_i,field_147009_r, 0, 0, field_146999_f, field_147000_g);

		//		if(tile.tick>0)
		//		{
		//			int h = (int)(18*(tile.tick/80f));
		//			ClientUtils.drawGradientRect(guiLeft+83,guiTop+34+h, guiLeft+90,guiTop+52, 0xffd4d2ab, 0xffc4c29e);
		//		}

		int stored = (int)(46*(tile.getEnergyStored(null)/(float)tile.getMaxEnergyStored(null)));
		ClientUtils.drawGradientRect(field_147003_i+157,field_147009_r+21+(46-stored), field_147003_i+164,field_147009_r+67, 0xffb51500, 0xff600b00);

		ClientUtils.handleGuiTank(tile.tanks[0], field_147003_i+ 13,field_147009_r+20, 16,47, 177,31,20,51, mx,my, "immersiveengineering:textures/gui/refinery.png", null);
		ClientUtils.handleGuiTank(tile.tanks[1], field_147003_i+ 61,field_147009_r+20, 16,47, 177,31,20,51, mx,my, "immersiveengineering:textures/gui/refinery.png", null);
		ClientUtils.handleGuiTank(tile.tanks[2], field_147003_i+109,field_147009_r+20, 16,47, 177,31,20,51, mx,my, "immersiveengineering:textures/gui/refinery.png", null);
		
		
		//		if(tile.tank.getFluid()!=null && tile.tank.getFluid().getFluid()!=null)
		//		{
		//			int h = (int)(47*(tile.tank.getFluid().amount/(float)tile.tank.getCapacity()));
		//			ClientUtils.drawRepeatedFluidIcon(tile.tank.getFluid().getFluid(), guiLeft+98,guiTop+21+47-h, 16, h);
		//			ClientUtils.bindTexture("immersiveengineering:textures/gui/fluidProducer.png");
		//		}
		//		this.drawTexturedModalRect(guiLeft+96,guiTop+19, 177,31, 20,51);
	}
}
