/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.tool.IConfigurableTool;
import blusunrize.immersiveengineering.api.tool.IConfigurableTool.ToolConfig.ToolConfigBoolean;
import blusunrize.immersiveengineering.api.tool.IConfigurableTool.ToolConfig.ToolConfigFloat;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonCheckbox;
import blusunrize.immersiveengineering.client.gui.elements.GuiSliderIE;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityModWorkbench;
import blusunrize.immersiveengineering.common.gui.ContainerModWorkbench;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

import java.util.ArrayList;

public class GuiModWorkbench extends GuiIEContainerBase
{
	TileEntityModWorkbench workbench;
	public GuiModWorkbench(InventoryPlayer inventoryPlayer, TileEntityModWorkbench tile )
	{
		super(new ContainerModWorkbench(inventoryPlayer, tile));
		workbench = tile;
		this.field_147000_g=168;
	}

	@Override
	public void func_73866_w_()
	{
		this.field_146292_n.clear();
		super.func_73866_w_();
		Slot s = field_147002_h.func_75139_a(0);
		if(s!=null && s.func_75216_d() && s.func_75211_c().func_77973_b() instanceof IConfigurableTool)
		{
			ItemStack stack = s.func_75211_c();
			IConfigurableTool tool = ((IConfigurableTool)stack.func_77973_b());
			int buttonid = 0;
			ToolConfigBoolean[] boolArray = tool.getBooleanOptions(stack);
			if(boolArray!=null)
				for(ToolConfigBoolean b : boolArray)
					this.field_146292_n.add(new GuiButtonCheckbox(buttonid++, field_147003_i+b.x,field_147009_r+b.y, tool.fomatConfigName(stack,b), b.value));
			ToolConfigFloat[] floatArray = tool.getFloatOptions(stack);
			if(floatArray!=null)
				for(ToolConfigFloat f : floatArray)
					this.field_146292_n.add(new GuiSliderIE(buttonid++, field_147003_i+f.x,field_147009_r+f.y, 80, tool.fomatConfigName(stack,f), f.value));
		}
	}

	NBTTagCompound lastMessage;
	@Override
	protected void func_146286_b(int mouseX, int mouseY, int state)
	{
		super.func_146286_b(mouseX, mouseY, state);
		Slot s = field_147002_h.func_75139_a(0);
		if(s!=null && s.func_75216_d() && s.func_75211_c().func_77973_b() instanceof IConfigurableTool)
		{
			ItemStack stack = s.func_75211_c();
			IConfigurableTool tool = ((IConfigurableTool)stack.func_77973_b());
			NBTTagCompound message = new NBTTagCompound();
			ToolConfigBoolean[] boolArray = tool.getBooleanOptions(stack);
			int iBool = 0;
			ToolConfigFloat[] floatArray = tool.getFloatOptions(stack);
			int iFloat = 0;
			for(GuiButton button : this.field_146292_n)
			{
				if(button instanceof GuiButtonCheckbox && boolArray!=null)
					message.func_74757_a("b_"+boolArray[iBool++].name,((GuiButtonCheckbox)button).state);
				if(button instanceof GuiSliderIE && floatArray!=null)
					message.func_74776_a("f_"+floatArray[iFloat++].name,(float)((GuiSliderIE)button).sliderValue);
			}
			if(!message.equals(lastMessage))//Only send packets when values have changed
				ImmersiveEngineering.packetHandler.sendToServer(new MessageTileSync(this.workbench, message));
			lastMessage = message;
		}
	}

	@Override
	public void func_73863_a(int mx, int my, float partial)
	{
		super.func_73863_a(mx, my, partial);
		for(int i=0; i<((ContainerModWorkbench)field_147002_h).slotCount; i++)
		{
			Slot s = field_147002_h.func_75139_a(i);
			if(s instanceof IESlot.BlueprintOutput && !s.func_75216_d())
			{
				BlueprintCraftingRecipe recipe = ((IESlot.BlueprintOutput)s).recipe;
				if(recipe!=null && !recipe.output.func_190926_b())
					if(func_146978_c(s.field_75223_e,s.field_75221_f, 16,16, mx,my))
					{
						ArrayList<String> tooltip = new ArrayList<String>();
						tooltip.add(recipe.output.func_77953_t().field_77937_e+recipe.output.func_82833_r());
						ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
						for(IngredientStack stack : recipe.inputs)
						{
							ItemStack toAdd = Utils.copyStackWithAmount(stack.getRandomizedExampleStack(this.field_146297_k.field_71439_g.field_70173_aa), stack.inputSize);
							if(toAdd.func_190926_b())
								continue;
							boolean isNew = true;
							for(ItemStack ss : inputs)
								if(OreDictionary.itemMatches(ss, toAdd, true))
								{
									ss.func_190917_f(toAdd.func_190916_E());
									isNew = false;
									break;
								}
							if(isNew)
								inputs.add(toAdd.func_77946_l());
						}
						for(ItemStack ss : inputs)
							tooltip.add(TextFormatting.GRAY.toString() + ss.func_190916_E() + "x " + ss.func_82833_r());

						ClientUtils.drawHoveringText(tooltip, mx, my, field_146289_q);
						RenderHelper.func_74520_c();
					}
			}
		}
	}


	@Override
	protected void func_146976_a(float f, int mx, int my)
	{
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		ClientUtils.bindTexture("immersiveengineering:textures/gui/workbench.png");
		this.func_73729_b(field_147003_i,field_147009_r, 0, 0, field_146999_f, field_147000_g);


		for(int i=0; i<((ContainerModWorkbench)field_147002_h).slotCount; i++)
		{
			Slot s = field_147002_h.func_75139_a(i);

			ClientUtils.drawColouredRect(field_147003_i+ s.field_75223_e-1, field_147009_r+ s.field_75221_f-1, 17,1, 0x77222222);
			ClientUtils.drawColouredRect(field_147003_i+ s.field_75223_e-1, field_147009_r+ s.field_75221_f+0, 1,16, 0x77222222);
			ClientUtils.drawColouredRect(field_147003_i+ s.field_75223_e+16, field_147009_r+ s.field_75221_f+0, 1,17, 0x77999999);
			ClientUtils.drawColouredRect(field_147003_i+ s.field_75223_e+0, field_147009_r+ s.field_75221_f+16, 16,1, 0x77999999);
			if( !(s instanceof IESlot.BlueprintOutput) || s.func_75216_d() || ((IESlot.BlueprintOutput)s).recipe.output.func_190926_b())
				ClientUtils.drawColouredRect(field_147003_i+ s.field_75223_e+0, field_147009_r+ s.field_75221_f+0, 16,16, 0x77444444);
		}

		for(int i=0; i<((ContainerModWorkbench)field_147002_h).slotCount; i++)
		{
			Slot s = field_147002_h.func_75139_a(i);
			if(s instanceof IESlot.BlueprintOutput && !s.func_75216_d())
			{
				ItemStack ghostStack = ((IESlot.BlueprintOutput)s).recipe.output;
				if(!ghostStack.func_190926_b())
				{
					this.field_73735_i = 200.0F;
					field_146296_j.field_77023_b = 200.0F;
					FontRenderer font = ghostStack.func_77973_b().getFontRenderer(ghostStack);
					if(font==null)
						font = field_146289_q;
					field_146296_j.func_180450_b(ghostStack, field_147003_i+s.field_75223_e, field_147009_r+s.field_75221_f);
					this.field_73735_i = 0.0F;
					field_146296_j.field_77023_b = 0.0F;

					GlStateManager.func_179140_f();
					GlStateManager.func_179097_i();
					ClientUtils.drawColouredRect(field_147003_i+ s.field_75223_e+0, field_147009_r+ s.field_75221_f+0, 16,16, 0x77444444);
					GlStateManager.func_179145_e();
					GlStateManager.func_179126_j();
				}
			}
		}
	}
}
