/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonState;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMixer;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal.MultiblockProcessInMachine;
import blusunrize.immersiveengineering.common.gui.ContainerMixer;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

import java.util.ArrayList;

public class GuiMixer extends GuiIEContainerBase
{
	TileEntityMixer tile;
	public GuiMixer(InventoryPlayer inventoryPlayer, TileEntityMixer tile)
	{
		super(new ContainerMixer(inventoryPlayer, tile));
		this.tile=tile;
		this.field_147000_g = 167;
	}

	@Override
	public void func_73866_w_()
	{
		super.func_73866_w_();
		this.field_146292_n.clear();
		this.field_146292_n.add(new GuiButtonState(0, field_147003_i+106,field_147009_r+61, 30,16, null, tile.outputAll, "immersiveengineering:textures/gui/mixer.png",176,82, 1));
	}
	@Override
	protected void func_146284_a(GuiButton button)
	{
		if(button.field_146127_k==0)
		{
			NBTTagCompound tag = new NBTTagCompound();
			tile.outputAll = ((GuiButtonState)button).state;
			tag.func_74757_a("outputAll", tile.outputAll);
			ImmersiveEngineering.packetHandler.sendToServer(new MessageTileSync(tile, tag));
			this.func_73866_w_();
		}
	}

	@Override
	public void func_73863_a(int mx, int my, float partial)
	{
		super.func_73863_a(mx, my, partial);
		ArrayList<String> tooltip = new ArrayList<String>();

		if(mx >= field_147003_i+76&&mx <= field_147003_i+134&&my >= field_147009_r+11&&my <= field_147009_r+58)
		{
			float capacity = tile.tank.getCapacity();
			int yy = field_147009_r+58;
			if(tile.tank.getFluidTypes()==0)
				tooltip.add(I18n.func_135052_a("gui.immersiveengineering.empty"));
			else
				for(int i = tile.tank.getFluidTypes()-1; i >= 0; i--)
				{
					FluidStack fs = tile.tank.fluids.get(i);
					if(fs!=null&&fs.getFluid()!=null)
					{
						int fluidHeight = (int)(47*(fs.amount/capacity));
						yy -= fluidHeight;
						if(my >= yy&&my < yy+fluidHeight)
							ClientUtils.addFluidTooltip(fs, tooltip, (int)capacity);
					}
				}
		}
		if(mx >= field_147003_i+158&&mx < field_147003_i+165&&my > field_147009_r+22&&my < field_147009_r+68)
			tooltip.add(tile.getEnergyStored(null)+"/"+tile.getMaxEnergyStored(null)+" RF");
		if(mx >= field_147003_i+106&&mx <= field_147003_i+136&&my >= field_147009_r+61&&my <= field_147009_r+77)
			tooltip.add(I18n.func_135052_a(Lib.GUI_CONFIG+"mixer.output"+(tile.outputAll?"All":"Single")));
		if(!tooltip.isEmpty())
		{
			ClientUtils.drawHoveringText(tooltip, mx, my, field_146289_q, field_147003_i+field_146999_f, -1);
			RenderHelper.func_74520_c();
		}
	}

	@Override
	protected void func_146976_a(float f, int mx, int my)
	{
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		ClientUtils.bindTexture("immersiveengineering:textures/gui/mixer.png");
		this.func_73729_b(field_147003_i,field_147009_r, 0, 0, field_146999_f, field_147000_g);

		for(MultiblockProcess process : tile.processQueue)
			if(process instanceof MultiblockProcessInMachine)
			{
				float mod = 1-(process.processTick/(float)process.maxTicks);
				for(int slot : ((MultiblockProcessInMachine)process).getInputSlots())
				{
					int h = (int)Math.max(1, mod*16);
					this.func_73729_b(field_147003_i+24+slot%2*21, field_147009_r+7+slot/2*18+(16-h), 176, 16-h, 2, h);
				}
			}

		int stored = (int)(46*(tile.getEnergyStored(null)/(float)tile.getMaxEnergyStored(null)));
		ClientUtils.drawGradientRect(field_147003_i+158,field_147009_r+22+(46-stored), field_147003_i+165,field_147009_r+68, 0xffb51500, 0xff600b00);

		float capacity = tile.tank.getCapacity();
		int yy = field_147009_r+58;
		for(int i=tile.tank.getFluidTypes()-1; i>=0; i--)
		{
			FluidStack fs = tile.tank.fluids.get(i);
			if(fs!=null && fs.getFluid()!=null)
			{
				int fluidHeight = (int)(47*(fs.amount/capacity));
				yy -= fluidHeight;
				ClientUtils.drawRepeatedFluidSprite(fs, field_147003_i+76,yy, 58,fluidHeight);
			}
		}
	}
}
