/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.GuiSorter.ButtonSorter;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityFluidSorter;
import blusunrize.immersiveengineering.common.gui.ContainerFluidSorter;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.opengl.GL11;

import java.io.IOException;
import java.util.ArrayList;

public class GuiFluidSorter extends GuiIEContainerBase
{
	TileEntityFluidSorter tile;
	InventoryPlayer playerInventory;
	public GuiFluidSorter(InventoryPlayer inventoryPlayer, TileEntityFluidSorter tile)
	{
		super(new ContainerFluidSorter(inventoryPlayer, tile));
		this.tile = tile;
		this.playerInventory = inventoryPlayer;
		this.field_147000_g = 244;
	}

	@Override
	public void func_73863_a(int mx, int my, float partial)
	{
		super.func_73863_a(mx, my, partial);
		ArrayList<String> tooltip = new ArrayList<String>();
		for(GuiButton button : this.field_146292_n)
		{
			if(button instanceof ButtonSorter)
				if(mx>button.field_146128_h&&mx<button.field_146128_h+18 && my>button.field_146129_i&&my<button.field_146129_i+18)
				{
					int type = ((ButtonSorter)button).type;
					String[] split = I18n.func_135052_a(Lib.DESC_INFO+"filter.nbt").split("<br>");
					for(int i = 0; i < split.length; i++)
						tooltip.add((i==0?TextFormatting.WHITE: TextFormatting.GRAY)+split[i]);
				}
		}
		for(int side = 0; side < 6; side++)
			for(int i = 0; i < 8; i++)
				if(tile.filters[side][i]!=null)
				{
					int x = field_147003_i+4+(side/2)*58 +(i<3?i*18: i>4?(i-5)*18: i==3?0: 36);
					int y = field_147009_r+22+(side%2)*76 +(i<3?0: i>4?36: 18);
					if(mx>x&&mx<x+16 && my>y&&my<y+16)
						ClientUtils.addFluidTooltip(tile.filters[side][i], tooltip, 0);
				}
		if(!tooltip.isEmpty())
		{
			ClientUtils.drawHoveringText(tooltip, mx, my, field_146289_q, field_147003_i+field_146999_f, -1);
			RenderHelper.func_74520_c();
		}
	}

	@Override
	protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException
	{
		super.func_73864_a(mouseX, mouseY, mouseButton);
		for(int side = 0; side < 6; side++)
			for(int i = 0; i < 8; i++)
			{
				int x = field_147003_i+4+(side/2)*58 +(i<3?i*18: i>4?(i-5)*18: i==3?0: 36);
				int y = field_147009_r+22+(side%2)*76 +(i<3?0: i>4?36: 18);
				if(mouseX>x&&mouseX<x+16 && mouseY>y&&mouseY<y+16)
				{
					FluidStack fs = FluidUtil.getFluidContained(playerInventory.func_70445_o());
					tile.filters[side][i] = fs;
					NBTTagCompound tag = new NBTTagCompound();
					tag.func_74768_a("filter_side", side);
					tag.func_74768_a("filter_slot", i);
					if(fs!=null)
						tag.func_74782_a("filter", fs.writeToNBT(new NBTTagCompound()));
					ImmersiveEngineering.packetHandler.sendToServer(new MessageTileSync(tile, tag));
				}
			}
	}

	@Override
	protected void func_146976_a(float f, int mx, int my)
	{
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		ClientUtils.bindTexture("immersiveengineering:textures/gui/sorter.png");
		this.func_73729_b(field_147003_i,field_147009_r, 0, 0, field_146999_f, field_147000_g);
		for(int side=0; side<6; side++)
		{
			ClientUtils.bindAtlas();
			for(int i=0; i<8; i++)
				if(tile.filters[side][i]!=null)
				{
					TextureAtlasSprite sprite = ClientUtils.getSprite(tile.filters[side][i].getFluid().getStill(tile.filters[side][i]));
					if(sprite!=null)
					{
						int x = field_147003_i+4+(side/2)*58 +(i<3?i*18: i>4?(i-5)*18: i==3?0: 36);
						int y = field_147009_r+22+(side%2)*76 +(i<3?0: i>4?36: 18);
						int col = tile.filters[side][i].getFluid().getColor(tile.filters[side][i]);
						GlStateManager.func_179131_c((col>>16&255)/255.0f, (col>>8&255)/255.0f, (col&255)/255.0f, 1);
						ClientUtils.drawTexturedRect(x,y, 16,16, sprite.func_94209_e(),sprite.func_94212_f(),sprite.func_94206_g(),sprite.func_94210_h());
					}
				}
			int x = field_147003_i+30+(side/2)*58;
			int y = field_147009_r+44+(side%2)*76;
			String s = I18n.func_135052_a("desc.immersiveengineering.info.blockSide."+EnumFacing.func_82600_a(side).toString()).substring(0, 1);
			GL11.glEnable(3042);
			ClientUtils.font().func_175065_a(s, x-(ClientUtils.font().func_78256_a(s)/2), y, 0xaacccccc, true);
		}
		ClientUtils.bindTexture("immersiveengineering:textures/gui/sorter.png");
	}

	@Override
	public void func_73866_w_()
	{
		super.func_73866_w_();
		this.field_146292_n.clear();
		for(int side=0; side<6; side++)
			{
				int x = field_147003_i+21+ (side/2)*58;
				int y = field_147009_r+3+ (side%2)*76;
				ButtonSorter b = new ButtonSorter(side, x,y, 1);
				b.active = this.tile.doNBT(side);
				this.field_146292_n.add(b);
			}
	}

	@Override
	protected void func_146284_a(GuiButton button)
	{
		if(button instanceof ButtonSorter && FMLCommonHandler.instance().getEffectiveSide()==Side.CLIENT)
		{
			int side = button.field_146127_k;
			this.tile.sortWithNBT[side] = (byte)(this.tile.sortWithNBT[side]==1?0:1);

			NBTTagCompound tag = new NBTTagCompound();
			tag.func_74773_a("sideConfig", this.tile.sortWithNBT);
			ImmersiveEngineering.packetHandler.sendToServer(new MessageTileSync(tile, tag));
			this.func_73866_w_();
		}
	}
}
