/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.stone.TileEntityBlastFurnace;
import blusunrize.immersiveengineering.common.gui.ContainerBlastFurnace;
import net.minecraft.entity.player.InventoryPlayer;
import org.lwjgl.opengl.GL11;

public class GuiBlastFurnace extends GuiIEContainerBase
{
	TileEntityBlastFurnace tile;
	public GuiBlastFurnace(InventoryPlayer inventoryPlayer, TileEntityBlastFurnace tile)
	{
		super(new ContainerBlastFurnace(inventoryPlayer, tile));
		this.tile=tile;
	}
	

	@Override
	protected void func_146976_a(float f, int mx, int my)
	{
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		ClientUtils.bindTexture("immersiveengineering:textures/gui/blast_furnace.png");
		this.func_73729_b(field_147003_i,field_147009_r, 0, 0, field_146999_f, field_147000_g);

		if(tile.lastBurnTime>0)
		{
			int h = (int)(12*(tile.burnTime/(float)tile.lastBurnTime));
			this.func_73729_b(field_147003_i+56,field_147009_r+37+12-h, 179, 1+12-h, 9, h);
		}
		if(tile.processMax>0)
		{
			int w = (int)(22*( (tile.processMax-tile.process)/(float)tile.processMax));
			this.func_73729_b(field_147003_i+76,field_147009_r+35, 177, 14, w, 16);
		}
	}
}
