/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.Config.IEConfig;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityBelljar;
import blusunrize.immersiveengineering.common.gui.ContainerBelljar;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;

import java.util.ArrayList;

public class GuiBelljar extends GuiIEContainerBase
{
	TileEntityBelljar tile;
	public GuiBelljar(InventoryPlayer inventoryPlayer, TileEntityBelljar tile )
	{
		super(new ContainerBelljar(inventoryPlayer, tile));
		this.tile = tile;
	}
	@Override
	public void func_73863_a(int mx, int my, float partial)
	{
		super.func_73863_a(mx, my, partial);
		ArrayList<String> tooltip = new ArrayList<String>();
		ClientUtils.handleGuiTank(tile.tank, field_147003_i+8,field_147009_r+8, 16,47, 176,30,20,51, mx,my, "immersiveengineering:textures/gui/belljar.png", tooltip);
		if(mx>field_147003_i+30&&mx<field_147003_i+37 && my>field_147009_r+22&&my<field_147009_r+68)
		{
			tooltip.add(I18n.func_135052_a(Lib.DESC_INFO+"fertFill", Utils.formatDouble(tile.fertilizerAmount/(float)IEConfig.Machines.belljar_fertilizer, "0.00")));
			tooltip.add(I18n.func_135052_a(Lib.DESC_INFO+"fertMod", Utils.formatDouble(tile.fertilizerMod, "0.00")));

		}
		if(mx>field_147003_i+158&&mx<field_147003_i+165 && my>field_147009_r+22&&my<field_147009_r+68)
			tooltip.add(tile.getEnergyStored(null)+"/"+tile.getMaxEnergyStored(null)+" RF");
		if(!tooltip.isEmpty())
		{
			ClientUtils.drawHoveringText(tooltip, mx, my, field_146289_q, field_147003_i+field_146999_f,-1);
			RenderHelper.func_74520_c();
		}
	}


	@Override
	protected void func_146976_a(float f, int mx, int my)
	{
		GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
		GlStateManager.func_179147_l();
		ClientUtils.bindTexture("immersiveengineering:textures/gui/belljar.png");
		this.func_73729_b(field_147003_i,field_147009_r, 0, 0, field_146999_f, field_147000_g);
		GlStateManager.func_179084_k();

		ClientUtils.handleGuiTank(tile.tank, field_147003_i+8,field_147009_r+8, 16,47, 176,30,20,51, mx,my, "immersiveengineering:textures/gui/belljar.png", null);
		int stored = (int)(46*(tile.fertilizerAmount/(float)IEConfig.Machines.belljar_fertilizer));
		ClientUtils.drawGradientRect(field_147003_i+30,field_147009_r+22+(46-stored), field_147003_i+37,field_147009_r+68, 0xff95ed00, 0xff8a5a00);

		stored = (int)(46*(tile.getEnergyStored(null)/(float)tile.getMaxEnergyStored(null)));
		ClientUtils.drawGradientRect(field_147003_i+158,field_147009_r+22+(46-stored), field_147003_i+165,field_147009_r+68, 0xffb51500, 0xff600b00);
	}
}
