/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonIE;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonState;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityAssembler;
import blusunrize.immersiveengineering.common.gui.ContainerAssembler;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag.TooltipFlags;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.opengl.GL11;

import java.util.ArrayList;

public class GuiAssembler extends GuiIEContainerBase
{
	static final String texture = "immersiveengineering:textures/gui/assembler.png";
	public TileEntityAssembler tile;
	public GuiAssembler(InventoryPlayer inventoryPlayer, TileEntityAssembler tile)
	{
		super(new ContainerAssembler(inventoryPlayer, tile));
		this.tile=tile;
		this.field_146999_f = 230;
		this.field_147000_g = 218;
	}

	@Override
	public void func_73866_w_()
	{
//		"\u2716"
//		"\u2716"
//		"\u2716"
		super.func_73866_w_();
		this.field_146292_n.clear();
		this.field_146292_n.add(new GuiButtonIE(0, field_147003_i+ 11,field_147009_r+67, 10,10, null, texture,230,50).setHoverOffset(0,10));
		this.field_146292_n.add(new GuiButtonIE(1, field_147003_i+ 69,field_147009_r+67, 10,10, null, texture,230,50).setHoverOffset(0,10));
		this.field_146292_n.add(new GuiButtonIE(2, field_147003_i+127,field_147009_r+67, 10,10, null, texture,230,50).setHoverOffset(0,10));
		this.field_146292_n.add(new GuiButtonState(3, field_147003_i+162,field_147009_r+69, 16,16, null, tile.recursiveIngredients, texture,240,66,3));
	}
	@Override
	protected void func_146284_a(GuiButton button)
	{
		NBTTagCompound tag = new NBTTagCompound();
		tag.func_74768_a("buttonID", button.field_146127_k);
		ImmersiveEngineering.packetHandler.sendToServer(new MessageTileSync(tile, tag));
		if(button.field_146127_k==3)
		{
			tile.recursiveIngredients = !tile.recursiveIngredients;
			this.func_73866_w_();
		}
	}

	@Override
	public void func_73863_a(int mx, int my, float partial)
	{
		super.func_73863_a(mx, my, partial);
		ArrayList<String> tooltip = new ArrayList<String>();
		if(mx>=field_147003_i+187&&mx<field_147003_i+194 && my>=field_147009_r+12&&my<field_147009_r+59)
			tooltip.add(tile.getEnergyStored(null)+"/"+tile.getMaxEnergyStored(null)+" RF");

		ClientUtils.handleGuiTank(tile.tanks[0], field_147003_i+204,field_147009_r+13,16,46, 250,0,20,50, mx,my, texture,tooltip);
		ClientUtils.handleGuiTank(tile.tanks[1], field_147003_i+182,field_147009_r+70,16,46, 250,0,20,50, mx,my, texture,tooltip);
		ClientUtils.handleGuiTank(tile.tanks[2], field_147003_i+204,field_147009_r+70,16,46, 250,0,20,50, mx,my, texture,tooltip);

		for(int i=0; i<tile.patterns.length; i++)
			if(tile.inventory.get(18+i).func_190926_b() && !tile.patterns[i].inv.get(9).func_190926_b())
				if(mx>=field_147003_i+27+i*58&&mx<field_147003_i+43+i*58 && my>=field_147009_r+64&&my<field_147009_r+80)
				{
					tooltip.add(tile.patterns[i].inv.get(9).func_82833_r());
					tile.patterns[i].inv.get(9).func_77973_b().func_77624_a(tile.patterns[i].inv.get(9), ClientUtils.mc().field_71441_e, tooltip, TooltipFlags.NORMAL);
					for(int j=0; j<tooltip.size(); j++)
						tooltip.set(j, (j==0?tile.patterns[i].inv.get(9).func_77953_t().field_77937_e: TextFormatting.GRAY)+tooltip.get(j));
				}

		if(((mx>=field_147003_i+11&&mx<field_147003_i+21)||(mx>=field_147003_i+69&&mx<field_147003_i+79)||(mx>=field_147003_i+127&&mx<field_147003_i+137)) && my>field_147009_r+67&&my<field_147009_r+77)
			tooltip.add(I18n.func_135052_a(Lib.GUI_CONFIG+"assembler.clearRecipe"));
		if(mx>=field_147003_i+162&&mx<field_147003_i+178 && my>field_147009_r+69&&my<field_147009_r+85)
			tooltip.add(I18n.func_135052_a(Lib.GUI_CONFIG+"assembler."+(tile.recursiveIngredients?"recursiveIngredients":"nonRecursiveIngredients")));

		if(!tooltip.isEmpty())
		{
			ClientUtils.drawHoveringText(tooltip, mx, my, field_146289_q, field_146999_f,-1);
			RenderHelper.func_74520_c();
		}

	}

	@Override
	protected void func_146976_a(float f, int mx, int my)
	{
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		ClientUtils.bindTexture(texture);
		this.func_73729_b(field_147003_i,field_147009_r, 0, 0, field_146999_f, field_147000_g);

		int stored = (int)(46*(tile.getEnergyStored(null)/(float)tile.getMaxEnergyStored(null)));
		ClientUtils.drawGradientRect(field_147003_i+187,field_147009_r+13+(46-stored), field_147003_i+194,field_147009_r+59, 0xffb51500, 0xff600b00);

		ClientUtils.handleGuiTank(tile.tanks[0], field_147003_i+204,field_147009_r+13,16,46, 230,0,20,50, mx,my, texture,null);
		ClientUtils.handleGuiTank(tile.tanks[1], field_147003_i+182,field_147009_r+70,16,46, 230,0,20,50, mx,my, texture,null);
		ClientUtils.handleGuiTank(tile.tanks[2], field_147003_i+204,field_147009_r+70,16,46, 230,0,20,50, mx,my, texture,null);

		for(int i=0; i<tile.patterns.length; i++)
			if(tile.inventory.get(18+i).func_190926_b() && !tile.patterns[i].inv.get(9).func_190926_b())
			{
				ItemStack stack = tile.patterns[i].inv.get(9);
				GL11.glPushMatrix();
				GL11.glTranslatef(0.0F, 0.0F, 32.0F);
				GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
				RenderHelper.func_74518_a();
				this.field_73735_i = 200.0F;
				field_146296_j.field_77023_b = 200.0F;
				FontRenderer font = null;
				if(!stack.func_190926_b())
					font = stack.func_77973_b().getFontRenderer(stack);
				if(font==null)
					font = field_146289_q;
				field_146296_j.func_180450_b(stack, field_147003_i+27+i*58, field_147009_r+64);
				field_146296_j.func_180453_a(font, stack, field_147003_i+27+i*58, field_147009_r+64, TextFormatting.GRAY.toString() + stack.func_190916_E());
				this.field_73735_i = 0.0F;
				field_146296_j.field_77023_b = 0.0F;


				GL11.glDisable(GL11.GL_LIGHTING);
				GL11.glDisable(GL11.GL_DEPTH_TEST);
				ClientUtils.drawColouredRect(field_147003_i+27+i*58, field_147009_r+64, 16,16, 0x77444444);
				GL11.glEnable(GL11.GL_LIGHTING);
				GL11.glEnable(GL11.GL_DEPTH_TEST);

				GL11.glPopMatrix();
			}
	}
}
