/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.util.Arrays;
import java.util.HashMap;

@SideOnly(Side.CLIENT)
public class IEItemFontRender extends FontRenderer
{
	static HashMap<Character, CharReplacement> unicodeReplacements = new HashMap();

	static
	{
		unicodeReplacements.put((char) Integer.parseInt("260E", 16), new CharReplacement("immersiveengineering:textures/gui/hud_elements.png", .5f, .75f, .5625f, .8125f));
	}

	int[] backupColours;
	String colourFormattingKeys = "0123456789abcdef";
	public float customSpaceWidth = 4f;
	public float spacingModifier = 0f;
	public boolean verticalBoldness = false;

	public IEItemFontRender()
	{
		super(ClientUtils.mc().field_71474_y, new ResourceLocation("textures/font/ascii.png"), ClientUtils.mc().field_71446_o, false);
		if (Minecraft.func_71410_x().field_71474_y.field_74363_ab != null)
		{
			this.func_78264_a(ClientUtils.mc().func_135016_M().func_135042_a());
			this.func_78275_b(ClientUtils.mc().func_135016_M().func_135044_b());
		}
		((IReloadableResourceManager)ClientUtils.mc().func_110442_L()).func_110542_a(this);
		createColourBackup();
	}

	/** This should be called again if the colour array was modified after instantiation*/
	public void createColourBackup()
	{
		this.backupColours = Arrays.copyOf(this.field_78285_g, 32);
	}

	@Override
	public void func_78255_a(String text, boolean shadow)
	{
		int idx = -1;
		int loop = 0;
		HashMap<Integer, Integer> formattingReplacements = new HashMap<Integer, Integer>();
		while((idx=text.indexOf("<hexcol="))>=0 && loop++<20)
		{
			int end = text.indexOf(">",idx);
			if(end>=0)
			{
				String rep = "ERROR";
				String s = text.substring(idx, end+1);
				int formatEnd = s.indexOf(":");
				if(formatEnd>=0)
				{
					rep = s.substring(formatEnd+1, s.length()-1);
					String hex = s.substring("<hexcol=".length(), formatEnd);
					try{
						int hexColour = Integer.parseInt(hex,16);
						int formatting = 0;
						if(formattingReplacements.containsKey(hexColour))
							formatting = formattingReplacements.get(hexColour);
						else
							while(formatting<16 && text.contains("\u00A7"+colourFormattingKeys.charAt(formatting)))
								formatting++;
						if(formatting<16)
						{
							rep = "\u00A7"+colourFormattingKeys.charAt(formatting)+ rep + "\u00A7r";
							this.field_78285_g[formatting] = hexColour;
							this.field_78285_g[16+formatting] = ClientUtils.getDarkenedTextColour(hexColour);
						}
						formattingReplacements.put(hexColour, formatting);
					}catch(Exception e){}
				}
				text = text.replace(s, rep);
			}
		}
		if(verticalBoldness)
		{
			float startX = this.field_78295_j;
			float startY = this.field_78296_k;
			float yOffset = this.func_82883_a()?.5f:1;

			super.func_78255_a(text, shadow);
			this.field_78296_k=startY+yOffset;
			this.field_78295_j=startX;
			super.func_78255_a(text, shadow);
			this.field_78296_k-=yOffset;
		}
		else
			super.func_78255_a(text, shadow);

		this.field_78285_g = Arrays.copyOf(backupColours, 32);
	}

	@Override
	protected float func_78277_a(char ch, boolean italic)
	{
		CharReplacement cr = unicodeReplacements.get(ch);
		if(cr != null)
			return cr.replaceChar(field_78295_j, field_78296_k);
		return super.func_78277_a(ch, italic);
	}

	@Override
	protected float func_78266_a(int ch, boolean italic)
	{
		if(ch==32)
			return customSpaceWidth;
		return super.func_78266_a(ch, italic)+spacingModifier;
	}
	public float getCharWidthIEFloat(char character)
	{
		if(character==32)
			return customSpaceWidth;
		return super.func_78263_a(character)+spacingModifier;
	}
	@Override
	public int func_78263_a(char character)
	{
		return (int)this.getCharWidthIEFloat(character);
	}
	@Override
	public int func_78256_a(String text)
	{
		if (text==null)
			return 0;
		else
		{
			float i = 0;
			boolean flag = false;
			for(int j=0; j<text.length(); ++j)
			{
				char c0 = text.charAt(j);
				float k = this.getCharWidthIEFloat(c0);
				if(k<0 && j<text.length()-1)
				{
					++j;
					c0 = text.charAt(j);

					if(c0!=108 && c0!=76)
					{
						if(c0==114 || c0==82)
							flag = false;
					}
					else
						flag = true;
					k = 0;
				}

				i += k;
				if(flag && k>0)
					++i;
			}
			return (int)i;
		}
	}
	@Override
	public int func_78259_e(String str, int wrapWidth)
	{
		int i = str.length();
		float j = 0;
		int k = 0;
		int l = -1;

		for(boolean flag = false; k<i; ++k)
		{
			char c0 = str.charAt(k);
			switch(c0)
			{
				case '\n':
					--k;
					break;
				case ' ':
					l = k;
				default:
					j += this.getCharWidthIEFloat(c0);
					if(flag)
						++j;
					break;
				case '\u00a7':
					if(k < i - 1)
					{
						++k;
						char c1 = str.charAt(k);

						if(c1 != 108 && c1 != 76)
						{
							if(c1 == 114 || c1 == 82 || (c1 >= 48 && c1 <= 57 || c1 >= 97 && c1 <= 102 || c1 >= 65 && c1 <= 70))
								flag = false;
						} else
							flag = true;
					}
			}
			if(c0 == 10)
			{
				++k;
				l = k;
				break;
			}
			if(j>wrapWidth)
				break;
		}
		return k!=i && l!=-1 && l<k?l:k;
	}

	static class CharReplacement
	{
		private final String textureSheet;
		private final float uMin;
		private final float vMin;
		private final float uMax;
		private final float vMax;

		public CharReplacement(String textureSheet, float uMin, float vMin, float uMax, float vMax)
		{
			this.textureSheet = textureSheet;
			this.uMin = uMin;
			this.vMin = vMin;
			this.uMax = uMax;
			this.vMax = vMax;
		}

		float replaceChar(float posX, float posY)
		{
			ClientUtils.bindTexture(textureSheet);
//			int j = ch / 256;
//			this.loadGlyphTexture(j);
//			int k = i >>> 4;
//			int l = i & 15;
//			float f = (float)k;
//			float f1 = (float)(l + 1);
//			float f2 = (float)(ch % 16 * 88816) + f;
//			float f3 = (float)((ch & 255) / 16 * 16);
//			float f4 = f1 - f - 0.02F;
//			float f5 = italic ? 1.0F : 0.0F;
			GlStateManager.func_187447_r(5);
			GlStateManager.func_187426_b(uMin, vMin);
			GlStateManager.func_187435_e(posX, posY, 0.0F);
			GlStateManager.func_187426_b(uMin, vMax);
			GlStateManager.func_187435_e(posX, posY + 7.99F, 0.0F);
			GlStateManager.func_187426_b(uMax, vMin);
			GlStateManager.func_187435_e(posX + 7.99f, posY, 0.0F);
			GlStateManager.func_187426_b(uMax, vMax);
			GlStateManager.func_187435_e(posX + 7.99f, posY + 7.99F, 0.0F);
			GlStateManager.func_187437_J();
			return 8.02f;
		}
	}
}
