/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxReceiver;
import blusunrize.immersiveengineering.api.energy.wires.IWireCoil;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler.Connection;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.CapabilityShader.ShaderWrapper;
import blusunrize.immersiveengineering.api.tool.IDrillHead;
import blusunrize.immersiveengineering.api.tool.ZoomHandler;
import blusunrize.immersiveengineering.api.tool.ZoomHandler.IZoomTool;
import blusunrize.immersiveengineering.client.gui.GuiBlastFurnace;
import blusunrize.immersiveengineering.client.gui.GuiToolbox;
import blusunrize.immersiveengineering.client.render.TileRenderAutoWorkbench;
import blusunrize.immersiveengineering.client.render.TileRenderAutoWorkbench.BlueprintLines;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.Config.IEConfig;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IAdvancedSelectionBounds;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IBlockOverlayText;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDevice1;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntitySampleDrill;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityTurntable;
import blusunrize.immersiveengineering.common.gui.ContainerRevolver;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces.IBulletContainer;
import blusunrize.immersiveengineering.common.items.*;
import blusunrize.immersiveengineering.common.util.*;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import blusunrize.immersiveengineering.common.util.network.MessageChemthrowerSwitch;
import blusunrize.immersiveengineering.common.util.network.MessageMagnetEquip;
import blusunrize.immersiveengineering.common.util.network.MessageRequestBlockUpdate;
import blusunrize.immersiveengineering.common.util.sound.IEMuffledSound;
import blusunrize.immersiveengineering.common.util.sound.IEMuffledTickableSound;
import com.google.common.collect.ImmutableList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelVillager;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.renderer.*;
import net.minecraft.client.renderer.GlStateManager.DestFactor;
import net.minecraft.client.renderer.GlStateManager.SourceFactor;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumFacing.Axis;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.RayTraceResult.Type;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.*;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent.Phase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

import java.util.*;

public class ClientEventHandler implements IResourceManagerReloadListener
{
	private boolean shieldToggleButton = false;
	private int shieldToggleTimer = 0;

	@Override
	public void func_110549_a(IResourceManager resourceManager)
	{
		TextureMap texturemap = Minecraft.func_71410_x().func_147117_R();
		for(int i=0; i<ClientUtils.destroyBlockIcons.length; i++)
			ClientUtils.destroyBlockIcons[i] = texturemap.func_110572_b("minecraft:blocks/destroy_stage_" + i);

		ImmersiveEngineering.proxy.clearRenderCaches();
	}

	public static Set<Connection> skyhookGrabableConnections = new HashSet<>();
	@SubscribeEvent
	public void onPlayerTick(TickEvent.PlayerTickEvent event)
	{
		if(event.side.isClient() && event.phase== Phase.START && event.player!=null && event.player==ClientUtils.mc().func_175606_aa())
		{
			skyhookGrabableConnections.clear();
			EntityPlayer player = event.player;
			ItemStack stack = player.func_184607_cu();
			if(!stack.func_190926_b() && stack.func_77973_b() instanceof ItemSkyhook)
			{
				Connection line = SkylineHelper.getTargetConnection(player.func_130014_f_(), player, null);
				if(line!=null)
					skyhookGrabableConnections.add(line);
			}
		}

		if(event.side.isClient() && event.phase == Phase.END && event.player!=null)
		{
			if(this.shieldToggleTimer > 0)
				this.shieldToggleTimer--;
			if(ClientProxy.keybind_magnetEquip.func_151470_d()&&!this.shieldToggleButton)
				if(this.shieldToggleTimer <= 0)
					this.shieldToggleTimer = 7;
				else
				{
					EntityPlayer player = event.player;
					ItemStack held = player.func_184586_b(EnumHand.OFF_HAND);
					if(!held.func_190926_b() && held.func_77973_b() instanceof ItemIEShield)
					{
						if(((ItemIEShield)held.func_77973_b()).getUpgrades(held).func_74767_n("magnet") && ((ItemIEShield)held.func_77973_b()).getUpgrades(held).func_74764_b("prevSlot"))
							ImmersiveEngineering.packetHandler.sendToServer(new MessageMagnetEquip(player.func_70005_c_(), -1));
					}
					else
					{
						for(int i=0; i<player.field_71071_by.field_70462_a.size(); i++)
						{
							ItemStack s = player.field_71071_by.field_70462_a.get(i);
							if(!s.func_190926_b() && s.func_77973_b() instanceof ItemIEShield && ((ItemIEShield)s.func_77973_b()).getUpgrades(s).func_74767_n("magnet"))
								ImmersiveEngineering.packetHandler.sendToServer(new MessageMagnetEquip(player.func_70005_c_(), i));
						}
					}
				}
			if(this.shieldToggleButton!=ClientUtils.mc().field_71474_y.field_74368_y.func_151470_d())
				this.shieldToggleButton = ClientUtils.mc().field_71474_y.field_74368_y.func_151470_d();


			if(ClientProxy.keybind_chemthrowerSwitch.func_151468_f())
			{
				ItemStack held = event.player.func_184586_b(EnumHand.MAIN_HAND);
				if(held.func_77973_b() instanceof ItemChemthrower && ((ItemChemthrower)held.func_77973_b()).getUpgrades(held).func_74767_n("multitank"))
					ImmersiveEngineering.packetHandler.sendToServer(new MessageChemthrowerSwitch(event.player.func_70005_c_(), true));
			}
		}
//		if(event.side.isClient() && event.phase == Phase.END && event.player!=null)
//		{
//			EntityPlayer player = event.player;
//			ItemStack stack = player.getActiveItemStack();
//			boolean twohanded = stack!=null && (stack.getItem() instanceof ItemDrill);
//			if(twohanded && (player!=ClientUtils.mc().getRenderViewEntity()||ClientUtils.mc().gameSettings.thirdPersonView!=0))
//			{
//				if(player.getItemInUseCount() <= 0)
//				{
//					player.stopActiveHand();
//					player.setActiveHand(EnumHand.MAIN_HAND);
//				}
//			}
//
//		}
	}

	@SubscribeEvent
	public void onItemTooltip(ItemTooltipEvent event)
	{
		if(event.getItemStack()==null || event.getItemStack().func_190926_b())
			return;
		if(event.getItemStack().hasCapability(CapabilityShader.SHADER_CAPABILITY, null))
		{
			ShaderWrapper wrapper = event.getItemStack().getCapability(CapabilityShader.SHADER_CAPABILITY, null);
			ItemStack shader = wrapper != null ? wrapper.getShaderItem() : null;
			if(!shader.func_190926_b())
				event.getToolTip().add(TextFormatting.DARK_GRAY + shader.func_82833_r());
		}
		if(ItemNBTHelper.hasKey(event.getItemStack(),Lib.NBT_Earmuffs))
		{
			ItemStack earmuffs = ItemNBTHelper.getItemStack(event.getItemStack(), Lib.NBT_Earmuffs);
			if(!earmuffs.func_190926_b())
				event.getToolTip().add(TextFormatting.GRAY+earmuffs.func_82833_r());
		}
		if(ItemNBTHelper.hasKey(event.getItemStack(),Lib.NBT_Powerpack))
		{
			ItemStack powerpack = ItemNBTHelper.getItemStack(event.getItemStack(), Lib.NBT_Powerpack);
			if(!powerpack.func_190926_b())
			{
				event.getToolTip().add(TextFormatting.GRAY+powerpack.func_82833_r());
				event.getToolTip().add(TextFormatting.GRAY.toString()+EnergyHelper.getEnergyStored(powerpack)+"/"+EnergyHelper.getMaxEnergyStored(powerpack)+" IF");
			}
		}
		if(FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT
				&& ClientUtils.mc().field_71462_r != null
				&& ClientUtils.mc().field_71462_r instanceof GuiBlastFurnace
				&& BlastFurnaceRecipe.isValidBlastFuel(event.getItemStack()))
			event.getToolTip().add(TextFormatting.GRAY+ I18n.func_135052_a("desc.immersiveengineering.info.blastFuelTime", BlastFurnaceRecipe.getBlastFuelTime(event.getItemStack())));
		if(IEConfig.oreTooltips && event.getFlags().func_194127_a())
		{
			for(int oid : OreDictionary.getOreIDs(event.getItemStack()))
				event.getToolTip().add(TextFormatting.GRAY + OreDictionary.getOreName(oid));
//			FluidStack fs = FluidUtil.getFluidContained(event.getItemStack());
//			if(fs!=null && fs.getFluid()!=null)
//				event.getToolTip().add("Fluid: "+ FluidRegistry.getFluidName(fs));
		}
	}

	@SubscribeEvent
	public void onPlaySound(PlaySoundEvent event)
	{
		if(event.getSound()==null || event.getSound().func_184365_d()==null)
			return;
		if(!ItemEarmuffs.affectedSoundCategories.contains(event.getSound().func_184365_d().func_187948_a()))
			return;
		if(ClientUtils.mc().field_71439_g!=null && !ClientUtils.mc().field_71439_g.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b())
		{
			ItemStack earmuffs = ClientUtils.mc().field_71439_g.func_184582_a(EntityEquipmentSlot.HEAD);
			if(ItemNBTHelper.hasKey(earmuffs, Lib.NBT_Earmuffs))
				earmuffs = ItemNBTHelper.getItemStack(earmuffs, Lib.NBT_Earmuffs);
			if(!earmuffs.func_190926_b() && IEContent.itemEarmuffs.equals(earmuffs.func_77973_b()) && !ItemNBTHelper.getBoolean(earmuffs,"IE:Earmuffs:Cat_"+event.getSound().func_184365_d().func_187948_a()))
			{
				for(String blacklist : IEConfig.Tools.earDefenders_SoundBlacklist)
					if(blacklist!=null && blacklist.equalsIgnoreCase(event.getSound().func_147650_b().toString()))
						return;
				if(event.getSound() instanceof ITickableSound)
					event.setResultSound(new IEMuffledTickableSound((ITickableSound)event.getSound(), ItemEarmuffs.getVolumeMod(earmuffs)));
				else
					event.setResultSound(new IEMuffledSound(event.getSound(), ItemEarmuffs.getVolumeMod(earmuffs)));

				if(event.getSound() instanceof PositionedSoundRecord)
				{
					BlockPos pos = new BlockPos(event.getSound().func_147649_g(),event.getSound().func_147654_h(),event.getSound().func_147651_i());
					if(ClientUtils.mc().field_71438_f.field_147593_P.containsKey(pos))
						ClientUtils.mc().field_71438_f.field_147593_P.put(pos, event.getResultSound());
				}
			}
		}
	}
	/*
	@SubscribeEvent()
	public void lastWorldRender(RenderWorldLastEvent event)
	{
		connectionsRendered = false;
		ParticleRenderer.dispatch();
	}
	static boolean connectionsRendered = false;
	public static void renderAllIEConnections(float partial)
	{
		if(connectionsRendered)
			return;
		GlStateManager.pushMatrix();

		GL11.glDisable(GL11.GL_CULL_FACE);
		//		GL11.glDisable(GL11.GL_TEXTURE_2D);
		GL11.glEnable(GL11.GL_BLEND);
		GL11.glDisable(GL11.GL_ALPHA_TEST);
		OpenGlHelper.glBlendFunc(770, 771, 1, 0);
		GL11.glShadeModel(GL11.GL_SMOOTH);
		RenderHelper.enableStandardItemLighting();

		Tessellator.instance.startDrawing(GL11.GL_QUADS);

		EntityLivingBase viewer = ClientUtils.mc().renderViewEntity;
		double dx = viewer.lastTickPosX + (viewer.posX - viewer.lastTickPosX) * partial;//(double)event.partialTicks;
		double dy = viewer.lastTickPosY + (viewer.posY - viewer.lastTickPosY) * partial;//(double)event.partialTicks;
		double dz = viewer.lastTickPosZ + (viewer.posZ - viewer.lastTickPosZ) * partial;//(double)event.partialTicks;

		for(Object o : ClientUtils.mc().renderGlobal.tileEntities)
			if(o instanceof IImmersiveConnectable)
			{
				TileEntity tile = (TileEntity)o;
				//				int lb = tile.getworld().getLightBrightnessForSkyBlocks(tile.xCoord, tile.yCoord, tile.zCoord, 0);
				//				int lb_j = lb % 65536;
				//				int lb_k = lb / 65536;
				//				OpenGlHelper.setLightmapTextureCoords(OpenGlHelper.lightmapTexUnit, (float)lb_j / 1.0F, (float)lb_k / 1.0F);


				Tessellator.instance.setTranslation(tile.xCoord-dx, tile.yCoord-dy, tile.zCoord-dz);
				//				GlStateManager.translate((tile.xCoord+.5-dx), (tile.yCoord+.5-dy), (tile.zCoord+.5-dz));
				ClientUtils.renderAttachedConnections((TileEntity)tile);
				//				GlStateManager.translate(-(tile.xCoord+.5-dx), -(tile.yCoord+.5-dy), -(tile.zCoord+.5-dz));

			}

		Iterator<ImmersiveNetHandler.Connection> it = skyhookGrabableConnections.iterator();
		World world = viewer.world;
		while(it.hasNext())
		{
			ImmersiveNetHandler.Connection con = it.next();
			Tessellator.instance.setTranslation(con.start.posX-dx, con.start.posY-dy, con.start.posZ-dz);
			double r = con.cableType.getRenderDiameter()/2;
			ClientUtils.drawConnection(con, Utils.toIIC(con.start, world), Utils.toIIC(con.end, world),   0x00ff99,128,r*1.75, con.cableType.getIcon(con));
		}

		Tessellator.instance.setTranslation(0,0,0);
		Tessellator.instance.draw();

		GL11.glDisable(GL11.GL_BLEND);
		GL11.glEnable(GL11.GL_ALPHA_TEST);
		GL11.glEnable(GL11.GL_TEXTURE_2D);
		GL11.glEnable(GL11.GL_CULL_FACE);

		GL11.glPopMatrix();
		connectionsRendered = true;
	}
	 */

	@SubscribeEvent
	public void onRenderItemFrame(RenderItemInFrameEvent event)
	{
		if(!event.getItem().func_190926_b() && event.getItem().func_77973_b() instanceof ItemEngineersBlueprint)
		{
			double playerDistanceSq = ClientUtils.mc().field_71439_g.func_174818_b(event.getEntityItemFrame().func_180425_c());

			if(playerDistanceSq<1000)
			{
				BlueprintCraftingRecipe[] recipes = BlueprintCraftingRecipe.findRecipes(ItemNBTHelper.getString(event.getItem(), "blueprint"));
				if(recipes!=null&&recipes.length > 0)
				{
					int i = event.getEntityItemFrame().func_82333_j();
					BlueprintCraftingRecipe recipe = recipes[i%recipes.length];
					BlueprintLines blueprint = recipe==null?null: TileRenderAutoWorkbench.getBlueprintDrawable(recipe, event.getEntityItemFrame().func_130014_f_());
					if(blueprint!=null)
					{
						GlStateManager.func_179114_b(-i*45.0F, 0.0F, 0.0F, 1.0F);
						ClientUtils.bindTexture("immersiveengineering:textures/models/blueprint_frame.png");
						GlStateManager.func_179137_b(-.5, .5,-.001);
						ClientUtils.drawTexturedRect(.125f,-.875f, .75f,.75f, 1d,0d,1d,0d);
						//Width depends on distance
						float lineWidth = playerDistanceSq < 3?3: playerDistanceSq < 25?2: playerDistanceSq < 40?1: .5f;
						GlStateManager.func_179137_b(.75,-.25,-.002);
						GlStateManager.func_179129_p();
						GlStateManager.func_179090_x();
						GlStateManager.func_179147_l();
						float scale = .0375f/(blueprint.getTextureScale()/16f);
						GlStateManager.func_179152_a(-scale, -scale, scale);
						GlStateManager.func_179131_c(1, 1, 1, 1);

						blueprint.draw(lineWidth);

						GlStateManager.func_179152_a(1/scale, -1/scale, 1/scale);
						GlStateManager.func_179141_d();
						GlStateManager.func_179098_w();
						GlStateManager.func_179089_o();

						event.setCanceled(true);
					}
				}
			}
		}
	}

	@SubscribeEvent
	public void onRenderOverlayPre(RenderGameOverlayEvent.Pre event)
	{
		if(ZoomHandler.isZooming && event.getType()==RenderGameOverlayEvent.ElementType.CROSSHAIRS)
		{
			event.setCanceled(true);
			if(ZoomHandler.isZooming)
			{
				ClientUtils.bindTexture("immersiveengineering:textures/gui/scope.png");
				int width = event.getResolution().func_78326_a();
				int height = event.getResolution().func_78328_b();
				int resMin = Math.min(width,height);
				float offsetX = (width-resMin)/2f;
				float offsetY = (height-resMin)/2f;

				if(resMin==width)
				{
					ClientUtils.drawColouredRect(0,0, width,(int)offsetY+1, 0xff000000);
					ClientUtils.drawColouredRect(0,(int)offsetY+resMin, width,(int)offsetY+1, 0xff000000);
				}
				else
				{
					ClientUtils.drawColouredRect(0,0, (int)offsetX+1,height, 0xff000000);
					ClientUtils.drawColouredRect((int)offsetX+resMin,0, (int)offsetX+1,height, 0xff000000);
				}
				GlStateManager.func_179147_l();
				OpenGlHelper.func_148821_a(770, 771, 1, 0);

				GlStateManager.func_179109_b(offsetX,offsetY,0);
				ClientUtils.drawTexturedRect(0,0,resMin,resMin, 0f,1f,0f,1f);

				ClientUtils.bindTexture("immersiveengineering:textures/gui/hud_elements.png");
				ClientUtils.drawTexturedRect(218/256f*resMin,64/256f*resMin, 24/256f*resMin,128/256f*resMin, 64/256f,88/256f,96/256f,224/256f);
				ItemStack equipped = ClientUtils.mc().field_71439_g.func_184586_b(EnumHand.MAIN_HAND);
				if(!equipped.func_190926_b() && equipped.func_77973_b() instanceof IZoomTool)
				{
					IZoomTool tool = (IZoomTool)equipped.func_77973_b();
					float[] steps = tool.getZoomSteps(equipped, ClientUtils.mc().field_71439_g);
					if(steps!=null && steps.length>1)
					{
						int curStep = -1;
						float dist=0;

						float totalOffset = 0;
						float stepLength = 118/(float)steps.length;
						float stepOffset = (stepLength-7)/2f;
						GlStateManager.func_179109_b(223/256f*resMin,64/256f*resMin, 0);
						GlStateManager.func_179109_b(0,(5+stepOffset)/256*resMin,0);
						for(int i=0; i<steps.length; i++)
						{
							ClientUtils.drawTexturedRect(0,0, 8/256f*resMin,7/256f*resMin, 88/256f,96/256f,96/256f,103/256f);
							GlStateManager.func_179109_b(0,stepLength/256*resMin,0);
							totalOffset += stepLength;

							if(curStep==-1 || Math.abs(steps[i]-ZoomHandler.fovZoom)<dist)
							{
								curStep = i;
								dist = Math.abs(steps[i]-ZoomHandler.fovZoom);
							}
						}
						GlStateManager.func_179109_b(0,-totalOffset/256*resMin,0);

						if(curStep>=0 && curStep<steps.length)
						{
							GlStateManager.func_179109_b(6/256f*resMin,curStep*stepLength/256*resMin,0);
							ClientUtils.drawTexturedRect(0,0, 8/256f*resMin,7/256f*resMin, 88/256f,98/256f,103/256f,110/256f);
							ClientUtils.font().func_78276_b((1/steps[curStep])+"x", (int)(16/256f*resMin),0, 0xffffff);
							GlStateManager.func_179109_b(-6/256f*resMin,-curStep*stepLength/256*resMin,0);
						}
						GlStateManager.func_179109_b(0,-((5+stepOffset)/256*resMin),0);
						GlStateManager.func_179109_b(-223/256f*resMin,-64/256f*resMin, 0);
					}
				}

				GlStateManager.func_179109_b(-offsetX,-offsetY,0);
			}
		}
	}

	@SubscribeEvent()
	public void onRenderOverlayPost(RenderGameOverlayEvent.Post event)
	{
		if(ClientUtils.mc().field_71439_g!=null && event.getType() == RenderGameOverlayEvent.ElementType.TEXT)
		{
			EntityPlayer player = ClientUtils.mc().field_71439_g;

			for(EnumHand hand : EnumHand.values())
				if(!player.func_184586_b(hand).func_190926_b())
				{
					ItemStack equipped = player.func_184586_b(hand);
					if(OreDictionary.itemMatches(new ItemStack(IEContent.itemTool,1,2), equipped, false) || equipped.func_77973_b() instanceof IWireCoil)
					{
						if(ItemNBTHelper.hasKey(equipped, "linkingPos"))
						{
							int[] link = ItemNBTHelper.getIntArray(equipped, "linkingPos");
							if(link!=null&&link.length>3)
							{
								String s = I18n.func_135052_a(Lib.DESC_INFO+"attachedTo", link[1],link[2],link[3]);
								int col = WireType.ELECTRUM.getColour(null);
								if(equipped.func_77973_b() instanceof IWireCoil)
								{
									RayTraceResult rtr = ClientUtils.mc().field_71476_x;
									double d = rtr!=null&&rtr.func_178782_a()!=null?rtr.func_178782_a().func_177954_c(link[1],link[2],link[3]):player.func_70092_e(link[1],link[2],link[3]);
									int max = ((IWireCoil)equipped.func_77973_b()).getWireType(equipped).getMaxLength();
									if(d>max*max)
										col = 0xdd3333;
								}
								ClientUtils.font().func_175065_a(s, event.getResolution().func_78326_a()/2 - ClientUtils.font().func_78256_a(s)/2, event.getResolution().func_78328_b()-GuiIngameForge.left_height-20, col, true);
							}
						}
					}
					else if (OreDictionary.itemMatches(equipped, new ItemStack(IEContent.itemFluorescentTube), false))
					{
						String s = I18n.func_135052_a("desc.immersiveengineering.info.colour", "#"+ItemFluorescentTube.hexColorString(equipped));
						ClientUtils.font().func_175065_a(s, event.getResolution().func_78326_a()/2 - ClientUtils.font().func_78256_a(s)/2, event.getResolution().func_78328_b()-GuiIngameForge.left_height-20, ItemFluorescentTube.getRGBInt(equipped), true);
					}
					else if(equipped.func_77973_b() instanceof ItemRevolver || equipped.func_77973_b() instanceof ItemSpeedloader)
					{
						ClientUtils.bindTexture("immersiveengineering:textures/gui/revolver.png");
						NonNullList<ItemStack> bullets = ((IBulletContainer)equipped.func_77973_b()).getBullets(equipped, true);
						if (bullets!=null)
						{
							int bulletAmount = ((IBulletContainer)equipped.func_77973_b()).getBulletCount(equipped);
							EnumHandSide side = hand == EnumHand.MAIN_HAND ? player.func_184591_cq() : player.func_184591_cq().func_188468_a();
							boolean right = side == EnumHandSide.RIGHT;
							float dx = right ? event.getResolution().func_78326_a() - 32 - 48 : 48;
							float dy = event.getResolution().func_78328_b() - 64;
							GlStateManager.func_179094_E();
							GlStateManager.func_179147_l();
							GlStateManager.func_179109_b(dx, dy, 0);
							GlStateManager.func_179152_a(.5f, .5f, 1);
							GlStateManager.func_179131_c(1, 1, 1, 1);

							ClientUtils.drawTexturedRect(0, 1, 74, 74, 0 / 256f, 74 / 256f, 51 / 256f, 125 / 256f);
							if (bulletAmount >= 18)
								ClientUtils.drawTexturedRect(47, 1, 103, 74, 74 / 256f, 177 / 256f, 51 / 256f, 125 / 256f);
							else if (bulletAmount > 8)
								ClientUtils.drawTexturedRect(57, 1, 79, 39, 57 / 256f, 136 / 256f, 12 / 256f, 51 / 256f);

							RenderItem ir = ClientUtils.mc().func_175599_af();
							int[][] slots = ContainerRevolver.slotPositions[bulletAmount >= 18 ? 2 : bulletAmount > 8 ? 1 : 0];
							for (int i = 0; i < bulletAmount; i++)
							{
								ItemStack b = bullets.get(i);
								if (!b.func_190926_b())
								{
									int x = 0;
									int y = 0;
									if (i == 0)
									{
										x = 29;
										y = 3;
									} else if (i - 1 < slots.length)
									{
										x = slots[i - 1][0];
										y = slots[i - 1][1];
									} else
									{
										int ii = i - (slots.length + 1);
										x = ii == 0 ? 48 : ii == 1 ? 29 : ii == 3 ? 2 : 10;
										y = ii == 1 ? 57 : ii == 3 ? 30 : ii == 4 ? 11 : 49;
									}

									ir.func_175042_a(b, x, y);
								}
							}

							if (equipped.func_77973_b() instanceof ItemRevolver)
							{
								int cd = ((ItemRevolver) equipped.func_77973_b()).getShootCooldown(equipped);
								float cdMax = ((ItemRevolver) equipped.func_77973_b()).getMaxShootCooldown(equipped);
								float cooldown = 1 - cd / cdMax;
								if (cooldown > 0)
								{
									GlStateManager.func_179152_a(2, 2, 1);
									GlStateManager.func_179109_b(-dx, -dy, 0);
									GlStateManager.func_179109_b(event.getResolution().func_78326_a() / 2 + (right ? 1 : -6), event.getResolution().func_78328_b() / 2 - 7, 0);

									float h1 = cooldown > .33 ? .5f : cooldown * 1.5f;
									float h2 = cooldown;
									float x2 = cooldown < .75 ? 1 : 4 * (1 - cooldown);

									float uMin = (88 + (right ? 0 : 7 * x2)) / 256f;
									float uMax = (88 + (right ? 7 * x2 : 0)) / 256f;
									float vMin1 = (112 + (right ? h1 : h2) * 15) / 256f;
									float vMin2 = (112 + (right ? h2 : h1) * 15) / 256f;

									ClientUtils.bindTexture("immersiveengineering:textures/gui/hud_elements.png");
									Tessellator tessellator = Tessellator.func_178181_a();
									BufferBuilder worldrenderer = tessellator.func_178180_c();
									worldrenderer.func_181668_a(GL11.GL_QUADS, DefaultVertexFormats.field_181707_g);
									worldrenderer.func_181662_b((right ? 0 : 1 - x2) * 7, 15, 0).func_187315_a(uMin, 127 / 256f).func_181675_d();
									worldrenderer.func_181662_b((right ? x2 : 1) * 7, 15, 0).func_187315_a(uMax, 127 / 256f).func_181675_d();
									worldrenderer.func_181662_b((right ? x2 : 1) * 7, (right ? h2 : h1) * 15, 0).func_187315_a(uMax, vMin2).func_181675_d();
									worldrenderer.func_181662_b((right ? 0 : 1 - x2) * 7, (right ? h1 : h2) * 15, 0).func_187315_a(uMin, vMin1).func_181675_d();
									tessellator.func_78381_a();
								}
							}
							RenderHelper.func_74518_a();
							GlStateManager.func_179084_k();
							GlStateManager.func_179121_F();
						}

					} else if(equipped.func_77973_b() instanceof ItemRailgun)
					{
						int duration = 72000 - (player.func_184587_cr()&&player.func_184600_cs()==hand?player.func_184605_cv():0);
						int chargeTime = ((ItemRailgun)equipped.func_77973_b()).getChargeTime(equipped);
						int chargeLevel = duration < 72000 ? Math.min(99, (int)(duration / (float)chargeTime * 100)) : 0;
						float scale = 2f;
						GlStateManager.func_179094_E();
						GlStateManager.func_179109_b(event.getResolution().func_78326_a() - 80, event.getResolution().func_78328_b() - 30, 0);
						GlStateManager.func_179152_a(scale, scale, 1);
						ClientProxy.nixieFont.func_175065_a((chargeLevel < 10 ? "0" : "") + chargeLevel, 0, 0, Lib.colour_nixieTubeText, false);
						GlStateManager.func_179152_a(1 / scale, 1 / scale, 1);
						GlStateManager.func_179121_F();
					}
					else if((equipped.func_77973_b() instanceof ItemDrill && equipped.func_77952_i()==0)
							||equipped.func_77973_b() instanceof ItemChemthrower)
					{
						boolean drill = equipped.func_77973_b() instanceof ItemDrill;
						ClientUtils.bindTexture("immersiveengineering:textures/gui/hud_elements.png");
						GlStateManager.func_179131_c(1, 1, 1, 1);
						float dx = event.getResolution().func_78326_a()-16;
						float dy = event.getResolution().func_78328_b();
						GlStateManager.func_179094_E();
						GlStateManager.func_179109_b(dx, dy, 0);
						int w = 31;
						int h = 62;
						double uMin = 179/256f;
						double uMax = 210/256f;
						double vMin = 9/256f;
						double vMax = 71/256f;
						ClientUtils.drawTexturedRect(-24,-68, w,h, uMin,uMax,vMin,vMax);

						GlStateManager.func_179109_b(-23,-37,0);
						IFluidHandler handler = FluidUtil.getFluidHandler(equipped);
						int capacity = -1;
						if(handler!=null)
						{
							IFluidTankProperties[] props = handler.getTankProperties();
							if(props!=null&&props.length>0)
								capacity = props[0].getCapacity();
						}
						if(capacity>-1)
						{
							FluidStack fuel = FluidUtil.getFluidContained(equipped);
							int amount = fuel != null ? fuel.amount : 0;
							if(!drill && player.func_184587_cr() && player.func_184600_cs()==hand)
							{
								int use = player.func_184612_cw();
								amount -= use * IEConfig.Tools.chemthrower_consumption;
							}
							float cap = (float) capacity;
							float angle = 83 - (166 * amount / cap);
							GlStateManager.func_179114_b(angle, 0, 0, 1);
							ClientUtils.drawTexturedRect(6, -2, 24, 4, 91 / 256f, 123 / 256f, 80 / 256f, 87 / 256f);
							GlStateManager.func_179114_b(-angle, 0, 0, 1);
							//					for(int i=0; i<=8; i++)
							//					{
							//						float angle = 83-(166/8f)*i;
							//						GL11.glRotatef(angle, 0, 0, 1);
							//						ClientUtils.drawTexturedRect(6,-2, 24,4, 91/256f,123/256f, 80/96f,87/96f);
							//						GL11.glRotatef(-angle, 0, 0, 1);
							//					}
							GlStateManager.func_179109_b(23, 37, 0);
							if(drill)
							{
								ClientUtils.drawTexturedRect(-54, -73, 66, 72, 108 / 256f, 174 / 256f, 4 / 256f, 76 / 256f);
								RenderItem ir = ClientUtils.mc().func_175599_af();
								ItemStack head = ((ItemDrill) equipped.func_77973_b()).getHead(equipped);
								if(!head.func_190926_b())
								{
									ir.func_175042_a(head, -51, -45);
									ir.func_180453_a(head.func_77973_b().getFontRenderer(head), head, -51, -45, null);
									RenderHelper.func_74518_a();
								}
							} else
							{
								ClientUtils.drawTexturedRect(-41, -73, 53, 72, 8 / 256f, 61 / 256f, 4 / 256f, 76 / 256f);
								boolean ignite = ItemNBTHelper.getBoolean(equipped, "ignite");
								ClientUtils.drawTexturedRect(-32, -43, 12, 12, 66 / 256f, 78 / 256f, (ignite ? 21 : 9) / 256f, (ignite ? 33 : 21) / 256f);

								ClientUtils.drawTexturedRect(-100, -20, 64, 16, 0 / 256f, 64 / 256f, 76 / 256f, 92 / 256f);
								if(fuel!=null)
								{
									String name = ClientUtils.font().func_78269_a(fuel.getLocalizedName(), 50).trim();
									ClientUtils.font().func_78276_b(name, -68-ClientUtils.font().func_78256_a(name)/2, -15, 0);
								}
							}
						}
						GlStateManager.func_179121_F();
					}
					else if(equipped.func_77973_b() instanceof ItemIEShield)
					{
						NBTTagCompound upgrades = ((ItemIEShield)equipped.func_77973_b()).getUpgrades(equipped);
						if(!upgrades.func_82582_d())
						{
							ClientUtils.bindTexture("immersiveengineering:textures/gui/hud_elements.png");
							GlStateManager.func_179131_c(1, 1, 1, 1);
							boolean boundLeft = (player.func_184591_cq()==EnumHandSide.RIGHT)==(hand==EnumHand.OFF_HAND);
							float dx = boundLeft?16: (event.getResolution().func_78326_a()-16-64);
							float dy = event.getResolution().func_78328_b();
							GlStateManager.func_179094_E();
							GlStateManager.func_179147_l();
							GlStateManager.func_179109_b(dx, dy, 0);
							ClientUtils.drawTexturedRect(0, -22, 64, 22, 0, 64/256f, 176/256f, 198/256f);

							if(upgrades.func_74767_n("flash"))
							{
								ClientUtils.drawTexturedRect(11, -38, 16, 16, 11/256f, 27/256f, 160/256f, 176/256f);
								if(upgrades.func_74764_b("flash_cooldown"))
								{
									float h = upgrades.func_74762_e("flash_cooldown")/40f*16;
									ClientUtils.drawTexturedRect(11, -22-h, 16, h, 11/256f, 27/256f, (214-h)/256f, 214/256f);
								}
							}
							if(upgrades.func_74767_n("shock"))
							{
								ClientUtils.drawTexturedRect(40, -38, 12, 16, 40/256f, 52/256f, 160/256f, 176/256f);
								if(upgrades.func_74764_b("shock_cooldown"))
								{
									float h = upgrades.func_74762_e("shock_cooldown")/40f*16;
									ClientUtils.drawTexturedRect(40, -22-h, 12, h, 40/256f, 52/256f, (214-h)/256f, 214/256f);
								}
							}
							GlStateManager.func_179084_k();
							GlStateManager.func_179121_F();
						}
					}
					//				else if(equipped.getItem() instanceof ItemRailgun)
					//				{
					//					float dx = event.getResolution().getScaledWidth()-32-48;
					//					float dy = event.getResolution().getScaledHeight()-40;
					//					ClientUtils.bindTexture("immersiveengineering:textures/gui/hud_elements.png");
					//					GlStateManager.color(1, 1, 1, 1);
					//					GlStateManager.pushMatrix();
					//					GL11.glEnable(GL11.GL_BLEND);
					//					GlStateManager.translate(dx, dy, 0);
					//
					//					int duration = player.getItemInUseDuration();
					//					int chargeTime = ((ItemRailgun)equipped.getItem()).getChargeTime(equipped);
					//					int chargeLevel = Math.min(99, (int)(duration/(float)chargeTime*100));
					//					//					ClientUtils.drawTexturedRect(0,0, 64,32, 0/256f,64/256f, 96/256f,128/256f);
					//
					//					GL11.glScalef(1.5f,1.5f,1.5f);
					//					int col = Config.getBoolean("nixietubeFont")?Lib.colour_nixieTubeText:0xffffff;
					//					ClientProxy.nixieFont.setDrawTubeFlag(false);
					//					//					ClientProxy.nixieFont.drawString((chargeLevel<10?"0"+chargeLevel:""+chargeLevel), 19,3, col);
					//					ClientProxy.nixieFont.setDrawTubeFlag(true);
					//
					//					GL11.glPopMatrix();
					//				}

					RayTraceResult mop = ClientUtils.mc().field_71476_x;
					if(mop!=null && mop.func_178782_a()!=null)
					{
						TileEntity tileEntity = player.field_70170_p.func_175625_s(mop.func_178782_a());
						if(OreDictionary.itemMatches(new ItemStack(IEContent.itemTool,1,2), equipped, true))
						{
							int col = IEConfig.nixietubeFont?Lib.colour_nixieTubeText:0xffffff;
							String[] text = null;
							if(tileEntity instanceof IFluxReceiver)
							{
								int maxStorage = ((IFluxReceiver)tileEntity).getMaxEnergyStored(mop.field_178784_b);
								int storage = ((IFluxReceiver)tileEntity).getEnergyStored(mop.field_178784_b);
								if(maxStorage>0)
									text = I18n.func_135052_a(Lib.DESC_INFO+"energyStored","<br>"+Utils.toScientificNotation(storage,"0##",100000)+" / "+Utils.toScientificNotation(maxStorage,"0##",100000)).split("<br>");
							}
							//						else if(Lib.GREG && GregTechHelper.gregtech_isValidEnergyOutput(tileEntity))
							//						{
							//							String gregStored = GregTechHelper.gregtech_getEnergyStored(tileEntity);
							//							if(gregStored!=null)
							//								text = StatCollector.translateToLocalFormatted(Lib.DESC_INFO+"energyStored","<br>"+gregStored).split("<br>");
							//						}
							else if(mop.field_72308_g instanceof IFluxReceiver)
							{
								int maxStorage = ((IFluxReceiver)mop.field_72308_g).getMaxEnergyStored(null);
								int storage = ((IFluxReceiver)mop.field_72308_g).getEnergyStored(null);
								if(maxStorage>0)
									text = I18n.func_135052_a(Lib.DESC_INFO+"energyStored","<br>"+Utils.toScientificNotation(storage,"0##",100000)+" / "+Utils.toScientificNotation(maxStorage,"0##",100000)).split("<br>");
							}
							if(text!=null)
							{
								if (player.field_70170_p.func_82737_E()%20==0)
								{
									ImmersiveEngineering.packetHandler.sendToServer(new MessageRequestBlockUpdate(player.field_71093_bK, mop.func_178782_a()));
								}
								int i = 0;
								for(String s : text)
									if(s!=null)
									{
										int w = ClientProxy.nixieFontOptional.func_78256_a(s);
										ClientProxy.nixieFontOptional.func_175065_a(s, event.getResolution().func_78326_a()/2-w/2, event.getResolution().func_78328_b()/2-4-text.length*(ClientProxy.nixieFontOptional.field_78288_b+2)+(i++)*(ClientProxy.nixieFontOptional.field_78288_b+2), col, true);
									}
							}
						}
					}
				}
			if(ClientUtils.mc().field_71476_x!=null)
			{
				boolean hammer = !player.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && Utils.isHammer(player.func_184586_b(EnumHand.MAIN_HAND));
				RayTraceResult mop = ClientUtils.mc().field_71476_x;
				if(mop!=null && mop.func_178782_a()!=null)
				{
					TileEntity tileEntity = player.field_70170_p.func_175625_s(mop.func_178782_a());
					if(tileEntity instanceof IBlockOverlayText)
					{
						IBlockOverlayText overlayBlock = (IBlockOverlayText) tileEntity;
						String[] text = overlayBlock.getOverlayText(ClientUtils.mc().field_71439_g, mop, hammer);
						boolean useNixie = overlayBlock.useNixieFont(ClientUtils.mc().field_71439_g, mop);
						if(text!=null && text.length>0)
						{
							FontRenderer font = useNixie?ClientProxy.nixieFontOptional:ClientUtils.font();
							int col = (useNixie&& IEConfig.nixietubeFont)?Lib.colour_nixieTubeText:0xffffff;
							int i = 0;
							for(String s : text)
								if(s!=null)
									font.func_175065_a(s, event.getResolution().func_78326_a()/2+8, event.getResolution().func_78328_b()/2+8+(i++)*font.field_78288_b, col, true);
						}
					}
				}
			}
		}
	}

	@SubscribeEvent()
	public void onFogUpdate(EntityViewRenderEvent.RenderFogEvent event)
	{
		if(event.getEntity() instanceof EntityLivingBase && ((EntityLivingBase)event.getEntity()).func_70660_b(IEPotions.flashed)!=null)
		{
			PotionEffect effect = ((EntityLivingBase)event.getEntity()).func_70660_b(IEPotions.flashed);
			int timeLeft = effect.func_76459_b();
			float saturation = 1-timeLeft/(float)(80+40*effect.func_76458_c());//Total Time =  4s + 2s per amplifier

			float f1 = -2.5f+15.0F*saturation;
			if(timeLeft<20)
				f1 += (event.getFarPlaneDistance()/4) * (1-timeLeft/20f);

			GlStateManager.func_187430_a(GlStateManager.FogMode.LINEAR);
			GlStateManager.func_179102_b(f1 * 0.25F);
			GlStateManager.func_179153_c(f1);
			GlStateManager.func_179095_a(.125f);

			if(GLContext.getCapabilities().GL_NV_fog_distance)
				GlStateManager.func_187412_c(34138, 34139);
		}
	}
	@SubscribeEvent()
	public void onFogColourUpdate(EntityViewRenderEvent.FogColors event)
	{
		if(event.getEntity() instanceof EntityLivingBase && ((EntityLivingBase)event.getEntity()).func_70660_b(IEPotions.flashed)!=null)
		{
			event.setRed(1);
			event.setGreen(1);
			event.setBlue(1);
		}
	}

	@SubscribeEvent()
	public void onFOVUpdate(FOVUpdateEvent event)
	{
		EntityPlayer player = ClientUtils.mc().field_71439_g;
		if(!player.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof IZoomTool)
		{
			if(player.func_70093_af() && player.field_70122_E)
			{
				ItemStack equipped = player.func_184586_b(EnumHand.MAIN_HAND);
				IZoomTool tool = (IZoomTool)equipped.func_77973_b();
				if(tool.canZoom(equipped, player))
				{
					if(!ZoomHandler.isZooming)
					{
						float[] steps = tool.getZoomSteps(equipped, player);
						if(steps!=null && steps.length>0)
						{
							int curStep = -1;
							float dist=0;
							for(int i=0; i<steps.length; i++)
								if(curStep==-1 || Math.abs(steps[i]-ZoomHandler.fovZoom)<dist)
								{
									curStep = i;
									dist = Math.abs(steps[i]-ZoomHandler.fovZoom);
								}
							if(curStep!=-1)
								ZoomHandler.fovZoom = steps[curStep];
							else
								ZoomHandler.fovZoom = event.getFov();
						}
						ZoomHandler.isZooming = true;
					}
					event.setNewfov(ZoomHandler.fovZoom);
				}
				else if(ZoomHandler.isZooming)
					ZoomHandler.isZooming = false;
			}
			else if(ZoomHandler.isZooming)
				ZoomHandler.isZooming = false;
		}
		else if(ZoomHandler.isZooming)
			ZoomHandler.isZooming = false;
		if(player.func_70660_b(IEPotions.concreteFeet)!=null)
			event.setNewfov(1);

	}
	@SubscribeEvent
	public void onMouseEvent(MouseEvent event)
	{
		if(event.getDwheel() != 0)
		{
			EntityPlayer player = ClientUtils.mc().field_71439_g;
			if(!player.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && player.func_70093_af())
			{
				ItemStack equipped = player.func_184586_b(EnumHand.MAIN_HAND);

				if(equipped.func_77973_b() instanceof IZoomTool)
				{
					IZoomTool tool = (IZoomTool)equipped.func_77973_b();
					if(tool.canZoom(equipped, player))
					{
						float[] steps = tool.getZoomSteps(equipped, player);
						if(steps!=null&&steps.length > 0)
						{
							int curStep = -1;
							float dist = 0;
							for(int i = 0; i < steps.length; i++)
								if(curStep==-1||Math.abs(steps[i]-ZoomHandler.fovZoom) < dist)
								{
									curStep = i;
									dist = Math.abs(steps[i]-ZoomHandler.fovZoom);
								}
							if(curStep!=-1)
							{
								int newStep = curStep+(event.getDwheel() > 0?-1: 1);
								if(newStep >= 0&&newStep < steps.length)
									ZoomHandler.fovZoom = steps[newStep];
								event.setCanceled(true);
							}
						}
					}
				}
				if(Config.IEConfig.Tools.chemthrower_scroll && equipped.func_77973_b() instanceof ItemChemthrower && ((ItemChemthrower)equipped.func_77973_b()).getUpgrades(equipped).func_74767_n("multitank"))
				{
					ImmersiveEngineering.packetHandler.sendToServer(new MessageChemthrowerSwitch(player.func_70005_c_(), event.getDwheel()<0));
					event.setCanceled(true);
				}
			}
		}
	}

	@SubscribeEvent(priority = EventPriority.LOW)
	public void onKey(GuiScreenEvent.MouseInputEvent.Pre event)
	{
		//Stopping cpw's inventory sorter till I can get him to make it better
		if(event.getGui() instanceof GuiToolbox && Mouse.getEventButton()==2)
			event.setCanceled(true);
	}

	@SubscribeEvent()
	public void renderAdditionalBlockBounds(DrawBlockHighlightEvent event)
	{
		if(event.getSubID()==0 && event.getTarget().field_72313_a== Type.BLOCK)
		{
			float f1 = 0.002F;
			double px = -TileEntityRendererDispatcher.field_147554_b;
			double py = -TileEntityRendererDispatcher.field_147555_c;
			double pz = -TileEntityRendererDispatcher.field_147552_d;
			TileEntity tile = event.getPlayer().field_70170_p.func_175625_s(event.getTarget().func_178782_a());
			ItemStack stack = event.getPlayer().func_184586_b(EnumHand.MAIN_HAND);
			//			if(event.getPlayer().world.getBlockState(event.getTarget().getBlockPos()).getBlock() instanceof IEBlockInterfaces.ICustomBoundingboxes)
			if(tile instanceof IAdvancedSelectionBounds)
			{
				//				IEBlockInterfaces.ICustomBoundingboxes block = (IEBlockInterfaces.ICustomBoundingboxes) event.getPlayer().world.getBlockState(event.getTarget().getBlockPos()).getBlock();
				IAdvancedSelectionBounds iasb = (IAdvancedSelectionBounds)tile;
				List<AxisAlignedBB> boxes = iasb.getAdvancedSelectionBounds();
				if(boxes!=null && !boxes.isEmpty())
				{
					GlStateManager.func_179147_l();
					GlStateManager.func_187428_a(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ZERO);
					GlStateManager.func_187441_d(2.0F);
					GlStateManager.func_179090_x();
					GlStateManager.func_179132_a(false);
					ArrayList<AxisAlignedBB> additionalBoxes = new ArrayList<AxisAlignedBB>();
					AxisAlignedBB overrideBox = null;
					for(AxisAlignedBB aabb : boxes)
						if(aabb!=null)
						{
							if(iasb.isOverrideBox(aabb, event.getPlayer(), event.getTarget(), additionalBoxes))
								overrideBox = aabb;
						}

					if(overrideBox!=null)
						RenderGlobal.func_189697_a(overrideBox.func_186662_g(f1).func_72317_d(px, py, pz), 0, 0, 0, 0.4f);
					else
						for(AxisAlignedBB aabb : additionalBoxes.isEmpty()?boxes:additionalBoxes)
							RenderGlobal.func_189697_a(aabb.func_186662_g(f1).func_72317_d(px, py, pz), 0, 0, 0, 0.4f);
					GlStateManager.func_179132_a(true);
					GlStateManager.func_179098_w();
					GlStateManager.func_179084_k();
					event.setCanceled(true);
				}
			}

			if(Utils.isHammer(stack) && tile instanceof TileEntityTurntable)
			{
				BlockPos pos = event.getTarget().func_178782_a();

				GlStateManager.func_179147_l();
				GlStateManager.func_187428_a(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ZERO);
				GlStateManager.func_187441_d(2.0F);
				GlStateManager.func_179090_x();
				GlStateManager.func_179132_a(false);

				Tessellator tessellator = Tessellator.func_178181_a();
				BufferBuilder BufferBuilder = tessellator.func_178180_c();

				EnumFacing f = ((TileEntityTurntable)tile).getFacing();
				double tx = pos.func_177958_n()+.5;
				double ty = pos.func_177956_o()+.5;
				double tz = pos.func_177952_p()+.5;
				if(!event.getPlayer().field_70170_p.func_175623_d(pos.func_177972_a(f)))
				{
					tx += f.func_82601_c();
					ty += f.func_96559_d();
					tz += f.func_82599_e();
				}
				BufferBuilder.func_178969_c(tx+px,ty+py,tz+pz);

				double angle = -event.getPlayer().field_70173_aa%80/40d*Math.PI;
				drawRotationArrows(tessellator, BufferBuilder, f, angle, ((TileEntityTurntable)tile).invert);

				BufferBuilder.func_178969_c(0, 0, 0);

				GlStateManager.func_179132_a(true);
				GlStateManager.func_179098_w();
				GlStateManager.func_179084_k();
			}

			World world = event.getPlayer().field_70170_p;
			if(!stack.func_190926_b() && IEContent.blockConveyor.equals(Block.func_149634_a(stack.func_77973_b())) && event.getTarget().field_178784_b.func_176740_k() == Axis.Y)
			{
				EnumFacing side = event.getTarget().field_178784_b;
				BlockPos pos = event.getTarget().func_178782_a();
				AxisAlignedBB targetedBB = world.func_180495_p(pos).func_185918_c(world, pos);
				if(targetedBB != null)
					targetedBB = targetedBB.func_72317_d(-pos.func_177958_n(), -pos.func_177956_o(), -pos.func_177952_p());
				GlStateManager.func_179147_l();
				GlStateManager.func_187428_a(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ZERO);
				GlStateManager.func_187441_d(2.0F);
				GlStateManager.func_179090_x();
				GlStateManager.func_179132_a(false);

				Tessellator tessellator = Tessellator.func_178181_a();
				BufferBuilder BufferBuilder = tessellator.func_178180_c();
				BufferBuilder.func_178969_c(pos.func_177958_n() + px, pos.func_177956_o() + py, pos.func_177952_p() + pz);
				double[][] points = new double[4][];


				if(side.func_176740_k() == Axis.Y)
				{
					points[0] = new double[]{0 - f1, side == EnumFacing.DOWN ? ((targetedBB != null ? targetedBB.field_72338_b : 0) - f1) : ((targetedBB != null ? targetedBB.field_72337_e : 1) + f1), 0 - f1};
					points[1] = new double[]{1 + f1, side == EnumFacing.DOWN ? ((targetedBB != null ? targetedBB.field_72338_b : 0) - f1) : ((targetedBB != null ? targetedBB.field_72337_e : 1) + f1), 1 + f1};
					points[2] = new double[]{0 - f1, side == EnumFacing.DOWN ? ((targetedBB != null ? targetedBB.field_72338_b : 0) - f1) : ((targetedBB != null ? targetedBB.field_72337_e : 1) + f1), 1 + f1};
					points[3] = new double[]{1 + f1, side == EnumFacing.DOWN ? ((targetedBB != null ? targetedBB.field_72338_b : 0) - f1) : ((targetedBB != null ? targetedBB.field_72337_e : 1) + f1), 0 - f1};
				} else if(side.func_176740_k() == Axis.Z)
				{
					points[0] = new double[]{1 + f1, 1 + f1, side == EnumFacing.NORTH ? ((targetedBB != null ? targetedBB.field_72339_c : 0) - f1) : ((targetedBB != null ? targetedBB.field_72334_f : 1) + f1)};
					points[1] = new double[]{0 - f1, 0 - f1, side == EnumFacing.NORTH ? ((targetedBB != null ? targetedBB.field_72339_c : 0) - f1) : ((targetedBB != null ? targetedBB.field_72334_f : 1) + f1)};
					points[2] = new double[]{0 - f1, 1 + f1, side == EnumFacing.NORTH ? ((targetedBB != null ? targetedBB.field_72339_c : 0) - f1) : ((targetedBB != null ? targetedBB.field_72334_f : 1) + f1)};
					points[3] = new double[]{1 + f1, 0 - f1, side == EnumFacing.NORTH ? ((targetedBB != null ? targetedBB.field_72339_c : 0) - f1) : ((targetedBB != null ? targetedBB.field_72334_f : 1) + f1)};
				} else
				{
					points[0] = new double[]{side == EnumFacing.WEST ? ((targetedBB != null ? targetedBB.field_72340_a : 0) - f1) : ((targetedBB != null ? targetedBB.field_72336_d : 1) + f1), 1 + f1, 1 + f1};
					points[1] = new double[]{side == EnumFacing.WEST ? ((targetedBB != null ? targetedBB.field_72340_a : 0) - f1) : ((targetedBB != null ? targetedBB.field_72336_d : 1) + f1), 0 - f1, 0 - f1};
					points[2] = new double[]{side == EnumFacing.WEST ? ((targetedBB != null ? targetedBB.field_72340_a : 0) - f1) : ((targetedBB != null ? targetedBB.field_72336_d : 1) + f1), 1 + f1, 0 - f1};
					points[3] = new double[]{side == EnumFacing.WEST ? ((targetedBB != null ? targetedBB.field_72340_a : 0) - f1) : ((targetedBB != null ? targetedBB.field_72336_d : 1) + f1), 0 - f1, 1 + f1};
				}
				BufferBuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
				for(double[] point : points)
					BufferBuilder.func_181662_b(point[0], point[1], point[2]).func_181666_a(0, 0, 0, 0.4F).func_181675_d();
				tessellator.func_78381_a();

				BufferBuilder.func_181668_a(2, DefaultVertexFormats.field_181706_f);
				BufferBuilder.func_181662_b(points[0][0], points[0][1], points[0][2]).func_181666_a(0, 0, 0, 0.4F).func_181675_d();
				BufferBuilder.func_181662_b(points[2][0], points[2][1], points[2][2]).func_181666_a(0, 0, 0, 0.4F).func_181675_d();
				BufferBuilder.func_181662_b(points[1][0], points[1][1], points[1][2]).func_181666_a(0, 0, 0, 0.4F).func_181675_d();
				BufferBuilder.func_181662_b(points[3][0], points[3][1], points[3][2]).func_181666_a(0, 0, 0, 0.4F).func_181675_d();
				tessellator.func_78381_a();

				float xFromMid = side.func_176740_k() == Axis.X ? 0 : (float) event.getTarget().field_72307_f.field_72450_a - pos.func_177958_n() - .5f;
				float yFromMid = side.func_176740_k() == Axis.Y ? 0 : (float) event.getTarget().field_72307_f.field_72448_b - pos.func_177956_o() - .5f;
				float zFromMid = side.func_176740_k() == Axis.Z ? 0 : (float) event.getTarget().field_72307_f.field_72449_c - pos.func_177952_p() - .5f;
				float max = Math.max(Math.abs(yFromMid), Math.max(Math.abs(xFromMid), Math.abs(zFromMid)));
				Vec3d dir = new Vec3d(max == Math.abs(xFromMid) ? Math.signum(xFromMid) : 0, max == Math.abs(yFromMid) ? Math.signum(yFromMid) : 0, max == Math.abs(zFromMid) ? Math.signum(zFromMid) : 0);
				if(dir != null)
					drawBlockOverlayArrow(tessellator, BufferBuilder, dir, side, targetedBB);
				BufferBuilder.func_178969_c(0, 0, 0);

				GlStateManager.func_179132_a(true);
				GlStateManager.func_179098_w();
				GlStateManager.func_179084_k();
			}

			if(!stack.func_190926_b() && stack.func_77973_b() instanceof ItemDrill && ((ItemDrill)stack.func_77973_b()).isEffective(world.func_180495_p(event.getTarget().func_178782_a()).func_185904_a()))
			{
				ItemStack head = ((ItemDrill)stack.func_77973_b()).getHead(stack);
				if(!head.func_190926_b())
				{
					ImmutableList<BlockPos> blocks = ((IDrillHead)head.func_77973_b()).getExtraBlocksDug(head, world, event.getPlayer(), event.getTarget());
					drawAdditionalBlockbreak(event.getContext(), event.getPlayer(), event.getPartialTicks(), blocks);
				}
			}
		}
	}

	private static double[][] rotationArrowCoords = {{.375, 0},{.5, -.125},{.4375, -.125},{.4375, -.25},{.25, -.4375},{-.25, -.4375},{-.4375, -.25},{-.4375, -.0625},{-.3125, -.0625},{-.3125, -.1875},{-.1875, -.3125},{.1875, -.3125},{.3125, -.1875},{.3125, -.125},{.25, -.125}};
	private static double[][] rotationArrowQuads = {rotationArrowCoords[7], rotationArrowCoords[8], rotationArrowCoords[6], rotationArrowCoords[9], rotationArrowCoords[5], rotationArrowCoords[10], rotationArrowCoords[4], rotationArrowCoords[11], rotationArrowCoords[3], rotationArrowCoords[12], rotationArrowCoords[2], rotationArrowCoords[13], rotationArrowCoords[1], rotationArrowCoords[14], rotationArrowCoords[0], rotationArrowCoords[0]};
	public static void drawRotationArrows(Tessellator tessellator, BufferBuilder BufferBuilder, EnumFacing facing, double rotation, boolean flip)
	{
		double cos = Math.cos(rotation);
		double sin = Math.sin(rotation);
		BufferBuilder.func_181668_a(GL11.GL_LINE_LOOP, DefaultVertexFormats.field_181706_f);
		for(double[] p : rotationArrowCoords)
		{
			double w = (cos*p[0]+sin*p[1]);
			double h = (-sin*p[0]+cos*p[1]);
			double xx = facing.func_82601_c()<0?-(.5+.002): facing.func_82601_c()>0?(.5+.002): (facing.func_176740_k()==Axis.Y^flip?-1:1)*facing.func_176743_c().func_179524_a()*h;
			double yy = facing.func_96559_d()<0?-(.5+.002): facing.func_96559_d()>0?(.5+.002): w;
			double zz = facing.func_82599_e()<0?-(.5+.002): facing.func_82599_e()>0?(.5+.002): facing.func_176740_k()==Axis.X?(flip?1:-1)*facing.func_176743_c().func_179524_a()*h: w;
			BufferBuilder.func_181662_b(xx, yy, zz).func_181666_a(0, 0, 0, 0.4F).func_181675_d();
		}
		tessellator.func_78381_a();
		BufferBuilder.func_181668_a(GL11.GL_LINE_LOOP, DefaultVertexFormats.field_181706_f);
		for(double[] p : rotationArrowCoords)
		{
			double w = (cos*p[0]+sin*p[1]);
			double h = (-sin*p[0]+cos*p[1]);
			double xx = facing.func_82601_c()<0?-(.5+.002): facing.func_82601_c()>0?(.5+.002): (facing.func_176740_k()==Axis.Y^flip?1:-1)*facing.func_176743_c().func_179524_a()*h;
			double yy = facing.func_96559_d()<0?-(.5+.002): facing.func_96559_d()>0?(.5+.002): -w;
			double zz = facing.func_82599_e()<0?-(.5+.002): facing.func_82599_e()>0?(.5+.002): facing.func_176740_k()==Axis.X?(flip?-1:1)*facing.func_176743_c().func_179524_a()*h: -w;
			BufferBuilder.func_181662_b(xx, yy, zz).func_181666_a(0, 0, 0, 0.4F).func_181675_d();
		}
		tessellator.func_78381_a();

		BufferBuilder.func_181668_a(GL11.GL_QUAD_STRIP, DefaultVertexFormats.field_181706_f);
		for(double[] p : rotationArrowQuads)
		{
			double w = (cos*p[0]+sin*p[1]);
			double h = (-sin*p[0]+cos*p[1]);
			double xx = facing.func_82601_c()<0?-(.5+.002): facing.func_82601_c()>0?(.5+.002): (facing.func_176740_k()==Axis.Y^flip?-1:1)*facing.func_176743_c().func_179524_a()*h;
			double yy = facing.func_96559_d()<0?-(.5+.002): facing.func_96559_d()>0?(.5+.002): w;
			double zz = facing.func_82599_e()<0?-(.5+.002): facing.func_82599_e()>0?(.5+.002): facing.func_176740_k()==Axis.X?(flip?1:-1)*facing.func_176743_c().func_179524_a()*h: w;
			BufferBuilder.func_181662_b(xx, yy, zz).func_181666_a(Lib.COLOUR_F_ImmersiveOrange[0],Lib.COLOUR_F_ImmersiveOrange[1],Lib.COLOUR_F_ImmersiveOrange[2], 0.4F).func_181675_d();
		}
		tessellator.func_78381_a();
		BufferBuilder.func_181668_a(GL11.GL_QUAD_STRIP, DefaultVertexFormats.field_181706_f);
		for(double[] p : rotationArrowQuads)
		{
			double w = (cos*p[0]+sin*p[1]);
			double h = (-sin*p[0]+cos*p[1]);
			double xx = facing.func_82601_c()<0?-(.5+.002): facing.func_82601_c()>0?(.5+.002): (facing.func_176740_k()==Axis.Y^flip?1:-1)*facing.func_176743_c().func_179524_a()*h;
			double yy = facing.func_96559_d()<0?-(.5+.002): facing.func_96559_d()>0?(.5+.002): -w;
			double zz = facing.func_82599_e()<0?-(.5+.002): facing.func_82599_e()>0?(.5+.002): facing.func_176740_k()==Axis.X?(flip?-1:1)*facing.func_176743_c().func_179524_a()*h: -w;
			BufferBuilder.func_181662_b(xx, yy, zz).func_181666_a(Lib.COLOUR_F_ImmersiveOrange[0],Lib.COLOUR_F_ImmersiveOrange[1],Lib.COLOUR_F_ImmersiveOrange[2], 0.4F).func_181675_d();
		}
		tessellator.func_78381_a();
	}

	private static float[][] arrowCoords = {{0, .375f}, {.3125f, .0625f}, {.125f, .0625f}, {.125f, -.375f}, {-.125f, -.375f}, {-.125f, .0625f}, {-.3125f, .0625f}};

	public static void drawBlockOverlayArrow(Tessellator tessellator, BufferBuilder BufferBuilder, Vec3d directionVec, EnumFacing side, AxisAlignedBB targetedBB)
	{
		Vec3d[] translatedPositions = new Vec3d[arrowCoords.length];
		Matrix4 mat = new Matrix4();
		Vec3d defaultDir = side.func_176740_k() == Axis.Y ? new Vec3d(0, 0, 1) : new Vec3d(0, 1, 0);
		directionVec = directionVec.func_72432_b();
		double angle = Math.acos(defaultDir.func_72430_b(directionVec));
		Vec3d axis = defaultDir.func_72431_c(directionVec);
		mat.rotate(angle, axis.field_72450_a, axis.field_72448_b, axis.field_72449_c);
		if(side != null)
		{
			if(side.func_176740_k() == Axis.Z)
				mat.rotate(Math.PI / 2, 1, 0, 0).rotate(Math.PI, 0, 1, 0);
			else if(side.func_176740_k() == Axis.X)
				mat.rotate(Math.PI / 2, 0, 0, 1).rotate(Math.PI / 2, 0, 1, 0);
		}
		for(int i = 0; i < translatedPositions.length; i++)
		{
			Vec3d vec = mat.apply(new Vec3d(arrowCoords[i][0], 0, arrowCoords[i][1])).func_72441_c(.5, .5, .5);
			if(side != null && targetedBB != null)
				vec = new Vec3d(side == EnumFacing.WEST ? targetedBB.field_72340_a - .002 : side == EnumFacing.EAST ? targetedBB.field_72336_d + .002 : vec.field_72450_a, side == EnumFacing.DOWN ? targetedBB.field_72338_b - .002 : side == EnumFacing.UP ? targetedBB.field_72337_e + .002 : vec.field_72448_b, side == EnumFacing.NORTH ? targetedBB.field_72339_c - .002 : side == EnumFacing.SOUTH ? targetedBB.field_72334_f + .002 : vec.field_72449_c);
			translatedPositions[i] = vec;
		}

		BufferBuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
		for(Vec3d point : translatedPositions)
			BufferBuilder.func_181662_b(point.field_72450_a, point.field_72448_b, point.field_72449_c).func_181666_a(Lib.COLOUR_F_ImmersiveOrange[0], Lib.COLOUR_F_ImmersiveOrange[1], Lib.COLOUR_F_ImmersiveOrange[2], 0.4F).func_181675_d();
		tessellator.func_78381_a();
		BufferBuilder.func_181668_a(2, DefaultVertexFormats.field_181706_f);
		for(Vec3d point : translatedPositions)
			BufferBuilder.func_181662_b(point.field_72450_a, point.field_72448_b, point.field_72449_c).func_181666_a(0, 0, 0, 0.4F).func_181675_d();
		tessellator.func_78381_a();
	}

	public static void drawAdditionalBlockbreak(RenderGlobal context, EntityPlayer player, float partialTicks, Collection<BlockPos> blocks)
	{
		for(BlockPos pos : blocks)
			context.func_72731_b(player, new RayTraceResult(new Vec3d(0, 0, 0), null, pos), 0, partialTicks);

		PlayerControllerMP controllerMP = ClientUtils.mc().field_71442_b;
		if(controllerMP.field_78778_j)
			ClientUtils.drawBlockDamageTexture(ClientUtils.tes(), ClientUtils.tes().func_178180_c(), player, partialTicks, player.field_70170_p, blocks);
	}

	@SubscribeEvent
	public void onRenderWorldLastEvent(RenderWorldLastEvent event)
	{
		//Overlay renderer for the sample drill
		boolean chunkBorders = false;
		for(EnumHand hand : EnumHand.values())
			if(OreDictionary.itemMatches(new ItemStack(IEContent.blockMetalDevice1,1, BlockTypes_MetalDevice1.SAMPLE_DRILL.getMeta()), ClientUtils.mc().field_71439_g.func_184586_b(hand),true))
			{
				chunkBorders = true;
				break;
			}
		if(!chunkBorders && ClientUtils.mc().field_71476_x!=null && ClientUtils.mc().field_71476_x.field_72313_a==Type.BLOCK && ClientUtils.mc().field_71441_e.func_175625_s(ClientUtils.mc().field_71476_x.func_178782_a()) instanceof TileEntitySampleDrill)
			chunkBorders = true;

		if(chunkBorders)
		{
			EntityPlayer player = ClientUtils.mc().field_71439_g;
			double px = TileEntityRendererDispatcher.field_147554_b;
			double py = TileEntityRendererDispatcher.field_147555_c;
			double pz = TileEntityRendererDispatcher.field_147552_d;
			int chunkX = (int)player.field_70165_t>>4<<4;
			int chunkZ = (int)player.field_70161_v>>4<<4;
			int y = Math.min((int)player.field_70163_u-2,player.func_130014_f_().func_175726_f(new BlockPos(player.field_70165_t,0,player.field_70161_v)).func_177442_v());
			float h = (float)Math.max(32, player.field_70163_u-y+4);
			Tessellator tessellator = Tessellator.func_178181_a();
			BufferBuilder BufferBuilder = tessellator.func_178180_c();

			GlStateManager.func_179090_x();
			GlStateManager.func_179147_l();
			GlStateManager.func_179129_p();
			GlStateManager.func_179120_a(770, 771, 1, 0);
			GlStateManager.func_179103_j(GL11.GL_SMOOTH);
			float r = Lib.COLOUR_F_ImmersiveOrange[0];
			float g = Lib.COLOUR_F_ImmersiveOrange[1];
			float b = Lib.COLOUR_F_ImmersiveOrange[2];
			BufferBuilder.func_178969_c(chunkX-px, y+2-py, chunkZ-pz);
			GlStateManager.func_187441_d(5f);
			BufferBuilder.func_181668_a(GL11.GL_LINES, DefaultVertexFormats.field_181706_f);
			BufferBuilder.func_181662_b( 0,0, 0).func_181666_a(r,g,b,.375f).func_181675_d();
			BufferBuilder.func_181662_b( 0,h, 0).func_181666_a(r,g,b,.375f).func_181675_d();
			BufferBuilder.func_181662_b(16,0, 0).func_181666_a(r,g,b,.375f).func_181675_d();
			BufferBuilder.func_181662_b(16,h, 0).func_181666_a(r,g,b,.375f).func_181675_d();
			BufferBuilder.func_181662_b(16,0,16).func_181666_a(r,g,b,.375f).func_181675_d();
			BufferBuilder.func_181662_b(16,h,16).func_181666_a(r,g,b,.375f).func_181675_d();
			BufferBuilder.func_181662_b( 0,0,16).func_181666_a(r,g,b,.375f).func_181675_d();
			BufferBuilder.func_181662_b( 0,h,16).func_181666_a(r,g,b,.375f).func_181675_d();

			BufferBuilder.func_181662_b( 0,2, 0).func_181666_a(r,g,b,.375f).func_181675_d();
			BufferBuilder.func_181662_b(16,2, 0).func_181666_a(r,g,b,.375f).func_181675_d();
			BufferBuilder.func_181662_b( 0,2, 0).func_181666_a(r,g,b,.375f).func_181675_d();
			BufferBuilder.func_181662_b( 0,2,16).func_181666_a(r,g,b,.375f).func_181675_d();
			BufferBuilder.func_181662_b( 0,2,16).func_181666_a(r,g,b,.375f).func_181675_d();
			BufferBuilder.func_181662_b(16,2,16).func_181666_a(r,g,b,.375f).func_181675_d();
			BufferBuilder.func_181662_b(16,2, 0).func_181666_a(r,g,b,.375f).func_181675_d();
			BufferBuilder.func_181662_b(16,2,16).func_181666_a(r,g,b,.375f).func_181675_d();
			tessellator.func_78381_a();
			BufferBuilder.func_178969_c(0, 0, 0);
			GlStateManager.func_179103_j(GL11.GL_FLAT);
			GlStateManager.func_179089_o();
			GlStateManager.func_179084_k();
			GlStateManager.func_179098_w();
		}
	}

	//	static void renderBoundingBox(AxisAlignedBB aabb, double offsetX, double offsetY, double offsetZ, float expand)
	//	{
	//		if(aabb instanceof AdvancedAABB && ((AdvancedAABB)aabb).drawOverride!=null && ((AdvancedAABB)aabb).drawOverride.length>0)
	//		{
	//			double midX = aabb.minX+(aabb.maxX-aabb.minX)/2;
	//			double midY = aabb.minY+(aabb.maxY-aabb.minY)/2;
	//			double midZ = aabb.minZ+(aabb.maxZ-aabb.minZ)/2;
	//			ClientUtils.tes().addTranslation((float)offsetX, (float)offsetY, (float)offsetZ);
	//			for(Vec3[] face : ((AdvancedAABB)aabb).drawOverride)
	//			{
	//				ClientUtils.tes().startDrawing(GL11.GL_LINE_LOOP);
	//				for(Vec3 v : face)
	//					ClientUtils.tes().addVertex(v.xCoord+(v.xCoord<midX?-expand:expand),v.yCoord+(v.yCoord<midY?-expand:expand),v.zCoord+(v.zCoord<midZ?-expand:expand));
	//				ClientUtils.tes().draw();
	//			}
	//			ClientUtils.tes().addTranslation((float)-offsetX, (float)-offsetY, (float)-offsetZ);
	//		}
	//		else
	//			RenderGlobal.drawOutlinedBoundingBox(aabb.getOffsetBoundingBox(offsetX, offsetY, offsetZ).expand((double)expand, (double)expand, (double)expand), -1);
	//	}

	@SubscribeEvent()
	public void onClientDeath(LivingDeathEvent event)
	{
	}
	@SubscribeEvent()
	public void onRenderLivingPre(RenderLivingEvent.Pre event)
	{
		if(event.getEntity().getEntityData().func_74764_b("headshot"))
		{
			ModelBase model = event.getRenderer().field_77045_g;
			if(model instanceof ModelBiped)
				((ModelBiped)model).field_78116_c.field_78806_j=false;
			else if(model instanceof ModelVillager)
				((ModelVillager)model).field_78191_a.field_78806_j=false;
		}
	}
	@SubscribeEvent()
	public void onRenderLivingPost(RenderLivingEvent.Post event)
	{
		if(event.getEntity().getEntityData().func_74764_b("headshot"))
		{
			ModelBase model = event.getRenderer().field_77045_g;
			if(model instanceof ModelBiped)
				((ModelBiped)model).field_78116_c.field_78806_j=true;
			else if(model instanceof ModelVillager)
				((ModelVillager)model).field_78191_a.field_78806_j=true;
		}
	}

	@SubscribeEvent
	public void onLoginClient(EntityJoinWorldEvent ev)
	{
		Entity e = ev.getEntity();
		if (e==Minecraft.func_71410_x().field_71439_g&&ev.getWorld().field_72995_K)
		{
			String javaV = System.getProperty("java.version");
			if (javaV.equals("1.8.0_25"))
				e.func_145747_a(new TextComponentTranslation(Lib.CHAT_INFO+"old_java", javaV));
		}
	}
}
