/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.api.energy.wires;


import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler.Connection;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFutureTask;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.*;
import java.util.function.Consumer;

import static blusunrize.immersiveengineering.api.energy.wires.WireApi.canMix;
import static blusunrize.immersiveengineering.api.energy.wires.WireType.*;

public abstract class TileEntityImmersiveConnectable extends TileEntityIEBase implements IImmersiveConnectable
{
	protected WireType limitType = null;

	protected boolean canTakeLV()
	{
		return false;
	}
	protected boolean canTakeMV()
	{
		return false;
	}
	protected boolean canTakeHV()
	{
		return false;
	}
	protected boolean isRelay()
	{
		return false;
	}

	@Override
	public void onEnergyPassthrough(int amount)
	{
	}
	@Override
	public boolean allowEnergyToPass(Connection con)
	{
		return true;
	}

	@Override
	public boolean canConnect()
	{
		return true;
	}
	@Override
	public boolean isEnergyOutput()
	{
		return false;
	}
	@Override
	public int outputEnergy(int amount, boolean simulate, int energyType)
	{
		return 0;
	}
	@Override
	public BlockPos getConnectionMaster(WireType cableType, TargetingInfo target)
	{
		return func_174877_v();
	}	
	@Override
	public boolean canConnectCable(WireType cableType, TargetingInfo target, Vec3i offset)
	{
		String category = cableType.getCategory();
		boolean foundAccepting = (HV_CATEGORY.equals(category)&&canTakeHV())
				||(MV_CATEGORY.equals(category)&&canTakeMV())
				||(LV_CATEGORY.equals(category)&&canTakeLV());
		if (!foundAccepting)
			return false;
		return limitType==null||(this.isRelay() && canMix(limitType, cableType));
	}
	@Override
	public void connectCable(WireType cableType, TargetingInfo target, IImmersiveConnectable other)
	{
		this.limitType = cableType;
	}
	@Override
	public WireType getCableLimiter(TargetingInfo target)
	{
		return this.limitType;
	}
	@Override
	public void removeCable(Connection connection)
	{
		WireType type = connection != null ? connection.cableType : null;
		Set<Connection> outputs = ImmersiveNetHandler.INSTANCE.getConnections(field_145850_b, Utils.toCC(this));
		if(outputs == null || outputs.size() == 0)
		{
			if(type == limitType || type == null)
				this.limitType = null;
		}
		this.func_70296_d();
		if(field_145850_b != null)
		{
			IBlockState state = field_145850_b.func_180495_p(field_174879_c);
			field_145850_b.func_184138_a(field_174879_c, state,state, 3);
		}
	}

	private List<Pair<Float, Consumer<Float>>> sources = new ArrayList<>();
	private long lastSourceUpdate = 0;
	@Override
	public void addAvailableEnergy(float amount, Consumer<Float> consume)
	{
		long currentTime = field_145850_b.func_82737_E();
		if (lastSourceUpdate!=currentTime)
		{
			sources.clear();
			Pair<Float, Consumer<Float>> own = getOwnEnergy();
			if (own!=null)
				sources.add(own);
			lastSourceUpdate = currentTime;
		}
		if (amount>0&&consume!=null)
			sources.add(new ImmutablePair<>(amount, consume));
	}

	@Nullable
	protected Pair<Float, Consumer<Float>> getOwnEnergy()
	{
		return null;
	}

	@Override
	public float getDamageAmount(Entity e, Connection c)
	{
		float baseDmg = getBaseDamage(c);
		float max = getMaxDamage(c);
		if (baseDmg==0||field_145850_b.func_82737_E()-lastSourceUpdate>1)
			return 0;
		float damage = 0;
		for (int i = 0;i<sources.size()&&damage<max;i++)
		{
			int consume = (int) Math.min(sources.get(i).getLeft(), (max-damage)/baseDmg);
			damage += baseDmg*consume;
		}
		return damage;
	}

	@Override
	public void processDamage(Entity e, float amount, Connection c)
	{
		float baseDmg = getBaseDamage(c);
		float damage = 0;
		for (int i = 0;i<sources.size()&&damage<amount;i++)
		{
			float consume = Math.min(sources.get(i).getLeft(), (amount-damage)/baseDmg);
			sources.get(i).getRight().accept(consume);
			damage += baseDmg*consume;
			if (consume==sources.get(i).getLeft())
			{
				sources.remove(i);
				i--;
			}
		}
	}

	protected float getBaseDamage(Connection c)
	{
		if (c.cableType==COPPER)
			return 8*2F/c.cableType.getTransferRate();
		else if (c.cableType==ELECTRUM)
			return 8*5F/c.cableType.getTransferRate();
		else if (c.cableType==STEEL)
			return 8*15F/c.cableType.getTransferRate();
		return 0;
	}

	protected float getMaxDamage(Connection c)
	{
		return c.cableType.getTransferRate()/8*getBaseDamage(c);
	}

	@Override
	public SPacketUpdateTileEntity func_189518_D_()
	{
		NBTTagCompound nbttagcompound = new NBTTagCompound();
		this.func_189515_b(nbttagcompound);
		writeConnsToNBT(nbttagcompound);
		return new SPacketUpdateTileEntity(this.field_174879_c, 3, nbttagcompound);
	}
	@Override
	public void onDataPacket(@Nonnull NetworkManager net, @Nonnull SPacketUpdateTileEntity pkt)
	{
		NBTTagCompound nbt = pkt.func_148857_g();
		this.func_145839_a(nbt);
		loadConnsFromNBT(nbt);
	}

	@Override
	public boolean func_145842_c(int id, int arg)
	{
		if(id==-1||id==255)
		{
			IBlockState state = field_145850_b.func_180495_p(field_174879_c);
			field_145850_b.func_184138_a(field_174879_c, state,state, 3);
			return true;
		} else if(id == 254)
		{
			IBlockState state = field_145850_b.func_180495_p(field_174879_c);
			if(state instanceof IExtendedBlockState)
			{
				state = state.func_185899_b(field_145850_b, func_174877_v());
				state = state.func_177230_c().getExtendedState(state, field_145850_b, func_174877_v());
				ImmersiveEngineering.proxy.removeStateFromSmartModelCache((IExtendedBlockState) state);
				ImmersiveEngineering.proxy.removeStateFromConnectionModelCache((IExtendedBlockState) state);
			}
			field_145850_b.func_184138_a(field_174879_c, state, state, 3);
			return true;
		}
		return super.func_145842_c(id, arg);
	}

	@Override
	public void readCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket)
	{
		try{
			if(nbt.func_74764_b("limitType"))
				limitType = ApiUtils.getWireTypeFromNBT(nbt, "limitType");
			else
				limitType = null;
			if (nbt.func_74764_b("connectionList"))
				loadConnsFromNBT(nbt);
		}catch(Exception e)
		{
			IELogger.error("TileEntityImmersiveConenctable encountered MASSIVE error reading NBT. You should probably report this.");
		}
	}
	@Override
	public void writeCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket)
	{
		try{
			if(limitType!=null)
				nbt.func_74778_a("limitType", limitType.getUniqueName());
			if (descPacket)
				writeConnsToNBT(nbt);

			//			if(this.world!=null)
			//			{
			//				nbt.setIntArray("prevPos", new int[]{this.world.provider.dimensionId,xCoord,yCoord,zCoord});
			//			}
		}catch(Exception e)
		{
			IELogger.error("TileEntityImmersiveConenctable encountered MASSIVE error writing NBT. You should probably report this.");
		}
	}
	private void loadConnsFromNBT(NBTTagCompound nbt)
	{
		if(field_145850_b!=null && field_145850_b.field_72995_K && !Minecraft.func_71410_x().func_71356_B() && nbt!=null)
		{
			NBTTagList connectionList = nbt.func_150295_c("connectionList", 10);
			ImmersiveNetHandler.INSTANCE.clearConnectionsOriginatingFrom(Utils.toCC(this), field_145850_b);
			for(int i=0; i<connectionList.func_74745_c(); i++)
			{
				NBTTagCompound conTag = connectionList.func_150305_b(i);
				Connection con = Connection.readFromNBT(conTag);
				if(con!=null)
				{
					ImmersiveNetHandler.INSTANCE.addConnection(field_145850_b, Utils.toCC(this), con);
				}
				else
					IELogger.error("CLIENT read connection as null");
			}
		}
	}
	private void writeConnsToNBT(NBTTagCompound nbt)
	{
		if(field_145850_b!=null && !field_145850_b.field_72995_K && nbt!=null)
		{
			NBTTagList connectionList = new NBTTagList();
			Set<Connection> conL = ImmersiveNetHandler.INSTANCE.getConnections(field_145850_b, Utils.toCC(this));
			if(conL!=null)
				for(Connection con : conL)
					connectionList.func_74742_a(con.writeToNBT());
			nbt.func_74782_a("connectionList", connectionList);
		}
	}

	public Set<Connection> genConnBlockstate()
	{
		Set<Connection> conns = ImmersiveNetHandler.INSTANCE.getConnections(field_145850_b, field_174879_c);
		if (conns == null)
			return ImmutableSet.of();
		Set<Connection> ret = new HashSet<Connection>()
		{
			@Override
			public boolean equals(Object o)
			{
				if (o == this)
					return true;
				if (!(o instanceof HashSet))
					return false;
				HashSet<Connection> other = (HashSet<Connection>) o;
				if (other.size() != this.size())
					return false;
				for (Connection c : this)
					if (!other.contains(c))
						return false;
				return true;
			}
		};
		for (Connection c : conns)
		{
			IImmersiveConnectable end = ApiUtils.toIIC(c.end, field_145850_b, false);
			if (end==null)
				continue;
			// generate subvertices
			c.getSubVertices(field_145850_b);
			ret.add(c);
		}

		return ret;
	}
	@Override
	public void onChunkUnload()
	{
		super.onChunkUnload();
		ImmersiveNetHandler.INSTANCE.addProxy(new IICProxy(this));
	}
	@Override
	public void func_145829_t()
	{
		super.func_145829_t();
		if (!field_145850_b.field_72995_K)
			synchronized (field_145850_b.func_73046_m().field_175589_i)
			{
					field_145850_b.func_73046_m().field_175589_i.add(ListenableFutureTask.create(
							()->ImmersiveNetHandler.INSTANCE.onTEValidated(this), null));
			}
	}
	@Override
	public void func_145843_s()
	{
		super.func_145843_s();
		//if (world.isRemote)
		//	ImmersiveNetHandler.INSTANCE.clearConnectionsOriginatingFrom(pos, world);
	}
}
