/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.api;

import blusunrize.immersiveengineering.api.MultiblockHandler.IMultiblock;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualPages;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.gui.GuiButtonManualNavigation;
import blusunrize.lib.manual.gui.GuiManual;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.*;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import org.lwjgl.opengl.GL11;

import javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ManualPageMultiblock extends ManualPages
{
	IMultiblock multiblock;

	boolean canTick = true;
	boolean showCompleted = false;
	int tick = 0;

	float scale = 50f;
	float transX = 0;
	float transY = 0;
	float rotX=0;
	float rotY=0;
	List<String> componentTooltip;
	MultiblockRenderInfo renderInfo;
	MultiblockBlockAccess blockAccess;

	public ManualPageMultiblock(ManualInstance manual, String text, IMultiblock multiblock)
	{
		super(manual, text);
		this.multiblock = multiblock;

		if(multiblock.getStructureManual()!=null)
		{
//			scale = size[0] > size[1] ? width / size[0] - 10F : height / size[1] - 10F;
//			if(scale * size[0] > width) {
//				scale = width / size[0] - 10F;
//			}
//
//			xTranslate = x + width / 2;// - (size[0] * scale) / 2;
//			yTranslate = y + height / 2;// - (size[1] * scale) / 2;
//
//			w = size[0] * scale;
//			h = size[1] * scale;
		}
	}


	@Override
	public void initPage(GuiManual gui, int x, int y, List<GuiButton> pageButtons)
	{
		int yOff = 0;
		if(multiblock.getStructureManual()!=null)
		{
			this.renderInfo = new MultiblockRenderInfo(multiblock);
			this.blockAccess = new MultiblockBlockAccess(renderInfo);
			transX = x+60 + renderInfo.structureWidth/2;
			transY = y+35 + (float)Math.sqrt(renderInfo.structureHeight*renderInfo.structureHeight + renderInfo.structureWidth*renderInfo.structureWidth + renderInfo.structureLength*renderInfo.structureLength)/2;
			rotX=25;
			rotY=-45;
			scale = multiblock.getManualScale();
			boolean canRenderFormed = multiblock.canRenderFormedStructure();

			yOff = (int)(transY+scale*Math.sqrt(renderInfo.structureHeight*renderInfo.structureHeight + renderInfo.structureWidth*renderInfo.structureWidth + renderInfo.structureLength*renderInfo.structureLength)/2);
			pageButtons.add(new GuiButtonManualNavigation(gui, 100, x+4, (int)transY-(canRenderFormed?11:5), 10,10, 4));
			if(canRenderFormed)
				pageButtons.add(new GuiButtonManualNavigation(gui, 103, x+4, (int)transY+1, 10,10, 6));
			if(this.renderInfo.structureHeight>1)
			{
				pageButtons.add(new GuiButtonManualNavigation(gui, 101, x+4, (int)transY-(canRenderFormed?14:8)-16, 10,16, 3));
				pageButtons.add(new GuiButtonManualNavigation(gui, 102, x+4, (int)transY+(canRenderFormed?14:8), 10,16, 2));
			}
		}

		IngredientStack[] totalMaterials = this.multiblock.getTotalMaterials();
		if(totalMaterials != null)
		{
			componentTooltip = new ArrayList();
			componentTooltip.add(I18n.func_135052_a("desc.immersiveengineering.info.reqMaterial"));
			int maxOff = 1;
			boolean hasAnyItems = false;
			boolean[] hasItems = new boolean[totalMaterials.length];
			for(int ss = 0; ss < totalMaterials.length; ss++)
				if(totalMaterials[ss] != null)
				{
					IngredientStack req = totalMaterials[ss];
					int reqSize = req.inputSize;
					for(int slot = 0; slot < ManualUtils.mc().field_71439_g.field_71071_by.func_70302_i_(); slot++)
					{
						ItemStack inSlot = ManualUtils.mc().field_71439_g.field_71071_by.func_70301_a(slot);
						if(!inSlot.func_190926_b() && req.matchesItemStackIgnoringSize(inSlot))
							if((reqSize -= inSlot.func_190916_E()) <= 0)
								break;
					}
					if(reqSize <= 0)
					{
						hasItems[ss] = true;
						if(!hasAnyItems)
							hasAnyItems = true;
					}
					maxOff = Math.max(maxOff, ("" + req.inputSize).length());
				}
			for(int ss = 0; ss < totalMaterials.length; ss++)
				if(totalMaterials[ss] != null)
				{
					IngredientStack req = totalMaterials[ss];
					int indent = maxOff - ("" + req.inputSize).length();
					String sIndent = "";
					if(indent > 0)
						for(int ii = 0; ii < indent; ii++)
							sIndent += "0";
					String s = hasItems[ss] ? (TextFormatting.GREEN + TextFormatting.BOLD.toString() + "\u2713" + TextFormatting.RESET + " ") : hasAnyItems ? ("   ") : "";
					s += TextFormatting.GRAY + sIndent + req.inputSize + "x " + TextFormatting.RESET;
					ItemStack example = req.getExampleStack();
					if(!example.func_190926_b())
						s += example.func_77953_t().field_77937_e + example.func_82833_r();
					else
						s += "???";
					componentTooltip.add(s);
				}
		}
		super.initPage(gui, x, yOff, pageButtons);
	}

	@Override
	public void renderPage(GuiManual gui, int x, int y, int mx, int my)
	{
		boolean openBuffer = false;
		try
		{
			if(multiblock.getStructureManual() != null)
			{
				if(!canTick)
				{
//					renderInfo.reset();
//				renderInfo.setShowLayer(9);
					//LAYER CACHING!!
				} else if(++tick % 20 == 0)
					renderInfo.step();

				int structureLength = renderInfo.structureLength;
				int structureWidth = renderInfo.structureWidth;
				int structureHeight = renderInfo.structureHeight;

				int yOffTotal = (int)(transY-y+scale*Math.sqrt(renderInfo.structureHeight*renderInfo.structureHeight + renderInfo.structureWidth*renderInfo.structureWidth + renderInfo.structureLength*renderInfo.structureLength)/2);

				GlStateManager.func_179091_B();
				GlStateManager.func_179094_E();
				RenderHelper.func_74518_a();
				//			GL11.glEnable(GL11.GL_DEPTH_TEST);
				//			GL11.glDepthFunc(GL11.GL_ALWAYS);
				//			GL11.glDisable(GL11.GL_CULL_FACE);
				int i = 0;
				ItemStack highlighted = ItemStack.field_190927_a;

				final BlockRendererDispatcher blockRender = Minecraft.func_71410_x().func_175602_ab();

				float f = (float)Math.sqrt(structureHeight * structureHeight + structureWidth * structureWidth + structureLength * structureLength);

				GlStateManager.func_179109_b(transX, transY, Math.max(structureHeight, Math.max(structureWidth, structureLength)));
				GlStateManager.func_179152_a(scale, -scale, 1);
				GlStateManager.func_179114_b(rotX, 1, 0, 0);
				GlStateManager.func_179114_b(90+rotY, 0, 1, 0);

				GlStateManager.func_179109_b((float)structureLength / -2f, (float)structureHeight / -2f, (float)structureWidth / -2f);

				GlStateManager.func_179140_f();

				if(Minecraft.func_71379_u())
					GlStateManager.func_179103_j(GL11.GL_SMOOTH);
				else
					GlStateManager.func_179103_j(GL11.GL_FLAT);

				gui.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
				int idx = 0;
				if(showCompleted && multiblock.canRenderFormedStructure())
					multiblock.renderFormedStructure();
				else
					for(int h = 0; h < structureHeight; h++)
						for(int l = 0; l < structureLength; l++)
							for(int w = 0; w < structureWidth; w++)
							{
								BlockPos pos = new BlockPos(l, h, w);
								if(!blockAccess.func_175623_d(pos))
								{
									GlStateManager.func_179109_b(l, h, w);
									boolean b = multiblock.overwriteBlockRender(renderInfo.data[h][l][w], idx++);
									GlStateManager.func_179109_b(-l, -h, -w);
									if(!b)
									{
										IBlockState state = blockAccess.func_180495_p(pos);
										Tessellator tessellator = Tessellator.func_178181_a();
										BufferBuilder buffer = tessellator.func_178180_c();
										buffer.func_181668_a(GL11.GL_QUADS, DefaultVertexFormats.field_176600_a);
										openBuffer = true;
										blockRender.func_175018_a(state, pos, blockAccess, buffer);
										tessellator.func_78381_a();
										openBuffer = false;
									}
								}
							}

				GlStateManager.func_179121_F();

				RenderHelper.func_74518_a();
				GlStateManager.func_179101_C();

				GlStateManager.func_179147_l();
				RenderHelper.func_74518_a();

				manual.fontRenderer.func_78264_a(true);
				if(localizedText != null && !localizedText.isEmpty())
					manual.fontRenderer.func_78279_b(localizedText, x, y + yOffTotal, 120, manual.getTextColour());

				manual.fontRenderer.func_78264_a(false);
				if(componentTooltip != null)
				{
					manual.fontRenderer.func_175065_a("?", x + 116, y + yOffTotal / 2 - 4, manual.getTextColour(), false);
					if(mx >= x + 116 && mx < x + 122 && my >= y + yOffTotal / 2 - 4 && my < y + yOffTotal / 2 + 4)
						gui.drawHoveringText(componentTooltip, mx, my, manual.fontRenderer);
				}
			}

		}catch(Exception e)
		{
			e.printStackTrace();
		}
		if(openBuffer)
			try{
				Tessellator.func_178181_a().func_78381_a();
			}catch(Exception e){}
	}

	@Override
	public void mouseDragged(int x, int y, int clickX, int clickY, int mx, int my, int lastX, int lastY, int button)
	{
		if((clickX>=40 && clickX<144 && mx>=20 && mx<164)&&(clickY>=30 && clickY<130 && my>=30 && my<180))
		{
			int dx = mx-lastX;
			int dy = my-lastY;
			rotY = rotY+(dx/104f)*80;
			rotX = rotX+(dy/100f)*80;
		}
	}

	@Override
	public void buttonPressed(GuiManual gui, GuiButton button)
	{
		if(button.field_146127_k==100)
		{
			canTick = !canTick;
			((GuiButtonManualNavigation)button).type = ((GuiButtonManualNavigation)button).type == 4 ? 5 : 4;
		}
		else if(button.field_146127_k==101)
		{
			this.renderInfo.setShowLayer( Math.min(renderInfo.showLayer+1, renderInfo.structureHeight-1));
		}
		else if(button.field_146127_k==102)
		{
			this.renderInfo.setShowLayer( Math.max(renderInfo.showLayer-1, -1));
		}
		else if(button.field_146127_k==103)
			showCompleted = !showCompleted;
		super.buttonPressed(gui, button);
	}

	@Override
	public boolean listForSearch(String searchTag)
	{
		return false;
	}

	static class MultiblockBlockAccess implements IBlockAccess
	{
		private final MultiblockRenderInfo data;
		private final IBlockState[][][] structure;

		public MultiblockBlockAccess(MultiblockRenderInfo data)
		{
			this.data = data;
			final int[] index = {0};//Nasty workaround, but IDEA suggested it =P
			this.structure = Arrays.stream(data.data).map(layer -> {
				return Arrays.stream(layer).map(row -> {
					return Arrays.stream(row).map(itemstack -> {
						return convert(index[0]++, itemstack);
					}).collect(Collectors.toList()).toArray(new IBlockState[0]);
				}).collect(Collectors.toList()).toArray(new IBlockState[0][]);
			}).collect(Collectors.toList()).toArray(new IBlockState[0][][]);
		}

		private IBlockState convert(int index, ItemStack itemstack)
		{
			if (itemstack == null)
				return Blocks.field_150350_a.func_176223_P();
			IBlockState state = data.multiblock.getBlockstateFromStack(index, itemstack);
			if(state!=null)
				return state;
			return Blocks.field_150350_a.func_176223_P();
		}

		@Nullable
		@Override
		public TileEntity func_175625_s(BlockPos pos)
		{
			return null;
		}

		@Override
		public int func_175626_b(BlockPos pos, int lightValue)
		{
			// full brightness always
			return 15 << 20 | 15 << 4;
		}

		@Override
		public IBlockState func_180495_p(BlockPos pos)
		{
			int x = pos.func_177958_n();
			int y = pos.func_177956_o();
			int z = pos.func_177952_p();

			if(y >= 0 && y < structure.length)
				if(x >= 0 && x < structure[y].length)
					if(z >= 0 && z < structure[y][x].length)
					{
						int index = y * (data.structureLength * data.structureWidth) + x * data.structureWidth + z;
						if(index <= data.getLimiter())
							return structure[y][x][z];
					}
			return Blocks.field_150350_a.func_176223_P();
		}

		@Override
		public boolean func_175623_d(BlockPos pos)
		{
			return func_180495_p(pos).func_177230_c() == Blocks.field_150350_a;
		}

		@Override
		public Biome func_180494_b(BlockPos pos)
		{
			return null;
		}

		@Override
		public int func_175627_a(BlockPos pos, EnumFacing direction)
		{
			return 0;
		}

		@Override
		public WorldType func_175624_G()
		{
			return null;
		}

		@Override
		public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default)
		{
			return false;
		}
	}
	//Stolen back from boni's StructureInfo
	static class MultiblockRenderInfo
	{
		public IMultiblock multiblock;
		public ItemStack[][][] data;
		public int blockCount = 0;
		public int[] countPerLevel;
		public int structureHeight = 0;
		public int structureLength = 0;
		public int structureWidth = 0;
		public int showLayer = -1;

		private int blockIndex = -1;
		private int maxBlockIndex;

		public MultiblockRenderInfo(IMultiblock multiblock)
		{
			this.multiblock = multiblock;
			init(multiblock.getStructureManual());
			maxBlockIndex = blockIndex = structureHeight * structureLength * structureWidth;
		}

		public void init(ItemStack[][][] structure)
		{
			data = structure;
			structureHeight = structure.length;
			structureWidth = 0;
			structureLength = 0;

			countPerLevel = new int[structureHeight];
			blockCount = 0;
			for(int h = 0; h < structure.length; h++)
			{
				if(structure[h].length > structureLength)
					structureLength = structure[h].length;
				int perLvl = 0;
				for(int l = 0; l < structure[h].length; l++)
				{
					if(structure[h][l].length > structureWidth)
						structureWidth = structure[h][l].length;
					for(ItemStack ss : structure[h][l])
						if(ss != null && !ss.func_190926_b())
							perLvl++;
				}
				countPerLevel[h] = perLvl;
				blockCount += perLvl;
			}
		}

		public void setShowLayer(int layer)
		{
			showLayer = layer;
			if(layer<0)
				reset();
			else
				blockIndex = (layer + 1) * (structureLength * structureWidth) - 1;
		}

		public void reset()
		{
			blockIndex = maxBlockIndex;
		}

		public void step()
		{
			int start = blockIndex;
			do
			{
				if(++blockIndex >= maxBlockIndex)
					blockIndex = 0;
			}
			while(isEmpty(blockIndex) && blockIndex != start);
		}

		private boolean isEmpty(int index)
		{
			int y = index / (structureLength * structureWidth);
			int r = index % (structureLength * structureWidth);
			int x = r / structureWidth;
			int z = r % structureWidth;

			ItemStack stack = data[y][x][z];
			return stack == null || stack.func_190926_b();
		}

		public int getLimiter()
		{
			return blockIndex;
		}
	}
}
