/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.api;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;

public class DimensionChunkCoords extends ChunkPos
{
	public int dimension;
	public DimensionChunkCoords(int dimension, int x, int z)
	{
		super(x,z);
		this.dimension=dimension;
	}

	@Override
    public boolean equals(Object o)
    {
        if (this == o)
            return true;
        else if (!(o instanceof DimensionChunkCoords))
            return false;
        else
        {
        	DimensionChunkCoords coordPair = (DimensionChunkCoords)o;
            return this.dimension==coordPair.dimension && this.field_77276_a==coordPair.field_77276_a && this.field_77275_b==coordPair.field_77275_b;
        }
    }
	@Override
    public String toString()
    {
        return "[dim:"+ this.dimension+ "; " +this.field_77276_a+ ", " +this.field_77275_b + "]";
    }

	public NBTTagCompound writeToNBT()
	{
		NBTTagCompound tag = new NBTTagCompound();
		tag.func_74768_a("dim", dimension);
		tag.func_74768_a("x", this.field_77276_a);
		tag.func_74768_a("z", this.field_77275_b);
		return tag;
	}
	public static DimensionChunkCoords readFromNBT(NBTTagCompound tag)
	{
		if(tag.func_150297_b("dim",3)&&tag.func_150297_b("x",3)&&tag.func_150297_b("z",3))
			return new DimensionChunkCoords(tag.func_74762_e("dim"),tag.func_74762_e("x"),tag.func_74762_e("z"));
		return null;
	}
}
