/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.api;

import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DimensionBlockPos extends BlockPos
{
	public int dimension;
	public DimensionBlockPos(int x, int y, int z, int dim)
	{
		super(x, y, z);
		dimension = dim;
	}
	public DimensionBlockPos(int x, int y, int z, World w)
	{
		this(x, y, z, w.field_73011_w.getDimension());
	}
	public DimensionBlockPos(BlockPos pos, World w)
	{
		this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), w.field_73011_w.getDimension());
	}
	public DimensionBlockPos(BlockPos pos, int dim)
	{
		this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), dim);
	}

	@Override
	public int hashCode()
	{
		final int prime = 31;
		int result = 1;
		result = prime * result + dimension;
		result = prime * result + func_177958_n();
		result = prime * result + func_177956_o();
		result = prime * result + func_177952_p();
		return result;
	}
	@Override
	public boolean equals(Object obj)
	{
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		DimensionBlockPos other = (DimensionBlockPos) obj;
		if (dimension != other.dimension)
			return false;
		if (func_177958_n() != other.func_177958_n())
			return false;
		if (func_177956_o() != other.func_177956_o())
			return false;
		return func_177952_p() == other.func_177952_p();
	}
	@Override
	public String toString() {
		return "Dimension: "+dimension+" Pos: "+super.toString();
	}
}
