/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.api;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class ComparableItemStack
{
	public ItemStack stack;
	public boolean useNBT;
	public int oreID=-1;

	public ComparableItemStack(ItemStack stack)
	{
		this(stack, true);
	}
	public ComparableItemStack(ItemStack stack, boolean matchOre)
	{
		this(stack, matchOre, true);
	}
	public ComparableItemStack(ItemStack stack, boolean matchOre, boolean copy)
	{
		if(stack==null)
			throw new RuntimeException("You cannot instantiate a ComparableItemStack with null for an Item!");
		this.stack = stack;
		if (copy)
			copy();
		if(matchOre)
		{
			int[] oids = OreDictionary.getOreIDs(stack);
			if(oids!=null&&oids.length > 0)
				this.oreID = oids[0];
		}
	}

	public void copy()
	{
		stack = stack.func_77946_l();
	}

	public ComparableItemStack(String oreName)
	{
		this(IEApi.getPreferredOreStack(oreName));
		this.oreID = OreDictionary.getOreID(oreName);
	}

	public ComparableItemStack setUseNBT(boolean useNBT)
	{
		this.useNBT = useNBT;
		return this;
	}
	public ComparableItemStack setOreID(int oid)
	{
		this.oreID = oid;
		return this;
	}

	@Override
	public String toString()
	{
		return "ComparableStack: {"+this.stack.toString()+"}; oreID: "+this.oreID+"; checkNBT: "+this.useNBT;
	}
	@Override
	public int hashCode()
	{
		if(this.oreID!=-1)
			return this.oreID;
		int hash = (stack.func_77952_i()&0xffff)*31 + stack.func_77973_b().hashCode()*31;
		if(this.useNBT && stack.func_77942_o())
			hash += stack.func_77978_p().hashCode()*31;
		return hash;
	}

	@Override
	public boolean equals(Object object)
	{
		if(!(object instanceof ComparableItemStack))
			return false;

		if(this.oreID!=-1 && ((ComparableItemStack)object).oreID!=-1)
			return this.oreID == ((ComparableItemStack)object).oreID;

		ItemStack otherStack = ((ComparableItemStack)object).stack;
		if(!OreDictionary.itemMatches(stack,otherStack, false))
			return false;
		if(this.useNBT)
			return ItemStack.func_77970_a(stack, otherStack);
		return true;
	}


	public NBTTagCompound writeToNBT(NBTTagCompound nbt)
	{
		if(this.oreID!=-1)
			nbt.func_74778_a("oreID", OreDictionary.getOreName(oreID));
		else
		{
			nbt.func_74782_a("stack", stack.func_77955_b(new NBTTagCompound()));
			nbt.func_74757_a("useNBT", useNBT);
		}
		return nbt;
	}
	public static ComparableItemStack readFromNBT(NBTTagCompound nbt)
	{
		if(nbt.func_74764_b("oreID"))
			return new ComparableItemStack(nbt.func_74779_i("oreID"));
		else if(nbt.func_74764_b("stack"))
		{
			ComparableItemStack comp = new ComparableItemStack(new ItemStack(nbt.func_74775_l("stack")));
			comp.useNBT = nbt.func_74767_n("useNBT");
			return comp;
		}
		return null;
	}
}
