/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual.gui;

import blusunrize.lib.manual.gui.GuiManual;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.input.Mouse;

public class GuiClickableList
extends GuiButton {
    String[] entries;
    float textScale;
    int offset;
    int maxOffset;
    int perPage;
    int translationType;
    GuiManual gui;
    private long prevWheelNano = 0L;
    public int selectedOption = -1;

    public GuiClickableList(GuiManual gui, int id, int x, int y, int w, int h, float textScale, int translationType, String ... entries) {
        super(id, x, y, w, h, "");
        this.gui = gui;
        this.textScale = textScale;
        this.entries = entries;
        this.translationType = translationType;
        this.perPage = (h - 8) / this.getFontHeight();
        if (this.perPage < entries.length) {
            this.maxOffset = entries.length - this.perPage;
        }
    }

    int getFontHeight() {
        return (int)((float)this.gui.manual.fontRenderer.FONT_HEIGHT * this.textScale);
    }

    public void drawButton(Minecraft mc, int mx, int my, float partialTicks) {
        FontRenderer fr = this.gui.manual.fontRenderer;
        boolean uni = fr.getUnicodeFlag();
        fr.setUnicodeFlag(true);
        int mmY = my - this.y;
        GlStateManager.pushMatrix();
        GlStateManager.scale((float)this.textScale, (float)this.textScale, (float)this.textScale);
        GlStateManager.translate((float)((float)this.x / this.textScale), (float)((float)this.y / this.textScale), (float)0.0f);
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f);
        this.hovered = mx >= this.x && mx < this.x + this.width && my >= this.y && my < this.y + this.height;
        for (int i = 0; i < Math.min(this.perPage, this.entries.length); ++i) {
            int j;
            int col = this.gui.manual.getTextColour();
            if (this.hovered && mmY >= i * this.getFontHeight() && mmY < (i + 1) * this.getFontHeight()) {
                col = this.gui.manual.getHighlightColour();
            }
            if (i != 0) {
                GlStateManager.translate((float)0.0f, (float)this.getFontHeight(), (float)0.0f);
            }
            if ((j = this.offset + i) > this.entries.length - 1) {
                j = this.entries.length - 1;
            }
            String s = this.translationType == -1 ? this.entries[j] : (this.translationType == 0 ? this.gui.manual.formatCategoryName(this.entries[j]) : this.gui.manual.formatEntryName(this.entries[j]));
            fr.drawString(s, 0.0f, 0.0f, col, false);
        }
        GlStateManager.scale((float)(1.0f / this.textScale), (float)(1.0f / this.textScale), (float)(1.0f / this.textScale));
        GlStateManager.popMatrix();
        if (this.maxOffset > 0) {
            int h1 = this.offset * this.getFontHeight();
            int h2 = this.height - 8 - this.maxOffset * this.getFontHeight();
            this.drawGradientRect(this.x + this.width, this.y + h1, this.x + this.width + 8, this.y + h1 + h2, 0xA000000, 0xA000000);
            this.drawGradientRect(this.x + this.width + 1, this.y + h1, this.x + this.width + 6, this.y + h1 + h2, 0x28000000, 0x28000000);
            if (this.offset > 0) {
                this.drawGradientRect(this.x + this.width, this.y, this.x + this.width + 8, this.y + h1, 0xA000000, 0xA000000);
            }
            if (this.offset < this.maxOffset) {
                int h3 = (this.maxOffset - this.offset) * this.getFontHeight();
                this.drawGradientRect(this.x + this.width, this.y + this.height - 8 - h3, this.x + this.width + 8, this.y + this.height - 8, 0xA000000, 0x11000000);
            }
        }
        fr.setUnicodeFlag(uni);
        int mouseWheel = Mouse.getEventDWheel();
        if (mouseWheel != 0 && this.maxOffset > 0 && Mouse.getEventNanoseconds() != this.prevWheelNano) {
            this.prevWheelNano = Mouse.getEventNanoseconds();
            if (mouseWheel < 0 && this.offset < this.maxOffset) {
                ++this.offset;
            }
            if (mouseWheel > 0 && this.offset > 0) {
                --this.offset;
            }
        }
    }

    public boolean mousePressed(Minecraft mc, int mx, int my) {
        boolean b = super.mousePressed(mc, mx, my);
        this.selectedOption = -1;
        if (b) {
            int mmY = my - this.y;
            for (int i = 0; i < Math.min(this.perPage, this.entries.length); ++i) {
                if (mmY < i * this.getFontHeight() || mmY >= (i + 1) * this.getFontHeight()) continue;
                this.selectedOption = this.offset + i;
            }
        }
        return this.selectedOption != -1;
    }
}

