/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual.gui;

import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.gui.GuiManual;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.TextFormatting;

public class GuiButtonManualLink
extends GuiButton {
    public String localized;
    public ManualInstance.ManualLink link;
    GuiManual gui;

    public GuiButtonManualLink(GuiManual gui, int id, int x, int y, int w, int h, ManualInstance.ManualLink link, String localized) {
        super(id, x, y, w, h, "");
        this.gui = gui;
        this.link = link;
        this.localized = localized;
        if (gui.manual.improveReadability()) {
            this.localized = TextFormatting.BOLD + localized;
        }
    }

    public boolean mousePressed(Minecraft mc, int mx, int my) {
        return super.mousePressed(mc, mx, my);
    }

    public void drawButton(Minecraft mc, int mx, int my, float partialTicks) {
        boolean bl = this.hovered = mx >= this.x && my >= this.y && mx < this.x + this.width && my < this.y + this.height;
        if (this.hovered) {
            FontRenderer font = mc.fontRenderer;
            boolean uni = font.getUnicodeFlag();
            font.setUnicodeFlag(true);
            font.drawString(this.localized, this.x, this.y, this.gui.manual.getHighlightColour());
            font.setUnicodeFlag(false);
            this.gui.drawHoveringText(Collections.singletonList(this.gui.manual.formatLink(this.link)), mx + 8, my + 4, font);
            font.setUnicodeFlag(uni);
            GlStateManager.enableBlend();
        }
    }
}

