/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class ManualUtils {
    static HashMap<String, ResourceLocation> resourceMap = new HashMap();

    public static boolean stackMatchesObject(ItemStack stack, Object o) {
        if (o instanceof String) {
            return ManualUtils.compareToOreName(stack, (String)o);
        }
        if (o instanceof ItemStack) {
            if (!OreDictionary.itemMatches((ItemStack)((ItemStack)o), (ItemStack)stack, (boolean)false)) {
                return false;
            }
            if (stack.getItemDamage() == Short.MAX_VALUE) {
                return true;
            }
            if (((ItemStack)o).hasTagCompound()) {
                return ((ItemStack)o).getTagCompound().equals((Object)stack.getTagCompound());
            }
            return true;
        }
        return false;
    }

    public static boolean compareToOreName(ItemStack stack, String oreName) {
        for (int oid : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (!OreDictionary.getOreName((int)oid).equals(oreName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isExistingOreName(String name) {
        if (!OreDictionary.doesOreNameExist((String)name)) {
            return false;
        }
        return !OreDictionary.getOres((String)name).isEmpty();
    }

    public static void drawTexturedRect(int x, int y, int w, int h, double ... uv) {
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder worldrenderer = tessellator.getBuffer();
        worldrenderer.begin(7, DefaultVertexFormats.POSITION_TEX);
        worldrenderer.pos((double)x, (double)(y + h), 0.0).tex(uv[0], uv[3]).endVertex();
        worldrenderer.pos((double)(x + w), (double)(y + h), 0.0).tex(uv[1], uv[3]).endVertex();
        worldrenderer.pos((double)(x + w), (double)y, 0.0).tex(uv[1], uv[2]).endVertex();
        worldrenderer.pos((double)x, (double)y, 0.0).tex(uv[0], uv[2]).endVertex();
        tessellator.draw();
    }

    public static ArrayList<String> getPrimitiveSpellingCorrections(String query, String[] valid, int maxDistance) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : valid) {
            if (s == null || s.trim().isEmpty() || ManualUtils.getSpellingDistanceBetweenStrings(query, s) >= maxDistance) continue;
            list.add(s);
        }
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String s0, String s1) {
                return ManualUtils.getSpellingDistanceBetweenStrings(s1, s0);
            }
        });
        return list;
    }

    public static int getSpellingDistanceBetweenStrings(String query, String target) {
        query = query.toLowerCase(Locale.ENGLISH);
        target = target.toLowerCase(Locale.ENGLISH);
        String[] queryWords = query.split(" ");
        String[] targetWords = target.split(" ");
        int distance = 0;
        for (int iWord = 0; iWord < queryWords.length; ++iWord) {
            if (iWord >= targetWords.length) {
                ++distance;
                continue;
            }
            int wordDistance = 0;
            for (int iChar = 0; iChar < queryWords[iWord].length(); ++iChar) {
                if (iChar >= targetWords[iWord].length()) {
                    ++distance;
                    continue;
                }
                if (queryWords[iWord].charAt(iChar) == targetWords[iWord].charAt(iChar)) continue;
                ++wordDistance;
                if (iChar <= 0 || queryWords[iWord].charAt(iChar - 1) != targetWords[iWord].charAt(iChar) || queryWords[iWord].charAt(iChar) != targetWords[iWord].charAt(iChar - 1)) continue;
                wordDistance -= 2;
            }
            if (wordDistance > 0) {
                wordDistance += targetWords[iWord].length() - queryWords[iWord].length();
            }
            distance += wordDistance;
        }
        return distance;
    }

    public static void drawSplitString(FontRenderer fontRenderer, String string, int x, int y, int width, int colour) {
        fontRenderer.resetStyles();
        fontRenderer.textColor = colour;
        List list = fontRenderer.listFormattedStringToWidth(string, width);
        FloatBuffer currentGLColor = BufferUtils.createFloatBuffer((int)16);
        int line = 0;
        for (String next : list) {
            if (line > 0) {
                int currentColour = fontRenderer.textColor;
                GL11.glGetFloat((int)2816, (FloatBuffer)currentGLColor);
                int glColourRGBA = ((int)(currentGLColor.get(0) * 255.0f) << 16) + ((int)(currentGLColor.get(1) * 255.0f) << 8) + (int)(currentGLColor.get(2) * 255.0f);
                if (glColourRGBA != currentColour) {
                    for (int j = 0; j < fontRenderer.colorCode.length; ++j) {
                        if (fontRenderer.colorCode[j] != glColourRGBA) continue;
                        String code = Integer.toHexString(j % 16);
                        next = '\u00a7' + code + next;
                        break;
                    }
                }
            }
            fontRenderer.drawString(next, (float)x, (float)y, colour, false);
            y += fontRenderer.FONT_HEIGHT;
        }
    }

    public static String attemptStringTranslation(String tranlationKey, String arg) {
        String translated;
        String untranslated = String.format(tranlationKey, arg);
        if (!untranslated.equals(translated = I18n.format((String)untranslated, (Object[])new Object[0]))) {
            return translated;
        }
        return arg;
    }

    public static Tessellator tes() {
        return Tessellator.getInstance();
    }

    public static Minecraft mc() {
        return Minecraft.getMinecraft();
    }

    public static void bindTexture(String path) {
        ManualUtils.mc().getTextureManager().bindTexture(ManualUtils.getResource(path));
    }

    public static ResourceLocation getResource(String path) {
        ResourceLocation rl;
        ResourceLocation resourceLocation = rl = resourceMap.containsKey(path) ? resourceMap.get(path) : new ResourceLocation(path);
        if (!resourceMap.containsKey(path)) {
            resourceMap.put(path, rl);
        }
        return rl;
    }

    public static RenderItem renderItem() {
        return ManualUtils.mc().getRenderItem();
    }
}

