/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.world;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWoodenCrate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class VillageEngineersHouse
extends StructureVillagePieces.Village {
    public static ResourceLocation woodenCrateLoot = new ResourceLocation("immersiveengineering", "chests/engineers_house");
    static List<BlockPos> framesHung = new ArrayList<BlockPos>();
    private int groundLevel = -1;

    public VillageEngineersHouse() {
    }

    public VillageEngineersHouse(StructureVillagePieces.Start villagePiece, int par2, Random par3Random, StructureBoundingBox par4StructureBoundingBox, EnumFacing facing) {
        super(villagePiece, par2);
        this.setCoordBaseMode(facing);
        this.boundingBox = par4StructureBoundingBox;
    }

    public boolean addComponentParts(World world, Random rand, StructureBoundingBox box) {
        if (this.groundLevel < 0) {
            this.groundLevel = this.getAverageGroundLevel(world, box);
            if (this.groundLevel < 0) {
                return true;
            }
            this.boundingBox.offset(0, this.groundLevel - this.boundingBox.maxY + 10 - 1, 0);
        }
        this.fillWithBlocks(world, box, 0, 0, 0, 10, 9, 8, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
        this.fillWithBlocks(world, box, 1, 0, 1, 9, 0, 8, Blocks.COBBLESTONE.getDefaultState(), Blocks.COBBLESTONE.getDefaultState(), false);
        this.fillWithBlocks(world, box, 6, 0, 1, 9, 0, 2, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
        this.setBlockState(world, Blocks.STONE_STAIRS.getDefaultState().withProperty((IProperty)BlockStairs.FACING, (Comparable)EnumFacing.NORTH), 4, 0, 0, box);
        this.fillWithBlocks(world, box, 1, 1, 3, 1, 4, 3, IEContent.blockTreatedWood.getDefaultState(), IEContent.blockTreatedWood.getDefaultState(), false);
        this.fillWithBlocks(world, box, 1, 1, 8, 1, 6, 8, IEContent.blockTreatedWood.getDefaultState(), IEContent.blockTreatedWood.getDefaultState(), false);
        this.fillWithBlocks(world, box, 9, 1, 3, 9, 6, 3, IEContent.blockTreatedWood.getDefaultState(), IEContent.blockTreatedWood.getDefaultState(), false);
        this.fillWithBlocks(world, box, 9, 1, 8, 9, 6, 8, IEContent.blockTreatedWood.getDefaultState(), IEContent.blockTreatedWood.getDefaultState(), false);
        this.fillWithBlocks(world, box, 1, 4, 3, 9, 4, 8, IEContent.blockTreatedWood.getDefaultState(), IEContent.blockTreatedWood.getDefaultState(), false);
        this.fillWithBlocks(world, box, 6, 5, 3, 6, 7, 3, IEContent.blockTreatedWood.getDefaultState(), IEContent.blockTreatedWood.getDefaultState(), false);
        this.fillWithBlocks(world, box, 1, 5, 5, 1, 6, 5, IEContent.blockTreatedWood.getDefaultState(), IEContent.blockTreatedWood.getDefaultState(), false);
        this.fillWithBlocks(world, box, 2, 4, 5, 8, 4, 7, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
        this.fillWithBlocks(world, box, 2, 0, 3, 5, 0, 4, Blocks.WOOL.getStateFromMeta(13), Blocks.WOOL.getStateFromMeta(13), false);
        this.fillWithBlocks(world, box, 2, 0, 4, 8, 0, 7, Blocks.WOOL.getStateFromMeta(13), Blocks.WOOL.getStateFromMeta(13), false);
        this.fillWithBlocks(world, box, 6, 4, 4, 8, 4, 4, Blocks.WOOL.getStateFromMeta(13), Blocks.WOOL.getStateFromMeta(13), false);
        this.fillWithBlocks(world, box, 2, 4, 5, 7, 4, 5, Blocks.WOOL.getStateFromMeta(13), Blocks.WOOL.getStateFromMeta(13), false);
        this.fillWithBlocks(world, box, 2, 4, 6, 6, 4, 6, Blocks.WOOL.getStateFromMeta(13), Blocks.WOOL.getStateFromMeta(13), false);
        this.fillWithBlocks(world, box, 2, 4, 7, 4, 4, 7, Blocks.WOOL.getStateFromMeta(13), Blocks.WOOL.getStateFromMeta(13), false);
        this.fillWithBlocks(world, box, 2, 1, 3, 8, 3, 3, Blocks.PLANKS.getDefaultState(), Blocks.PLANKS.getDefaultState(), false);
        this.fillWithBlocks(world, box, 7, 5, 3, 8, 6, 3, Blocks.PLANKS.getDefaultState(), Blocks.PLANKS.getDefaultState(), false);
        this.setBlockState(world, Blocks.PLANKS.getDefaultState(), 7, 7, 3, box);
        this.fillWithBlocks(world, box, 6, 5, 4, 6, 7, 4, Blocks.PLANKS.getDefaultState(), Blocks.PLANKS.getDefaultState(), false);
        this.fillWithBlocks(world, box, 2, 5, 5, 5, 6, 5, Blocks.PLANKS.getDefaultState(), Blocks.PLANKS.getDefaultState(), false);
        this.fillWithBlocks(world, box, 3, 7, 5, 5, 7, 5, Blocks.PLANKS.getDefaultState(), Blocks.PLANKS.getDefaultState(), false);
        this.setBlockState(world, Blocks.PLANKS.getDefaultState(), 5, 8, 5, box);
        this.fillWithBlocks(world, box, 2, 1, 8, 8, 3, 8, Blocks.PLANKS.getDefaultState(), Blocks.PLANKS.getDefaultState(), false);
        this.fillWithBlocks(world, box, 2, 5, 8, 8, 6, 8, Blocks.PLANKS.getDefaultState(), Blocks.PLANKS.getDefaultState(), false);
        this.fillWithBlocks(world, box, 3, 7, 8, 7, 7, 8, Blocks.PLANKS.getDefaultState(), Blocks.PLANKS.getDefaultState(), false);
        this.setBlockState(world, Blocks.PLANKS.getDefaultState(), 5, 8, 8, box);
        this.fillWithBlocks(world, box, 1, 1, 4, 1, 3, 7, Blocks.PLANKS.getDefaultState(), Blocks.PLANKS.getDefaultState(), false);
        this.fillWithBlocks(world, box, 1, 5, 6, 1, 5, 7, Blocks.PLANKS.getDefaultState(), Blocks.PLANKS.getDefaultState(), false);
        this.fillWithBlocks(world, box, 9, 1, 4, 9, 3, 7, Blocks.PLANKS.getDefaultState(), Blocks.PLANKS.getDefaultState(), false);
        this.fillWithBlocks(world, box, 9, 5, 4, 9, 6, 7, Blocks.PLANKS.getDefaultState(), Blocks.PLANKS.getDefaultState(), false);
        this.setBlockState(world, Blocks.GLASS_PANE.getDefaultState(), 2, 2, 3, box);
        this.setBlockState(world, Blocks.GLASS_PANE.getDefaultState(), 6, 2, 3, box);
        this.setBlockState(world, Blocks.GLASS_PANE.getDefaultState(), 8, 2, 3, box);
        this.fillWithBlocks(world, box, 7, 6, 3, 8, 6, 3, Blocks.GLASS_PANE.getDefaultState(), Blocks.GLASS_PANE.getDefaultState(), false);
        this.fillWithBlocks(world, box, 3, 2, 8, 5, 2, 8, Blocks.GLASS_PANE.getDefaultState(), Blocks.GLASS_PANE.getDefaultState(), false);
        this.fillWithBlocks(world, box, 3, 6, 8, 4, 6, 8, Blocks.GLASS_PANE.getDefaultState(), Blocks.GLASS_PANE.getDefaultState(), false);
        this.fillWithBlocks(world, box, 6, 6, 8, 7, 6, 8, Blocks.GLASS_PANE.getDefaultState(), Blocks.GLASS_PANE.getDefaultState(), false);
        this.fillWithBlocks(world, box, 1, 2, 5, 1, 2, 6, Blocks.GLASS_PANE.getDefaultState(), Blocks.GLASS_PANE.getDefaultState(), false);
        this.fillWithBlocks(world, box, 1, 6, 6, 1, 6, 7, Blocks.GLASS_PANE.getDefaultState(), Blocks.GLASS_PANE.getDefaultState(), false);
        this.fillWithBlocks(world, box, 9, 2, 5, 9, 2, 6, Blocks.GLASS_PANE.getDefaultState(), Blocks.GLASS_PANE.getDefaultState(), false);
        this.fillWithBlocks(world, box, 9, 6, 5, 9, 6, 6, Blocks.GLASS_PANE.getDefaultState(), Blocks.GLASS_PANE.getDefaultState(), false);
        this.fillWithBlocks(world, box, 1, 1, 1, 1, 1, 2, IEContent.blockWoodenDecoration.getStateFromMeta(0), IEContent.blockWoodenDecoration.getStateFromMeta(0), false);
        this.fillWithBlocks(world, box, 2, 1, 1, 3, 1, 1, IEContent.blockWoodenDecoration.getStateFromMeta(0), IEContent.blockWoodenDecoration.getStateFromMeta(0), false);
        this.fillWithBlocks(world, box, 5, 1, 1, 5, 1, 2, IEContent.blockWoodenDecoration.getStateFromMeta(0), IEContent.blockWoodenDecoration.getStateFromMeta(0), false);
        this.fillWithBlocks(world, box, 1, 5, 3, 1, 5, 4, IEContent.blockWoodenDecoration.getStateFromMeta(0), IEContent.blockWoodenDecoration.getStateFromMeta(0), false);
        this.fillWithBlocks(world, box, 2, 5, 3, 5, 5, 3, IEContent.blockWoodenDecoration.getStateFromMeta(0), IEContent.blockWoodenDecoration.getStateFromMeta(0), false);
        this.fillWithBlocks(world, box, 7, 1, 6, 7, 5, 6, IEContent.blockWoodenDecoration.getStateFromMeta(0), IEContent.blockWoodenDecoration.getStateFromMeta(0), false);
        this.generateDoor(world, box, rand, 4, 1, 3, EnumFacing.NORTH, Blocks.OAK_DOOR);
        if (this.getCoordBaseMode() == EnumFacing.SOUTH || this.getCoordBaseMode() == EnumFacing.WEST) {
            this.placeDoor(world, box, rand, 3, 5, 5, EnumFacing.NORTH, BlockDoor.EnumHingePosition.LEFT);
            this.placeDoor(world, box, rand, 4, 5, 5, EnumFacing.NORTH, BlockDoor.EnumHingePosition.RIGHT);
        } else {
            this.placeDoor(world, box, rand, 3, 5, 5, EnumFacing.NORTH, BlockDoor.EnumHingePosition.LEFT);
            this.placeDoor(world, box, rand, 4, 5, 5, EnumFacing.NORTH, BlockDoor.EnumHingePosition.RIGHT);
        }
        this.placeLantern(world, box, 5, 3, 6, 0);
        this.placeLantern(world, box, 5, 7, 6, 0);
        IBlockState stairs = Blocks.OAK_STAIRS.getDefaultState().withProperty((IProperty)BlockStairs.FACING, (Comparable)EnumFacing.NORTH);
        this.setBlockState(world, stairs, 8, 1, 6, box);
        stairs = stairs.withRotation(Rotation.COUNTERCLOCKWISE_90);
        this.setBlockState(world, Blocks.PLANKS.getDefaultState(), 8, 1, 7, box);
        this.setBlockState(world, stairs, 7, 2, 7, box);
        this.setBlockState(world, stairs, 6, 3, 7, box);
        this.setBlockState(world, stairs, 5, 4, 7, box);
        IBlockState brickSlab = Blocks.STONE_SLAB.getDefaultState().withProperty((IProperty)BlockStoneSlab.VARIANT, (Comparable)BlockStoneSlab.EnumType.BRICK);
        IBlockState brickSlabInverted = brickSlab.withProperty((IProperty)BlockSlab.HALF, (Comparable)BlockSlab.EnumBlockHalf.TOP);
        this.fillWithBlocks(world, box, 0, 6, 4, 0, 6, 8, brickSlabInverted, brickSlabInverted, false);
        this.fillWithBlocks(world, box, 1, 7, 4, 1, 7, 8, brickSlab, brickSlab, false);
        this.fillWithBlocks(world, box, 3, 8, 4, 3, 8, 8, brickSlab, brickSlab, false);
        this.fillWithBlocks(world, box, 5, 9, 2, 5, 9, 8, brickSlab, brickSlab, false);
        this.fillWithBlocks(world, box, 7, 8, 2, 7, 8, 8, brickSlab, brickSlab, false);
        this.fillWithBlocks(world, box, 9, 7, 2, 9, 7, 8, brickSlab, brickSlab, false);
        this.fillWithBlocks(world, box, 10, 6, 2, 10, 6, 8, brickSlabInverted, brickSlabInverted, false);
        IBlockState brickStairs = Blocks.BRICK_STAIRS.getDefaultState().withProperty((IProperty)BlockStairs.FACING, (Comparable)EnumFacing.EAST);
        this.fillWithBlocks(world, box, 2, 7, 4, 2, 7, 8, brickStairs, brickStairs, false);
        this.fillWithBlocks(world, box, 4, 8, 4, 4, 8, 8, brickStairs, brickStairs, false);
        brickStairs = brickStairs.withRotation(Rotation.CLOCKWISE_180);
        this.fillWithBlocks(world, box, 6, 8, 2, 6, 8, 8, brickStairs, brickStairs, false);
        this.fillWithBlocks(world, box, 8, 7, 2, 8, 7, 8, brickStairs, brickStairs, false);
        this.fillWithBlocks(world, box, 2, 7, 5, 2, 8, 5, Blocks.BRICK_BLOCK.getDefaultState(), Blocks.BRICK_BLOCK.getDefaultState(), false);
        this.fillWithBlocks(world, box, 7, 8, 4, 7, 9, 4, Blocks.BRICK_BLOCK.getDefaultState(), Blocks.BRICK_BLOCK.getDefaultState(), false);
        try {
            this.placeCrate(world, box, rand, 6, 0, 1);
            this.placeCrate(world, box, rand, 8, 0, 2);
            this.placeCrate(world, box, rand, 5, 1, 7);
            this.placeItemframe(rand, world, 4, 3, 2, this.getCoordBaseMode().getOpposite(), new ItemStack((Item)IEContent.itemTool, 1, 0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int zz = 0; zz <= 9; ++zz) {
            for (int xx = 0; xx <= 10; ++xx) {
                this.clearCurrentPositionBlocksUpwards(world, xx, 10, zz, box);
                this.replaceAirAndLiquidDownwards(world, Blocks.COBBLESTONE.getDefaultState(), xx, -1, zz, box);
            }
        }
        if (Config.IEConfig.enableVillagers) {
            this.spawnVillagers(world, box, 4, 1, 2, 1);
        }
        return true;
    }

    protected boolean placeCrate(World world, StructureBoundingBox box, Random rand, int x, int y, int z) {
        int k1;
        int j1;
        int i1 = this.getXWithOffset(x, z);
        BlockPos pos = new BlockPos(i1, j1 = this.getYWithOffset(y), k1 = this.getZWithOffset(x, z));
        if (box.isVecInside((Vec3i)pos) && world.getBlockState(pos) != IEContent.blockWoodenDevice0.getStateFromMeta(0)) {
            world.setBlockState(pos, IEContent.blockWoodenDevice0.getStateFromMeta(0), 2);
            TileEntity tile = world.getTileEntity(pos);
            if (tile instanceof TileEntityWoodenCrate) {
                ((TileEntityWoodenCrate)tile).lootTable = woodenCrateLoot;
            }
            return true;
        }
        return false;
    }

    protected void placeDoor(World worldIn, StructureBoundingBox boundingBoxIn, Random rand, int x, int y, int z, EnumFacing facing, BlockDoor.EnumHingePosition hinge) {
        this.setBlockState(worldIn, Blocks.OAK_DOOR.getDefaultState().withProperty((IProperty)BlockDoor.FACING, (Comparable)facing).withProperty((IProperty)BlockDoor.HINGE, (Comparable)hinge), x, y, z, boundingBoxIn);
        this.setBlockState(worldIn, Blocks.OAK_DOOR.getDefaultState().withProperty((IProperty)BlockDoor.FACING, (Comparable)facing).withProperty((IProperty)BlockDoor.HALF, (Comparable)BlockDoor.EnumDoorHalf.UPPER).withProperty((IProperty)BlockDoor.HINGE, (Comparable)hinge), x, y + 1, z, boundingBoxIn);
    }

    protected boolean placeLantern(World world, StructureBoundingBox box, int x, int y, int z, int facing) {
        int i1 = this.getXWithOffset(x, z);
        int j1 = this.getYWithOffset(y);
        int k1 = this.getZWithOffset(x, z);
        BlockPos pos = new BlockPos(i1, j1, k1);
        return box.isVecInside((Vec3i)pos);
    }

    public void placeItemframe(Random random, World world, int x, int y, int z, EnumFacing side, ItemStack stack) {
        int i1 = this.getXWithOffset(x, z);
        int j1 = this.getYWithOffset(y);
        int k1 = this.getZWithOffset(x, z);
        EntityItemFrame e = new EntityItemFrame(world, new BlockPos(i1, j1, k1), side);
        e.setDisplayedItem(stack);
        if (e.onValidSurface() && world.getEntitiesWithinAABB(EntityHanging.class, new AxisAlignedBB((double)i1 - 0.125, (double)j1, (double)k1 - 0.125, (double)i1 + 1.125, (double)(j1 + 1), (double)k1 + 1.125)).isEmpty() && !world.isRemote) {
            world.spawnEntity((Entity)e);
        }
    }

    protected VillagerRegistry.VillagerProfession chooseForgeProfession(int count, VillagerRegistry.VillagerProfession prof) {
        return IEContent.villagerProfession_engineer;
    }

    public static class VillageManager
    implements VillagerRegistry.IVillageCreationHandler {
        public StructureVillagePieces.Village buildComponent(StructureVillagePieces.PieceWeight villagePiece, StructureVillagePieces.Start startPiece, List<StructureComponent> pieces, Random random, int p1, int p2, int p3, EnumFacing facing, int p5) {
            StructureBoundingBox box = StructureBoundingBox.getComponentToAddBoundingBox((int)p1, (int)p2, (int)p3, (int)0, (int)0, (int)0, (int)11, (int)10, (int)9, (EnumFacing)facing);
            return !VillageEngineersHouse.canVillageGoDeeper((StructureBoundingBox)box) || StructureComponent.findIntersecting(pieces, (StructureBoundingBox)box) != null ? null : new VillageEngineersHouse(startPiece, p5, random, box, facing);
        }

        public StructureVillagePieces.PieceWeight getVillagePieceWeight(Random random, int i) {
            return new StructureVillagePieces.PieceWeight(VillageEngineersHouse.class, 15, MathHelper.getInt((Random)random, (int)(0 + i), (int)(1 + i)));
        }

        public Class<?> getComponentClass() {
            return VillageEngineersHouse.class;
        }
    }
}

