/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.sound;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.items.ItemEarmuffs;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import javax.annotation.Nullable;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;

public class IETileSound
implements ITickableSound {
    protected Sound sound;
    private SoundEventAccessor soundEvent;
    private SoundCategory category;
    public ISound.AttenuationType attenuation;
    public final ResourceLocation resource;
    public float volume;
    public float pitch;
    public int tileX;
    public int tileY;
    public int tileZ;
    public boolean canRepeat;
    public int repeatDelay;
    public float volumeAjustment = 1.0f;
    public float[] origPos;
    public boolean donePlaying = false;

    public IETileSound(SoundEvent event, float volume, float pitch, boolean repeat, int repeatDelay, int x, int y, int z, ISound.AttenuationType attenuation, SoundCategory category) {
        this(event.getSoundName(), volume, pitch, repeat, repeatDelay, x, y, z, attenuation, category);
    }

    public IETileSound(ResourceLocation sound, float volume, float pitch, boolean repeat, int repeatDelay, int x, int y, int z, ISound.AttenuationType attenuation, SoundCategory category) {
        this.attenuation = attenuation;
        this.resource = sound;
        this.volume = volume;
        this.pitch = pitch;
        this.tileX = x;
        this.tileY = y;
        this.tileZ = z;
        this.canRepeat = repeat;
        this.repeatDelay = repeatDelay;
        this.origPos = new float[]{x, y, z};
        this.category = category;
    }

    public IETileSound(SoundEvent event, float volume, float pitch, boolean repeat, int repeatDelay, BlockPos pos, ISound.AttenuationType attenuation, SoundCategory category) {
        this(event.getSoundName(), volume, pitch, repeat, repeatDelay, pos.getX(), pos.getY(), pos.getZ(), attenuation, category);
    }

    public IETileSound(ResourceLocation sound, float volume, float pitch, boolean repeat, int repeatDelay, BlockPos pos, ISound.AttenuationType attenuation, SoundCategory category) {
        this(sound, volume, pitch, repeat, repeatDelay, pos.getX(), pos.getY(), pos.getZ(), attenuation, category);
    }

    public ISound.AttenuationType getAttenuationType() {
        return this.attenuation;
    }

    public ResourceLocation getSoundLocation() {
        return this.resource;
    }

    @Nullable
    public SoundEventAccessor createAccessor(SoundHandler handler) {
        this.soundEvent = handler.getAccessor(this.resource);
        this.sound = this.soundEvent == null ? SoundHandler.MISSING_SOUND : this.soundEvent.cloneEntry();
        return this.soundEvent;
    }

    public Sound getSound() {
        return this.sound;
    }

    public SoundCategory getCategory() {
        return this.category;
    }

    public float getVolume() {
        return this.volume * this.volumeAjustment;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getXPosF() {
        return this.tileX;
    }

    public float getYPosF() {
        return this.tileY;
    }

    public float getZPosF() {
        return this.tileZ;
    }

    public boolean canRepeat() {
        return this.canRepeat;
    }

    public int getRepeatDelay() {
        return this.repeatDelay;
    }

    public void evaluateVolume() {
        TileEntity tile;
        this.volumeAjustment = 1.0f;
        if (ClientUtils.mc().player != null && !ClientUtils.mc().player.getItemStackFromSlot(EntityEquipmentSlot.HEAD).isEmpty()) {
            ItemStack stack = ClientUtils.mc().player.getItemStackFromSlot(EntityEquipmentSlot.HEAD);
            if (ItemNBTHelper.hasKey(stack, "IE:Earmuffs")) {
                stack = ItemNBTHelper.getItemStack(stack, "IE:Earmuffs");
            }
            if (!stack.isEmpty() && IEContent.itemEarmuffs.equals(stack.getItem())) {
                this.volumeAjustment = ItemEarmuffs.getVolumeMod(stack);
            }
        }
        if (this.volumeAjustment > 0.1f) {
            for (int dx = (int)Math.floor(this.tileX - 8) >> 4; dx <= (int)Math.floor(this.tileX + 8) >> 4; ++dx) {
                for (int dz = (int)Math.floor(this.tileZ - 8) >> 4; dz <= (int)Math.floor(this.tileZ + 8) >> 4; ++dz) {
                    for (TileEntity tile2 : ClientUtils.mc().player.world.getChunkFromChunkCoords(dx, dz).getTileEntityMap().values()) {
                        double d;
                        if (tile2 == null || !tile2.getClass().getName().endsWith("TileEntitySoundMuffler") || tile2.getBlockMetadata() == 1 || !((d = tile2.getDistanceSq((double)this.tileX, (double)this.tileY, (double)this.tileZ)) <= 64.0) || !(d > 0.0)) continue;
                        this.volumeAjustment = 0.1f;
                    }
                }
            }
        }
        this.donePlaying = !((tile = ClientUtils.mc().player.world.getTileEntity(new BlockPos(this.tileX, this.tileY, this.tileZ))) instanceof IEBlockInterfaces.ISoundTile) ? true : !((IEBlockInterfaces.ISoundTile)tile).shoudlPlaySound(this.resource.toString());
    }

    public void update() {
        if (ClientUtils.mc().player != null && ClientUtils.mc().player.world.getTotalWorldTime() % 40L == 0L) {
            this.evaluateVolume();
        }
    }

    public boolean isDonePlaying() {
        return this.donePlaying;
    }
}

