/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.network;

import blusunrize.immersiveengineering.common.items.ItemIEShield;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageMagnetEquip
implements IMessage {
    String player;
    int fetchSlot;

    public MessageMagnetEquip(String player, int fetch) {
        this.player = player;
        this.fetchSlot = fetch;
    }

    public MessageMagnetEquip() {
    }

    public void fromBytes(ByteBuf buf) {
        this.player = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.fetchSlot = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.player);
        buf.writeInt(this.fetchSlot);
    }

    public static class Handler
    implements IMessageHandler<MessageMagnetEquip, IMessage> {
        public IMessage onMessage(MessageMagnetEquip message, MessageContext ctx) {
            EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().getPlayerList().getPlayerByUsername(message.player);
            if (player != null) {
                ItemStack held = player.getHeldItem(EnumHand.OFF_HAND);
                if (message.fetchSlot >= 0) {
                    ItemStack s = (ItemStack)player.inventory.mainInventory.get(message.fetchSlot);
                    if (!s.isEmpty() && s.getItem() instanceof ItemIEShield && ((ItemIEShield)s.getItem()).getUpgrades(s).getBoolean("magnet")) {
                        ((ItemIEShield)s.getItem()).getUpgrades(s).setInteger("prevSlot", message.fetchSlot);
                        player.inventory.mainInventory.set(message.fetchSlot, (Object)held);
                        player.setHeldItem(EnumHand.OFF_HAND, s);
                    }
                } else {
                    int prevSlot = ((ItemIEShield)held.getItem()).getUpgrades(held).getInteger("prevSlot");
                    ItemStack s = (ItemStack)player.inventory.mainInventory.get(prevSlot);
                    player.inventory.mainInventory.set(prevSlot, (Object)held);
                    player.setHeldItem(EnumHand.OFF_HAND, s);
                    ((ItemIEShield)held.getItem()).getUpgrades(held).removeTag("prevSlot");
                }
            }
            return null;
        }
    }
}

