/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.inventory;

import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class MultiFluidTank
implements IFluidTank,
IFluidHandler {
    public ArrayList<FluidStack> fluids = new ArrayList();
    private final int capacity;

    public MultiFluidTank(int capacity) {
        this.capacity = capacity;
    }

    public MultiFluidTank readFromNBT(NBTTagCompound nbt) {
        if (nbt.hasKey("fluids")) {
            this.fluids.clear();
            NBTTagList tagList = nbt.getTagList("fluids", 10);
            for (int i = 0; i < tagList.tagCount(); ++i) {
                FluidStack fs = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagList.getCompoundTagAt(i));
                if (fs == null) continue;
                this.fluids.add(fs);
            }
        }
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList tagList = new NBTTagList();
        for (FluidStack fs : this.fluids) {
            if (fs == null) continue;
            tagList.appendTag((NBTBase)fs.writeToNBT(new NBTTagCompound()));
        }
        nbt.setTag("fluids", (NBTBase)tagList);
        return nbt;
    }

    public int getFluidTypes() {
        return this.fluids.size();
    }

    @Nullable
    public FluidStack getFluid() {
        return this.fluids.size() > 0 ? this.fluids.get(this.fluids.size() - 1) : null;
    }

    public int getFluidAmount() {
        int sum = 0;
        for (FluidStack fs : this.fluids) {
            sum += fs.amount;
        }
        return sum;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public FluidTankInfo getInfo() {
        FluidStack fs = this.getFluid();
        int capacity = this.capacity - this.getFluidAmount();
        if (fs != null) {
            capacity += fs.amount;
        }
        return new FluidTankInfo(fs, capacity);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[0];
    }

    public int fill(FluidStack resource, boolean doFill) {
        int space = this.capacity - this.getFluidAmount();
        int toFill = Math.min(resource.amount, space);
        if (!doFill) {
            return toFill;
        }
        for (FluidStack fs : this.fluids) {
            if (!fs.isFluidEqual(resource)) continue;
            fs.amount += toFill;
            return toFill;
        }
        this.fluids.add(Utils.copyFluidStackWithAmount(resource, toFill, true));
        return toFill;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.fluids.isEmpty()) {
            return null;
        }
        Iterator<FluidStack> it = this.fluids.iterator();
        while (it.hasNext()) {
            FluidStack fs = it.next();
            if (!fs.isFluidEqual(resource)) continue;
            int amount = Math.min(resource.amount, fs.amount);
            if (doDrain) {
                fs.amount -= amount;
                if (fs.amount <= 0) {
                    it.remove();
                }
            }
            return Utils.copyFluidStackWithAmount(resource, amount, true);
        }
        return null;
    }

    public static FluidStack drain(int remove, FluidStack removeFrom, Iterator<FluidStack> removeIt, boolean doDrain) {
        int amount = Math.min(remove, removeFrom.amount);
        if (doDrain) {
            removeFrom.amount -= amount;
            if (removeFrom.amount <= 0) {
                removeIt.remove();
            }
        }
        return Utils.copyFluidStackWithAmount(removeFrom, amount, true);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.fluids.isEmpty()) {
            return null;
        }
        return this.drain(new FluidStack(this.getFluid(), maxDrain), doDrain);
    }
}

