/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.inventory;

import blusunrize.immersiveengineering.common.items.ItemInternalStorage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class IEItemStackHandler
extends ItemStackHandler
implements ICapabilityProvider {
    private boolean first = true;
    private ItemStack stack;
    @Nonnull
    private Runnable onChange = () -> {};

    public IEItemStackHandler(ItemStack stack) {
        this.stack = stack;
    }

    public void setTile(TileEntity tile) {
        this.onChange = tile != null ? () -> ((TileEntity)tile).markDirty() : () -> {};
    }

    public void setInventoryForUpdate(IInventory inv) {
        this.onChange = inv != null ? () -> ((IInventory)inv).markDirty() : () -> {};
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.onChange.run();
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.first) {
            int idealSize = ((ItemInternalStorage)this.stack.getItem()).getSlotCount(this.stack);
            NonNullList newList = NonNullList.withSize((int)idealSize, (Object)ItemStack.EMPTY);
            for (int i = 0; i < Math.min(this.stacks.size(), idealSize); ++i) {
                newList.set(i, this.stacks.get(i));
            }
            this.stacks = newList;
            this.stack = ItemStack.EMPTY;
            this.first = false;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this);
        }
        return null;
    }

    public NonNullList<ItemStack> getContainedItems() {
        return this.stacks;
    }
}

