/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.inventory;

import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class IEInventoryHandler
implements IItemHandlerModifiable {
    int slots;
    IIEInventory inv;
    int slotOffset;
    boolean[] canInsert;
    boolean[] canExtract;

    public IEInventoryHandler(int slots, IIEInventory inventory, int slotOffset, boolean[] canInsert, boolean[] canExtract) {
        this.slots = slots;
        this.inv = inventory;
        this.slotOffset = slotOffset;
        this.canInsert = canInsert;
        this.canExtract = canExtract;
    }

    public IEInventoryHandler(int slots, IIEInventory inventory) {
        this(slots, inventory, 0, new boolean[slots], new boolean[slots]);
        for (int i = 0; i < slots; ++i) {
            this.canInsert[i] = true;
            this.canExtract[i] = true;
        }
    }

    public IEInventoryHandler(int slots, IIEInventory inventory, int slotOffset, boolean canInsert, boolean canExtract) {
        this(slots, inventory, slotOffset, new boolean[slots], new boolean[slots]);
        for (int i = 0; i < slots; ++i) {
            this.canInsert[i] = canInsert;
            this.canExtract[i] = canExtract;
        }
    }

    public int getSlots() {
        return this.slots;
    }

    public ItemStack getStackInSlot(int slot) {
        return (ItemStack)this.inv.getInventory().get(this.slotOffset + slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (!this.canInsert[slot] || stack.isEmpty()) {
            return stack;
        }
        if (!this.inv.isStackValid(this.slotOffset + slot, stack = stack.copy())) {
            return stack;
        }
        int offsetSlot = this.slotOffset + slot;
        ItemStack currentStack = (ItemStack)this.inv.getInventory().get(offsetSlot);
        if (currentStack.isEmpty()) {
            int accepted = Math.min(stack.getMaxStackSize(), this.inv.getSlotLimit(offsetSlot));
            if (accepted < stack.getCount()) {
                if (!simulate) {
                    this.inv.getInventory().set(offsetSlot, (Object)stack.splitStack(accepted));
                    this.inv.doGraphicalUpdates(offsetSlot);
                    return stack;
                }
                stack.shrink(accepted);
                return stack;
            }
            if (!simulate) {
                this.inv.getInventory().set(offsetSlot, (Object)stack);
                this.inv.doGraphicalUpdates(offsetSlot);
            }
            return ItemStack.EMPTY;
        }
        if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)currentStack)) {
            return stack;
        }
        int accepted = Math.min(stack.getMaxStackSize(), this.inv.getSlotLimit(offsetSlot)) - currentStack.getCount();
        if (accepted < stack.getCount()) {
            if (!simulate) {
                ItemStack newStack = stack.splitStack(accepted);
                newStack.grow(currentStack.getCount());
                this.inv.getInventory().set(offsetSlot, (Object)newStack);
                this.inv.doGraphicalUpdates(offsetSlot);
                return stack;
            }
            stack.shrink(accepted);
            return stack;
        }
        if (!simulate) {
            ItemStack newStack = stack.copy();
            newStack.grow(currentStack.getCount());
            this.inv.getInventory().set(offsetSlot, (Object)newStack);
            this.inv.doGraphicalUpdates(offsetSlot);
        }
        return ItemStack.EMPTY;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.canExtract[slot] || amount == 0) {
            return ItemStack.EMPTY;
        }
        int offsetSlot = this.slotOffset + slot;
        ItemStack currentStack = (ItemStack)this.inv.getInventory().get(offsetSlot);
        if (currentStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int extracted = Math.min(currentStack.getCount(), amount);
        ItemStack copy = currentStack.copy();
        copy.setCount(extracted);
        if (!simulate) {
            if (extracted < currentStack.getCount()) {
                currentStack.shrink(extracted);
            } else {
                currentStack = ItemStack.EMPTY;
            }
            this.inv.getInventory().set(offsetSlot, (Object)currentStack);
            this.inv.doGraphicalUpdates(offsetSlot);
        }
        return copy;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.inv.getInventory().set(this.slotOffset + slot, (Object)stack);
        this.inv.doGraphicalUpdates(this.slotOffset + slot);
    }
}

