/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker;

import blusunrize.immersiveengineering.api.crafting.CokeOvenRecipe;
import blusunrize.immersiveengineering.common.util.compat.IECompatModule;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CraftTweakerHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.List;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersiveengineering.CokeOven")
public class CokeOven {
    @ZenMethod
    public static void addRecipe(IItemStack output, int fuelOutput, IIngredient input, int time) {
        Object oInput = CraftTweakerHelper.toObject(input);
        if (oInput == null) {
            return;
        }
        CokeOvenRecipe r = new CokeOvenRecipe(CraftTweakerHelper.toStack(output), oInput, time, fuelOutput);
        CraftTweakerAPI.apply((IAction)new Add(r));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toStack(output)));
    }

    private static class Remove
    implements IAction {
        private final ItemStack output;
        List<CokeOvenRecipe> removedRecipes;

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            this.removedRecipes = CokeOvenRecipe.removeRecipes(this.output);
            for (CokeOvenRecipe recipe : this.removedRecipes) {
                IECompatModule.jeiRemoveFunc.accept(recipe);
            }
        }

        public String describe() {
            return "Removing Coke Oven Recipe for " + this.output.getDisplayName();
        }
    }

    private static class Add
    implements IAction {
        private final CokeOvenRecipe recipe;

        public Add(CokeOvenRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            CokeOvenRecipe.recipeList.add(this.recipe);
            IECompatModule.jeiAddFunc.accept(this.recipe);
        }

        public String describe() {
            return "Adding Coke Oven Recipe for " + this.recipe.output.getDisplayName();
        }
    }
}

