/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker;

import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.common.util.compat.IECompatModule;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CraftTweakerHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.List;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersiveengineering.ArcFurnace")
public class ArcFurnace {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient input, IItemStack slag, int time, int energyPerTick, @Optional IIngredient[] additives, @Optional String specialRecipeType) {
        Object oInput = CraftTweakerHelper.toObject(input);
        if (oInput == null) {
            return;
        }
        Object[] adds = null;
        if (additives != null) {
            adds = new Object[additives.length];
            for (int i = 0; i < additives.length; ++i) {
                adds[i] = CraftTweakerHelper.toObject(additives[i]);
            }
        }
        ArcFurnaceRecipe r = new ArcFurnaceRecipe(CraftTweakerHelper.toStack(output), oInput, CraftTweakerHelper.toStack(slag), time, energyPerTick, adds);
        if (specialRecipeType != null) {
            r.setSpecialRecipeType(specialRecipeType);
        }
        CraftTweakerAPI.apply((IAction)new Add(r));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toStack(output)));
    }

    private static class Remove
    implements IAction {
        private final ItemStack output;
        List<ArcFurnaceRecipe> removedRecipes;

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            this.removedRecipes = ArcFurnaceRecipe.removeRecipes(this.output);
            for (ArcFurnaceRecipe recipe : this.removedRecipes) {
                IECompatModule.jeiRemoveFunc.accept(recipe);
            }
        }

        public String describe() {
            return "Removing ArcFurnace Recipe for " + this.output.getDisplayName();
        }
    }

    private static class Add
    implements IAction {
        private final ArcFurnaceRecipe recipe;

        public Add(ArcFurnaceRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            ArcFurnaceRecipe.recipeList.add(this.recipe);
            IECompatModule.jeiAddFunc.accept(this.recipe);
        }

        public String describe() {
            return "Adding ArcFurnace Recipe for " + this.recipe.output.getDisplayName();
        }
    }
}

