/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat;

import blusunrize.immersiveengineering.api.tool.BelljarHandler;
import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.util.IEPotions;
import blusunrize.immersiveengineering.common.util.compat.IECompatModule;
import java.lang.reflect.Field;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.oredict.OreDictionary;

public class ThermalFoundationHelper
extends IECompatModule {
    @Override
    public void preInit() {
    }

    @Override
    public void init() {
        OreDictionary.registerOre((String)"crystalSlag", (ItemStack)new ItemStack((Item)IEContent.itemMaterial, 1, 7));
        ChemthrowerHandler.registerEffect("coal", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, IEPotions.flammable, 100, 0));
        ChemthrowerHandler.registerFlammable("coal");
        ChemthrowerHandler.registerEffect("crude_oil", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, new PotionEffect(IEPotions.flammable, 140, 0), new PotionEffect(MobEffects.BLINDNESS, 80, 1)));
        ChemthrowerHandler.registerFlammable("crude_oil");
        ChemthrowerHandler.registerEffect("refined_oil", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, IEPotions.flammable, 100, 1));
        ChemthrowerHandler.registerFlammable("refined_oil");
        ChemthrowerHandler.registerEffect("resin", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, IEPotions.sticky, 100, 1));
        ChemthrowerHandler.registerEffect("tree_oil", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, IEPotions.flammable, 120, 0));
        ChemthrowerHandler.registerFlammable("tree_oil");
        ChemthrowerHandler.registerEffect("redstone", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, IEPotions.conductive, 100, 1));
        ChemthrowerHandler.registerEffect("glowstone", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, new PotionEffect(MobEffects.GLOWING, 120, 0), new PotionEffect(MobEffects.SPEED, 120, 0), new PotionEffect(MobEffects.JUMP_BOOST, 120, 0)));
        ChemthrowerHandler.registerEffect("ender", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_RandomTeleport(null, 0.0f, 1.0f));
        try {
            Class<?> c_DamageHelper = Class.forName("cofh.lib.util.helpers.DamageHelper");
            DamageSource pyrotheum = (DamageSource)c_DamageHelper.getDeclaredField("pyrotheum").get(null);
            Field f_explodeCreepers = Class.forName("cofh.thermalfoundation.fluid.BlockFluidPyrotheum").getDeclaredField("effect");
            f_explodeCreepers.setAccessible(true);
            if (((Boolean)f_explodeCreepers.get(null)).booleanValue()) {
                ChemthrowerHandler.registerEffect("pyrotheum", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Damage(pyrotheum, 3.0f){

                    @Override
                    public void applyToEntity(EntityLivingBase target, @Nullable EntityPlayer shooter, ItemStack thrower, Fluid fluid) {
                        super.applyToEntity(target, shooter, thrower, fluid);
                        if (target instanceof EntityCreeper) {
                            target.getEntityWorld().createExplosion((Entity)target, target.posX, target.posY, target.posZ, 6.0f, target.getEntityWorld().getGameRules().getBoolean("mobGriefing"));
                            target.setDead();
                        }
                    }
                });
            } else {
                ChemthrowerHandler.registerEffect("pyrotheum", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Damage(pyrotheum, 3.0f));
            }
            DamageSource cryotheum = (DamageSource)c_DamageHelper.getDeclaredField("cryotheum").get(null);
            ChemthrowerHandler.registerEffect("cryotheum", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(cryotheum, 2.0f, MobEffects.SLOWNESS, 50, 3));
        }
        catch (Exception c_DamageHelper) {
            // empty catch block
        }
        ChemthrowerHandler.registerEffect("aerotheum", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, new PotionEffect(MobEffects.INVISIBILITY, 60, 0), new PotionEffect(MobEffects.WATER_BREATHING, 300, 0)));
        ChemthrowerHandler.registerEffect("petrotheum", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, new PotionEffect[]{new PotionEffect(MobEffects.HASTE, 300, 2), new PotionEffect(MobEffects.NIGHT_VISION, 300, 0), new PotionEffect(MobEffects.RESISTANCE, 300, 1)}){

            @Override
            public void applyToBlock(World world, RayTraceResult mop, @Nullable EntityPlayer shooter, ItemStack thrower, Fluid fluid) {
                IBlockState state = world.getBlockState(mop.getBlockPos());
                if (state.getBlock() == Blocks.STONE || state.getBlock() == Blocks.COBBLESTONE || state.getBlock() == Blocks.STONEBRICK || state.getBlock() == Blocks.MOSSY_COBBLESTONE) {
                    world.setBlockState(mop.getBlockPos(), Blocks.GRAVEL.getDefaultState());
                }
            }
        });
        ChemthrowerHandler.registerEffect("mana", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_RandomTeleport(null, 0.0f, 0.01f));
        final Item itemPhyto = (Item)Item.REGISTRY.getObject((Object)new ResourceLocation("thermalfoundation:fertilizer"));
        if (itemPhyto != null) {
            BelljarHandler.registerItemFertilizer(new BelljarHandler.ItemFertilizerHandler(){

                @Override
                public boolean isValid(@Nullable ItemStack fertilizer) {
                    return !fertilizer.isEmpty() && fertilizer.getItem() == itemPhyto;
                }

                @Override
                public float getGrowthMultiplier(ItemStack fertilizer, ItemStack seed, ItemStack soil, TileEntity tile) {
                    return 1.5f + 0.25f * (float)fertilizer.getMetadata();
                }
            });
        }
    }

    @Override
    public void postInit() {
    }
}

