/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat;

import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.tool.BelljarHandler;
import blusunrize.immersiveengineering.common.util.compat.IECompatModule;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ExtraUtilsHelper
extends IECompatModule {
    @Override
    public void preInit() {
    }

    @Override
    public void init() {
        Item lillySeeds = (Item)Item.REGISTRY.getObject((Object)new ResourceLocation("extrautils2:enderlilly"));
        Block lillyBlock = (Block)Block.REGISTRY.getObject((Object)new ResourceLocation("extrautils2:enderlilly"));
        Item orchidSeeds = (Item)Item.REGISTRY.getObject((Object)new ResourceLocation("extrautils2:redorchid"));
        Block orchidBlock = (Block)Block.REGISTRY.getObject((Object)new ResourceLocation("extrautils2:redorchid"));
        if (lillySeeds != null && lillyBlock != null) {
            ExtraUtilsHelper.registerXUPlant(new ItemStack(lillySeeds), lillyBlock, new ItemStack(Blocks.END_STONE), new ItemStack[]{new ItemStack(Items.ENDER_PEARL)}, 7, 1.25E-5f, false);
        }
        if (orchidSeeds != null && orchidBlock != null) {
            ExtraUtilsHelper.registerXUPlant(new ItemStack(orchidSeeds), orchidBlock, new ItemStack(Blocks.REDSTONE_ORE), new ItemStack[]{new ItemStack(Items.REDSTONE)}, 6, 0.0125f, true);
        }
    }

    @Override
    public void postInit() {
    }

    static void registerXUPlant(ItemStack seed, Block block, ItemStack soil, ItemStack[] output, final int maxAge, final float growthStep, final boolean useFertilizer) {
        IProperty propGrowth = null;
        final IBlockState state = block.getDefaultState();
        for (IProperty prop : state.getPropertyKeys()) {
            if (!"growth".equals(prop.getName())) continue;
            propGrowth = prop;
        }
        if (propGrowth != null) {
            final IProperty finalPropGrowth = propGrowth;
            BelljarHandler.DefaultPlantHandler handler = new BelljarHandler.DefaultPlantHandler(){
                private HashSet<ComparableItemStack> validSeeds = new HashSet();

                @Override
                protected HashSet<ComparableItemStack> getSeedSet() {
                    return this.validSeeds;
                }

                @Override
                public float getGrowthStep(ItemStack seed, ItemStack soil, float growth, TileEntity tile, float fertilizer, boolean render) {
                    return !useFertilizer ? growthStep : growthStep * fertilizer;
                }

                @Override
                @SideOnly(value=Side.CLIENT)
                public IBlockState[] getRenderedPlant(ItemStack seed, ItemStack soil, float growth, TileEntity tile) {
                    return new IBlockState[]{state.withProperty(finalPropGrowth, (Comparable)Integer.valueOf(Math.min(maxAge, Math.round((float)maxAge * growth))))};
                }
            };
            handler.register(seed, output, soil, state);
            BelljarHandler.registerHandler(handler);
        }
    }
}

