/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat;

import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.items.ItemBullet;
import blusunrize.immersiveengineering.common.items.ItemShader;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.compat.IECompatModule;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

public class BotaniaHelper
extends IECompatModule {
    EnumRarity rariryRelic;

    @Override
    public void preInit() {
        BulletHandler.registerBullet("terrasteel", new ItemBullet.HomingBullet(Config.IEConfig.Tools.bulletDamage_Homing, new ResourceLocation("immersiveengineering:items/bullet_terrasteel")));
        BulletHandler.homingCartridges.add("terrasteel");
    }

    @Override
    public void init() {
        BlueprintCraftingRecipe.addRecipe("specialBullet", BulletHandler.getBulletStack("terrasteel"), new ItemStack((Item)IEContent.itemBullet, 1, 0), Items.GUNPOWDER, "nuggetTerrasteel", "nuggetTerrasteel");
        try {
            Class<?> c_BotaniaAPI = Class.forName("vazkii.botania.api.BotaniaAPI");
            Method m_blacklistBlockFromMagnet = c_BotaniaAPI.getDeclaredMethod("blacklistBlockFromMagnet", Block.class, Integer.TYPE);
            m_blacklistBlockFromMagnet.invoke(null, IEContent.blockConveyor, 0);
        }
        catch (Exception e) {
            IELogger.error("[Botania] Failed to protect IE conveyors against Botania's magnets");
            e.printStackTrace();
        }
        this.rariryRelic = EnumRarity.valueOf((String)"RELIC");
        if (this.rariryRelic != null) {
            ShaderRegistry.rarityWeightMap.put(this.rariryRelic, 2);
            this.makeShaderRelic("The Kindled");
            this.makeShaderRelic("Dark Fire");
            ShaderRegistry.ShaderRegistryEntry entry = ItemShader.addShader("Terra", 1, this.rariryRelic, -12702444, -13954808, -12468966, -13757942).setInfo(null, "Botania", "terra");
            entry.getCase("immersiveengineering:revolver").addLayers(new ShaderCase.ShaderLayer(new ResourceLocation("botania:blocks/livingwood5"), -1).setTextureBounds(0.1328125, 0.1875, 0.2578125, 0.3125));
            entry.getCase("immersiveengineering:drill").addLayers(new ShaderCase.ShaderLayer(new ResourceLocation("botania:blocks/alfheim_portal_swirl"), -1).setTextureBounds(0.21875, 0.15625, 0.40625, 0.34375));
            entry.getCase("immersiveengineering:railgun").addLayers(new ShaderCase.ShaderLayer(new ResourceLocation("botania:blocks/storage1"), -6388757).setTextureBounds(0.859375, 0.65625, 1.0, 0.90625).setCutoutBounds(0.1875, 0.0, 0.75, 1.0));
            entry.getCase("immersiveengineering:shield").addLayers(new ShaderCase.ShaderLayer(new ResourceLocation("botania:blocks/crate_open"), -1).setTextureBounds(0.0, 0.28125, 0.4375, 0.8125).setCutoutBounds(0.0625, 0.0, 0.9375, 1.0));
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    void makeShaderRelic(String shader) {
        ShaderRegistry.ShaderRegistryEntry entry = ShaderRegistry.shaderRegistry.get(shader);
        entry.rarity = this.rariryRelic;
        entry.setReplicationCost(ShaderRegistry.defaultReplicationCost.copyWithMultipliedSize(8.0));
    }

    @Override
    public void postInit() {
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onLivingDrops(LivingDropsEvent event) {
        if (!event.isCanceled() && event.getEntityLiving().getClass().getName().endsWith("EntityDoppleganger")) {
            NBTTagCompound tag = new NBTTagCompound();
            event.getEntityLiving().writeEntityToNBT(tag);
            if (tag.getBoolean("hardMode")) {
                for (EntityItem item : event.getDrops()) {
                    if (item == null || item.getItem().isEmpty() || !IEContent.itemShaderBag.equals(item.getItem().getItem())) continue;
                    ItemNBTHelper.setString(item.getItem(), "rarity", "RELIC");
                }
            }
        }
    }
}

