/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat;

import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.tool.BelljarHandler;
import blusunrize.immersiveengineering.common.util.compat.IECompatModule;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AttainedDropsHelper
extends IECompatModule {
    static HashMap<ComparableItemStack, ItemStack[]> soilOutputMap = new HashMap();
    static HashMap<ComparableItemStack, IBlockState> bulbMap = new HashMap();

    @Override
    public void preInit() {
    }

    @Override
    public void init() {
        Block blockPlant = (Block)Block.REGISTRY.getObject((Object)new ResourceLocation("attaineddrops:plant"));
        final Item itemSeed = (Item)Item.REGISTRY.getObject((Object)new ResourceLocation("attaineddrops:itemseed"));
        if (blockPlant == null || itemSeed == null) {
            return;
        }
        final IBlockState blockstatePlant = blockPlant.getDefaultState();
        IProperty propertyAge = null;
        for (IProperty prop : blockstatePlant.getPropertyKeys()) {
            if (!"age".equals(prop.getName()) || !(prop instanceof PropertyInteger)) continue;
            propertyAge = prop;
        }
        final IProperty propertyAge_final = propertyAge;
        AttainedDropsHelper.addType("slimeball", new ItemStack(Items.SLIME_BALL));
        AttainedDropsHelper.addType("bone", new ItemStack(Items.BONE));
        AttainedDropsHelper.addType("string", new ItemStack(Items.STRING));
        AttainedDropsHelper.addType("rottenflesh", new ItemStack(Items.ROTTEN_FLESH));
        AttainedDropsHelper.addType("ghasttear", new ItemStack(Items.GHAST_TEAR));
        AttainedDropsHelper.addType("spidereye", new ItemStack(Items.SPIDER_EYE));
        AttainedDropsHelper.addType("prismarine", new ItemStack(Items.PRISMARINE_SHARD));
        AttainedDropsHelper.addType("blaze", new ItemStack(Items.BLAZE_ROD));
        AttainedDropsHelper.addType("gunpowder", new ItemStack(Items.GUNPOWDER));
        AttainedDropsHelper.addType("witherskull", new ItemStack(Items.SKULL, 1, 1));
        AttainedDropsHelper.addType("enderpearl", new ItemStack(Items.ENDER_PEARL));
        BelljarHandler.registerHandler(new BelljarHandler.IPlantHandler(){

            @Override
            public boolean isCorrectSoil(ItemStack seed, ItemStack soil) {
                return !soil.isEmpty() && soilOutputMap.containsKey(new ComparableItemStack(soil));
            }

            @Override
            public float getGrowthStep(ItemStack seed, ItemStack soil, float growth, TileEntity tile, float fertilizer, boolean render) {
                return ((double)growth < 0.5 ? 0.003125f : 0.0015625f) * fertilizer;
            }

            @Override
            public float resetGrowth(ItemStack seed, ItemStack soil, float growth, TileEntity tile, boolean render) {
                return 0.5f;
            }

            @Override
            public ItemStack[] getOutput(ItemStack seed, ItemStack soil, TileEntity tile) {
                ItemStack[] out = soilOutputMap.get(new ComparableItemStack(soil));
                if (out == null) {
                    return new ItemStack[0];
                }
                return out;
            }

            @Override
            public boolean isValid(ItemStack seed) {
                return !seed.isEmpty() && seed.getItem() == itemSeed;
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public IBlockState[] getRenderedPlant(ItemStack seed, ItemStack soil, float growth, TileEntity tile) {
                return new IBlockState[0];
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public float getRenderSize(ItemStack seed, ItemStack soil, float growth, TileEntity tile) {
                return 0.875f;
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public boolean overrideRender(ItemStack seed, ItemStack soil, float growth, TileEntity tile, BlockRendererDispatcher blockRenderer) {
                IBlockState state = blockstatePlant.withProperty(propertyAge_final, (Comparable)Integer.valueOf((double)growth >= 0.5 ? 7 : Math.min(7, Math.round(7.0f * growth * 2.0f))));
                IBakedModel model = blockRenderer.getModelForState(state);
                GlStateManager.pushMatrix();
                blockRenderer.getBlockModelRenderer().renderModelBrightness(model, state, 1.0f, true);
                GlStateManager.popMatrix();
                if ((double)growth >= 0.5) {
                    state = bulbMap.get(new ComparableItemStack(soil));
                    model = blockRenderer.getModelForState(state);
                    GlStateManager.pushMatrix();
                    float scale = (growth - 0.5f) * 2.0f;
                    GlStateManager.translate((double)(0.5 - (double)(scale / 2.0f)), (double)1.0, (double)(-0.5 + (double)(scale / 2.0f)));
                    GlStateManager.scale((float)scale, (float)scale, (float)scale);
                    blockRenderer.getBlockModelRenderer().renderModelBrightness(model, state, 1.0f, true);
                    GlStateManager.popMatrix();
                }
                return true;
            }
        });
    }

    static void addType(String type, ItemStack out) {
        Block soilBlock = (Block)Block.REGISTRY.getObject((Object)new ResourceLocation("attaineddrops:" + type + "_soil"));
        Block bulbBlock = (Block)Block.REGISTRY.getObject((Object)new ResourceLocation("attaineddrops:" + type + "_bulb"));
        if (soilBlock != null && bulbBlock != null) {
            ComparableItemStack comp = new ComparableItemStack(new ItemStack(soilBlock));
            soilOutputMap.put(comp, new ItemStack[]{out});
            bulbMap.put(comp, bulbBlock.getDefaultState());
        }
    }

    @Override
    public void postInit() {
    }
}

