/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.commands;

import blusunrize.immersiveengineering.api.DimensionChunkCoords;
import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.util.commands.CommandHandler;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;

public class CommandMineral
extends CommandHandler.IESubCommand {
    @Override
    public String getIdent() {
        return "mineral";
    }

    @Override
    public void perform(CommandHandler handler, MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length > 1) {
            DimensionChunkCoords coords = new DimensionChunkCoords(sender.getEntityWorld().provider.getDimension(), sender.getPosition().getX() >> 4, sender.getPosition().getZ() >> 4);
            switch (args[1]) {
                case "list": {
                    String s = "";
                    int i = 0;
                    for (ExcavatorHandler.MineralMix mm : ExcavatorHandler.mineralList.keySet()) {
                        s = s + (i++ > 0 ? ", " : "") + mm.name;
                    }
                    sender.sendMessage((ITextComponent)new TextComponentString(s));
                    break;
                }
                case "get": {
                    ExcavatorHandler.MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo(sender.getEntityWorld(), coords.x, coords.z);
                    sender.sendMessage((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.command." + this.getIdent() + ".get", new Object[]{TextFormatting.GOLD + (info.mineral != null ? info.mineral.name : "null") + TextFormatting.RESET, TextFormatting.GOLD + (info.mineralOverride != null ? info.mineralOverride.name : "null") + TextFormatting.RESET, TextFormatting.GOLD + "" + info.depletion + TextFormatting.RESET}));
                    break;
                }
                case "set": {
                    ExcavatorHandler.MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo(sender.getEntityWorld(), coords.x, coords.z);
                    if (args.length < 3) {
                        sender.sendMessage((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.command." + this.getIdent() + ".set.clear", new Object[]{info.mineralOverride != null ? info.mineralOverride.name : "null"}));
                        info.mineralOverride = null;
                        return;
                    }
                    ExcavatorHandler.MineralMix mineral = null;
                    for (ExcavatorHandler.MineralMix mm : ExcavatorHandler.mineralList.keySet()) {
                        if (!mm.name.equalsIgnoreCase(args[2])) continue;
                        mineral = mm;
                    }
                    if (mineral == null) {
                        sender.sendMessage((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.command." + this.getIdent() + ".set.invalidMineral", new Object[]{args[2]}));
                        return;
                    }
                    info.mineralOverride = mineral;
                    sender.sendMessage((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.command." + this.getIdent() + ".set.sucess", new Object[]{mineral.name}));
                    IESaveData.setDirty(sender.getEntityWorld().provider.getDimension());
                    break;
                }
                case "setDepletion": {
                    ExcavatorHandler.MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo(sender.getEntityWorld(), coords.x, coords.z);
                    if (args.length < 3) {
                        String h = I18n.translateToLocal((String)this.getHelp(".setDepletion"));
                        for (String str : h.split("<br>")) {
                            sender.sendMessage((ITextComponent)new TextComponentString(str));
                        }
                        return;
                    }
                    int depl = 0;
                    try {
                        depl = Integer.parseInt(args[2].trim());
                    }
                    catch (Exception e) {
                        sender.sendMessage((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.command." + this.getIdent() + ".setDepletion.NFE", new Object[]{args[2].trim()}));
                        return;
                    }
                    info.depletion = depl;
                    sender.sendMessage((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.command." + this.getIdent() + ".setDepletion.sucess", new Object[]{depl < 0 ? I18n.translateToLocal((String)"chat.immersiveengineering.info.coreDrill.infinite") : Integer.toString(depl)}));
                    IESaveData.setDirty(sender.getEntityWorld().provider.getDimension());
                    break;
                }
                default: {
                    sender.sendMessage((ITextComponent)new TextComponentTranslation(this.getHelp(""), new Object[0]));
                    break;
                }
            }
        } else {
            sender.sendMessage((ITextComponent)new TextComponentTranslation(this.getHelp(""), new Object[0]));
        }
    }

    @Override
    public ArrayList<String> getSubCommands(CommandHandler h, MinecraftServer server, ICommandSender sender, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length > 1) {
            switch (args[0]) {
                case "set": {
                    if (args.length > 2) break;
                    for (ExcavatorHandler.MineralMix mineralMix : ExcavatorHandler.mineralList.keySet()) {
                        if (!args[1].isEmpty() && !mineralMix.name.toLowerCase(Locale.ENGLISH).startsWith(args[1].toLowerCase(Locale.ENGLISH))) continue;
                        list.add(mineralMix.name);
                    }
                    break;
                }
            }
            return list;
        }
        for (String s : new String[]{"list", "get", "set", "setDepletion"}) {
            if (args.length == 0) {
                list.add(s);
                continue;
            }
            if (!s.toLowerCase(Locale.ENGLISH).startsWith(args[0].toLowerCase(Locale.ENGLISH))) continue;
            list.add(s);
        }
        return list;
    }

    @Override
    public int getPermissionLevel() {
        return 4;
    }
}

