/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.DirectionalBlockPos;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;

public class Utils {
    public static final Random RAND = new Random();
    public static String[] dyeNames = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
    static long UUIDBase = 109406000905L;
    static long UUIDAdd = 1L;
    static Method m_getHarvestLevel = null;
    private static final Gson GSON_INSTANCE = new GsonBuilder().registerTypeAdapter(RandomValueRange.class, (Object)new RandomValueRange.Serializer()).registerTypeAdapter(LootPool.class, (Object)new LootPool.Serializer()).registerTypeAdapter(LootTable.class, (Object)new LootTable.Serializer()).registerTypeHierarchyAdapter(LootEntry.class, (Object)new LootEntry.Serializer()).registerTypeHierarchyAdapter(LootFunction.class, (Object)new LootFunctionManager.Serializer()).registerTypeHierarchyAdapter(LootCondition.class, (Object)new LootConditionManager.Serializer()).registerTypeHierarchyAdapter(LootContext.EntityTarget.class, (Object)new LootContext.EntityTarget.Serializer()).create();

    public static boolean compareToOreName(ItemStack stack, String oreName) {
        if (!ApiUtils.isExistingOreName(oreName)) {
            return false;
        }
        ItemStack comp = Utils.copyStackWithAmount(stack, 1);
        NonNullList s = OreDictionary.getOres((String)oreName);
        for (ItemStack st : s) {
            if (!OreDictionary.itemMatches((ItemStack)st, (ItemStack)comp, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public static boolean stackMatchesObject(ItemStack stack, Object o) {
        return Utils.stackMatchesObject(stack, o, false);
    }

    public static boolean stackMatchesObject(ItemStack stack, Object o, boolean checkNBT) {
        if (o instanceof ItemStack) {
            return OreDictionary.itemMatches((ItemStack)((ItemStack)o), (ItemStack)stack, (boolean)false) && (!checkNBT || ((ItemStack)o).getItemDamage() == Short.MAX_VALUE || Utils.compareItemNBT((ItemStack)o, stack));
        }
        if (o instanceof Collection) {
            for (Object io : (Collection)o) {
                if (!(io instanceof ItemStack) || !OreDictionary.itemMatches((ItemStack)((ItemStack)io), (ItemStack)stack, (boolean)false) || checkNBT && ((ItemStack)io).getItemDamage() != Short.MAX_VALUE && !Utils.compareItemNBT((ItemStack)io, stack)) continue;
                return true;
            }
        } else {
            if (o instanceof IngredientStack) {
                return ((IngredientStack)o).matchesItemStack(stack);
            }
            if (o instanceof ItemStack[]) {
                for (ItemStack io : (ItemStack[])o) {
                    if (!OreDictionary.itemMatches((ItemStack)io, (ItemStack)stack, (boolean)false) || checkNBT && io.getItemDamage() != Short.MAX_VALUE && !Utils.compareItemNBT(io, stack)) continue;
                    return true;
                }
            } else {
                if (o instanceof FluidStack) {
                    FluidStack fs = FluidUtil.getFluidContained((ItemStack)stack);
                    return fs != null && fs.containsFluid((FluidStack)o);
                }
                if (o instanceof String) {
                    return Utils.compareToOreName(stack, (String)o);
                }
            }
        }
        return false;
    }

    public static boolean compareItemNBT(ItemStack stack1, ItemStack stack2) {
        boolean empty2;
        if (stack1.isEmpty() != stack2.isEmpty()) {
            return false;
        }
        boolean empty1 = stack1.getTagCompound() == null || stack1.getTagCompound().hasNoTags();
        boolean bl = empty2 = stack2.getTagCompound() == null || stack2.getTagCompound().hasNoTags();
        if (empty1 != empty2) {
            return false;
        }
        if (!empty1 && !stack1.getTagCompound().equals((Object)stack2.getTagCompound())) {
            return false;
        }
        return stack1.areCapsCompatible(stack2);
    }

    public static boolean canCombineArrays(ItemStack[] stacks, ItemStack[] target) {
        HashSet<IngredientStack> inputSet = new HashSet<IngredientStack>();
        for (ItemStack s : stacks) {
            inputSet.add(new IngredientStack(s));
        }
        for (ItemStack t : target) {
            int size = t.getCount();
            Iterator it = inputSet.iterator();
            while (it.hasNext()) {
                IngredientStack in = (IngredientStack)it.next();
                if (!in.matchesItemStackIgnoringSize(t)) continue;
                int taken = Math.min(size, in.inputSize);
                size -= taken;
                in.inputSize -= taken;
                if (in.inputSize <= 0) {
                    it.remove();
                }
                if (size > 0) continue;
                break;
            }
            if (size <= 0) continue;
            return false;
        }
        return true;
    }

    public static ItemStack copyStackWithAmount(ItemStack stack, int amount) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack s2 = stack.copy();
        s2.setCount(amount);
        return s2;
    }

    public static int getDye(ItemStack stack) {
        if (stack.isEmpty()) {
            return -1;
        }
        if (stack.getItem().equals(Items.DYE)) {
            return stack.getItemDamage();
        }
        for (int dye = 0; dye < dyeNames.length; ++dye) {
            if (!Utils.compareToOreName(stack, "dye" + dyeNames[dye])) continue;
            return dye;
        }
        return -1;
    }

    public static boolean isDye(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        if (stack.getItem().equals(Items.DYE)) {
            return true;
        }
        for (int dye = 0; dye < dyeNames.length; ++dye) {
            if (!Utils.compareToOreName(stack, "dye" + dyeNames[dye])) continue;
            return true;
        }
        return false;
    }

    public static FluidStack copyFluidStackWithAmount(FluidStack stack, int amount, boolean stripPressure) {
        if (stack == null) {
            return null;
        }
        FluidStack fs = new FluidStack(stack, amount);
        if (stripPressure && fs.tag != null && fs.tag.hasKey("pressurized")) {
            fs.tag.removeTag("pressurized");
            if (fs.tag.hasNoTags()) {
                fs.tag = null;
            }
        }
        return fs;
    }

    public static UUID generateNewUUID() {
        UUID uuid = new UUID(UUIDBase, UUIDAdd);
        ++UUIDAdd;
        return uuid;
    }

    public static BlockPos toCC(Object object) {
        return ApiUtils.toBlockPos(object);
    }

    public static DirectionalBlockPos toDirCC(Object object, EnumFacing direction) {
        if (object instanceof BlockPos) {
            return new DirectionalBlockPos((BlockPos)object, direction);
        }
        if (object instanceof TileEntity) {
            return new DirectionalBlockPos(((TileEntity)object).getPos(), direction);
        }
        return null;
    }

    public static boolean isBlockAt(World world, BlockPos pos, Block b, int meta) {
        return Utils.blockstateMatches(world.getBlockState(pos), b, meta);
    }

    public static boolean blockstateMatches(IBlockState state, Block b, int meta) {
        if (state.getBlock().equals(b)) {
            return meta < 0 || meta == Short.MAX_VALUE || state.getBlock().getMetaFromState(state) == meta;
        }
        return false;
    }

    public static boolean isOreBlockAt(World world, BlockPos pos, String oreName) {
        IBlockState state = world.getBlockState(pos);
        ItemStack stack = new ItemStack(state.getBlock(), 1, state.getBlock().getMetaFromState(state));
        return Utils.compareToOreName(stack, oreName);
    }

    public static boolean canFenceConnectTo(IBlockAccess world, BlockPos pos, EnumFacing facing, Material blockMaterial) {
        BlockPos other = pos.offset(facing);
        IBlockState state = world.getBlockState(other);
        Block block = world.getBlockState(other).getBlock();
        if (block.canBeConnectedTo(world, other, facing.getOpposite())) {
            return true;
        }
        BlockFaceShape blockfaceshape = state.getBlockFaceShape(world, other, facing.getOpposite());
        boolean flag = blockfaceshape == BlockFaceShape.MIDDLE_POLE && (state.getMaterial() == blockMaterial || block instanceof BlockFenceGate);
        return !Utils.isExceptBlockForAttachWithFence(block) && blockfaceshape == BlockFaceShape.SOLID || flag;
    }

    private static boolean isExceptionBlockForAttaching(Block block) {
        return block instanceof BlockShulkerBox || block instanceof BlockLeaves || block instanceof BlockTrapDoor || block == Blocks.BEACON || block == Blocks.CAULDRON || block == Blocks.GLASS || block == Blocks.GLOWSTONE || block == Blocks.ICE || block == Blocks.SEA_LANTERN || block == Blocks.STAINED_GLASS;
    }

    private static boolean isExceptBlockForAttachWithPiston(Block block) {
        return Utils.isExceptionBlockForAttaching(block) || block == Blocks.PISTON || block == Blocks.STICKY_PISTON || block == Blocks.PISTON_HEAD;
    }

    private static boolean isExceptBlockForAttachWithFence(Block block) {
        return Utils.isExceptBlockForAttachWithPiston(block) || block == Blocks.BARRIER || block == Blocks.MELON_BLOCK || block == Blocks.PUMPKIN || block == Blocks.LIT_PUMPKIN;
    }

    public static String formatDouble(double d, String s) {
        DecimalFormat df = new DecimalFormat(s);
        return df.format(d);
    }

    public static String toScientificNotation(int value, String decimalPrecision, int useKilo) {
        float formatted;
        float f = value >= 1000000000 ? (float)value / 1.0E9f : (value >= 1000000 ? (float)value / 1000000.0f : (formatted = value >= useKilo ? (float)value / 1000.0f : (float)value));
        String notation = value >= 1000000000 ? "G" : (value >= 1000000 ? "M" : (value >= useKilo ? "K" : ""));
        return Utils.formatDouble(formatted, "0." + decimalPrecision) + notation;
    }

    public static String toCamelCase(String s) {
        return s.substring(0, 1).toUpperCase(Locale.ENGLISH) + s.substring(1).toLowerCase(Locale.ENGLISH);
    }

    public static String getHarvestLevelName(int lvl) {
        if (Loader.isModLoaded((String)"TConstruct")) {
            try {
                Class<?> clazz;
                if (m_getHarvestLevel == null && (clazz = Class.forName("tconstruct.library.util")) != null) {
                    m_getHarvestLevel = clazz.getDeclaredMethod("getHarvestLevelName", Integer.TYPE);
                }
                if (m_getHarvestLevel != null) {
                    return (String)m_getHarvestLevel.invoke(null, lvl);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return I18n.format((String)("desc.immersiveengineering.info.mininglvl." + Math.max(-1, Math.min(lvl, 6))), (Object[])new Object[0]);
    }

    public static String getModVersion(String modid) {
        for (ModContainer container : Loader.instance().getActiveModList()) {
            if (!container.getModId().equalsIgnoreCase(modid)) continue;
            return container.getVersion();
        }
        return "";
    }

    public static boolean tilePositionMatch(TileEntity tile0, TileEntity tile1) {
        return tile0.getPos().equals((Object)tile1.getPos());
    }

    public static EnumFacing rotateFacingTowardsDir(EnumFacing f, EnumFacing dir) {
        if (dir == EnumFacing.NORTH) {
            return f;
        }
        if (dir == EnumFacing.SOUTH && f.getAxis() != EnumFacing.Axis.Y) {
            return f.rotateY().rotateY();
        }
        if (dir == EnumFacing.WEST && f.getAxis() != EnumFacing.Axis.Y) {
            return f.rotateYCCW();
        }
        if (dir == EnumFacing.EAST && f.getAxis() != EnumFacing.Axis.Y) {
            return f.rotateY();
        }
        if (dir == EnumFacing.DOWN && f.getAxis() != EnumFacing.Axis.Y) {
            return f.rotateAround(EnumFacing.Axis.X);
        }
        if (dir == EnumFacing.UP && f.getAxis() != EnumFacing.Axis.X) {
            return f.rotateAround(EnumFacing.Axis.X).getOpposite();
        }
        return f;
    }

    public static RayTraceResult getMovingObjectPositionFromPlayer(World world, EntityLivingBase living, boolean bool) {
        float f = 1.0f;
        float f1 = living.prevRotationPitch + (living.rotationPitch - living.prevRotationPitch) * f;
        float f2 = living.prevRotationYaw + (living.rotationYaw - living.prevRotationYaw) * f;
        double d0 = living.prevPosX + (living.posX - living.prevPosX) * (double)f;
        double d1 = living.prevPosY + (living.posY - living.prevPosY) * (double)f + (double)(world.isRemote ? living.getEyeHeight() - (living instanceof EntityPlayer ? ((EntityPlayer)living).getDefaultEyeHeight() : 0.0f) : living.getEyeHeight());
        double d2 = living.prevPosZ + (living.posZ - living.prevPosZ) * (double)f;
        Vec3d vec3 = new Vec3d(d0, d1, d2);
        float f3 = MathHelper.cos((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.sin((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.cos((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.sin((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = 5.0;
        if (living instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)living).interactionManager.getBlockReachDistance();
        }
        Vec3d vec31 = vec3.addVector((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return world.rayTraceBlocks(vec3, vec31, bool, !bool, false);
    }

    public static boolean canBlocksSeeOther(World world, BlockPos cc0, BlockPos cc1, Vec3d pos0, Vec3d pos1) {
        HashSet<BlockPos> inter = Utils.rayTrace(pos0, pos1, world);
        for (BlockPos cc : inter) {
            if (cc.equals((Object)cc0) || cc.equals((Object)cc1)) continue;
            return false;
        }
        return true;
    }

    public static List<EntityLivingBase> getTargetsInCone(World world, Vec3d start, Vec3d dir, float spreadAngle, float truncationLength) {
        double length = dir.lengthVector();
        Vec3d dirNorm = dir.normalize();
        double radius = Math.tan(spreadAngle / 2.0f) * length;
        Vec3d endLow = start.add(dir).subtract(radius, radius, radius);
        Vec3d endHigh = start.add(dir).addVector(radius, radius, radius);
        AxisAlignedBB box = new AxisAlignedBB(Utils.minInArray(start.x, endLow.x, endHigh.x), Utils.minInArray(start.y, endLow.y, endHigh.y), Utils.minInArray(start.z, endLow.z, endHigh.z), Utils.maxInArray(start.x, endLow.x, endHigh.x), Utils.maxInArray(start.y, endLow.y, endHigh.y), Utils.maxInArray(start.z, endLow.z, endHigh.z));
        List list = world.getEntitiesWithinAABB(EntityLivingBase.class, box);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EntityLivingBase e = (EntityLivingBase)iterator.next();
            if (Utils.isPointInCone(start, dirNorm, radius, length, truncationLength, e.getPositionVector().subtract(start))) continue;
            iterator.remove();
        }
        return list;
    }

    public static boolean isPointInConeByAngle(Vec3d start, Vec3d normDirection, double aperture, double length, Vec3d relativePoint) {
        return Utils.isPointInCone(start, normDirection, Math.tan(aperture / 2.0) * length, length, 0.0f, relativePoint);
    }

    public static boolean isPointInCone(Vec3d start, Vec3d normDirection, double radius, double length, Vec3d relativePoint) {
        return Utils.isPointInCone(start, normDirection, radius, length, 0.0f, relativePoint);
    }

    public static boolean isPointInConeByAngle(Vec3d start, Vec3d normDirection, float aperture, double length, float truncationLength, Vec3d relativePoint) {
        return Utils.isPointInCone(start, normDirection, Math.tan(aperture / 2.0f) * length, length, truncationLength, relativePoint);
    }

    public static boolean isPointInCone(Vec3d start, Vec3d normDirection, double radius, double length, float truncationLength, Vec3d relativePoint) {
        double projectedDist = relativePoint.dotProduct(normDirection);
        if (projectedDist < (double)truncationLength || projectedDist > length) {
            return false;
        }
        double radiusAtDist = projectedDist / length * radius;
        Vec3d orthVec = relativePoint.subtract(normDirection.scale(projectedDist));
        return orthVec.lengthSquared() < radiusAtDist * radiusAtDist;
    }

    public static boolean isPointInTriangle(Vec3d tA, Vec3d tB, Vec3d tC, Vec3d point) {
        Vec3d v0 = tC.subtract(tA);
        Vec3d v1 = tB.subtract(tA);
        Vec3d v2 = point.subtract(tA);
        return Utils.isPointInTriangle(v0, v1, v2);
    }

    private static boolean isPointInTriangle(Vec3d leg0, Vec3d leg1, Vec3d targetVec) {
        double dot00 = leg0.dotProduct(leg0);
        double dot01 = leg0.dotProduct(leg1);
        double dot02 = leg0.dotProduct(targetVec);
        double dot11 = leg1.dotProduct(leg1);
        double dot12 = leg1.dotProduct(targetVec);
        double invDenom = 1.0 / (dot00 * dot11 - dot01 * dot01);
        double u = (dot11 * dot02 - dot01 * dot12) * invDenom;
        double v = (dot00 * dot12 - dot01 * dot02) * invDenom;
        return u >= 0.0 && v >= 0.0 && u + v < 1.0;
    }

    private static Vec3d getVectorForRotation(float pitch, float yaw) {
        float f = MathHelper.cos((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.sin((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.cos((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = MathHelper.sin((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3d((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public static boolean isHammer(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        return stack.getItem().getToolClasses(stack).contains("IE_HAMMER");
    }

    public static boolean canBlockDamageSource(EntityLivingBase entity, DamageSource damageSourceIn) {
        Vec3d vec3d;
        if (!damageSourceIn.isUnblockable() && entity.isActiveItemStackBlocking() && (vec3d = damageSourceIn.getDamageLocation()) != null) {
            Vec3d vec3d1 = entity.getLook(1.0f);
            Vec3d vec3d2 = vec3d.subtractReverse(entity.getPositionVector()).normalize();
            vec3d2 = new Vec3d(vec3d2.x, 0.0, vec3d2.z);
            if (vec3d2.dotProduct(vec3d1) < 0.0) {
                return true;
            }
        }
        return false;
    }

    public static Vec3d getFlowVector(World world, BlockPos pos) {
        IBlockState state = world.getBlockState(pos);
        if (state.getBlock() instanceof BlockFluidBase) {
            return ((BlockFluidBase)state.getBlock()).getFlowVector((IBlockAccess)world, pos);
        }
        if (!(state.getBlock() instanceof BlockLiquid)) {
            return new Vec3d(0.0, 0.0, 0.0);
        }
        BlockLiquid block = (BlockLiquid)state.getBlock();
        Vec3d vec3 = new Vec3d(0.0, 0.0, 0.0);
        Material mat = state.getMaterial();
        int i = Utils.getEffectiveFlowDecay((IBlockAccess)world, pos, mat);
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos blockpos = pos.offset(enumfacing);
            int j = Utils.getEffectiveFlowDecay((IBlockAccess)world, blockpos, mat);
            if (j < 0) {
                if (world.getBlockState(blockpos).getMaterial().blocksMovement() || (j = Utils.getEffectiveFlowDecay((IBlockAccess)world, blockpos.down(), mat)) < 0) continue;
                int k = j - (i - 8);
                vec3 = vec3.addVector((double)((blockpos.getX() - pos.getX()) * k), (double)((blockpos.getY() - pos.getY()) * k), (double)((blockpos.getZ() - pos.getZ()) * k));
                continue;
            }
            if (j < 0) continue;
            int l = j - i;
            vec3 = vec3.addVector((double)((blockpos.getX() - pos.getX()) * l), (double)((blockpos.getY() - pos.getY()) * l), (double)((blockpos.getZ() - pos.getZ()) * l));
        }
        if ((Integer)state.getValue((IProperty)BlockLiquid.LEVEL) >= 8) {
            for (EnumFacing enumfacing1 : EnumFacing.Plane.HORIZONTAL) {
                BlockPos blockpos1 = pos.offset(enumfacing1);
                if (!block.causesDownwardCurrent((IBlockAccess)world, blockpos1, enumfacing1) && !block.causesDownwardCurrent((IBlockAccess)world, blockpos1.up(), enumfacing1)) continue;
                vec3 = vec3.normalize().addVector(0.0, -6.0, 0.0);
                break;
            }
        }
        return vec3.normalize();
    }

    static int getEffectiveFlowDecay(IBlockAccess world, BlockPos pos, Material mat) {
        IBlockState state = world.getBlockState(pos);
        if (state.getMaterial() != mat) {
            return -1;
        }
        int l = state.getBlock().getMetaFromState(state);
        if (l >= 8) {
            l = 0;
        }
        return l;
    }

    public static Vec3d addVectors(Vec3d vec0, Vec3d vec1) {
        return vec0.addVector(vec1.x, vec1.y, vec1.z);
    }

    public static double minInArray(double ... f) {
        if (f.length < 1) {
            return 0.0;
        }
        double min = f[0];
        for (int i = 1; i < f.length; ++i) {
            min = Math.min(min, f[i]);
        }
        return min;
    }

    public static double maxInArray(double ... f) {
        if (f.length < 1) {
            return 0.0;
        }
        double max = f[0];
        for (int i = 1; i < f.length; ++i) {
            max = Math.max(max, f[i]);
        }
        return max;
    }

    public static boolean isVecInEntityHead(EntityLivingBase entity, Vec3d vec) {
        if (entity.height / entity.width < 2.0f) {
            return false;
        }
        double d = vec.y - (entity.posY + (double)entity.getEyeHeight());
        return Math.abs(d) < 0.25;
    }

    public static void unlockIEAdvancement(EntityPlayer player, String name) {
        if (player instanceof EntityPlayerMP) {
            PlayerAdvancements advancements = ((EntityPlayerMP)player).getAdvancements();
            AdvancementManager manager = ((WorldServer)player.getEntityWorld()).getAdvancementManager();
            Advancement advancement = manager.getAdvancement(new ResourceLocation("immersiveengineering", name));
            if (advancement != null) {
                advancements.grantCriterion(advancement, "code_trigger");
            }
        }
    }

    public static NBTTagCompound getRandomFireworkExplosion(Random rand, int preType) {
        int type;
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound expl = new NBTTagCompound();
        expl.setBoolean("Flicker", true);
        expl.setBoolean("Trail", true);
        int[] colors = new int[rand.nextInt(8) + 1];
        for (int i = 0; i < colors.length; ++i) {
            int j = rand.nextInt(11) + 1;
            if (j > 2) {
                ++j;
            }
            if (j > 6) {
                j += 2;
            }
            colors[i] = ItemDye.DYE_COLORS[j];
        }
        expl.setIntArray("Colors", colors);
        int n = type = preType >= 0 ? preType : rand.nextInt(4);
        if (preType < 0 && type == 3) {
            type = 4;
        }
        expl.setByte("Type", (byte)type);
        NBTTagList list = new NBTTagList();
        list.appendTag((NBTBase)expl);
        tag.setTag("Explosions", (NBTBase)list);
        return tag;
    }

    public static FluidStack drainFluidBlock(World world, BlockPos pos, boolean doDrain) {
        Block b = world.getBlockState(pos).getBlock();
        Fluid f = FluidRegistry.lookupFluidForBlock((Block)b);
        if (f != null) {
            if (b instanceof IFluidBlock) {
                if (((IFluidBlock)b).canDrain(world, pos)) {
                    return ((IFluidBlock)b).drain(world, pos, doDrain);
                }
                return null;
            }
            if (b.getMetaFromState(world.getBlockState(pos)) == 0) {
                if (doDrain) {
                    world.setBlockToAir(pos);
                }
                return new FluidStack(f, 1000);
            }
            return null;
        }
        return null;
    }

    public static Fluid getRelatedFluid(World w, BlockPos pos) {
        Block b = w.getBlockState(pos).getBlock();
        return FluidRegistry.lookupFluidForBlock((Block)b);
    }

    public static boolean placeFluidBlock(World world, BlockPos pos, FluidStack fluid) {
        boolean canPlace;
        if (fluid == null || fluid.getFluid() == null) {
            return false;
        }
        IBlockState state = world.getBlockState(pos);
        Block b = state.getBlock();
        Block fluidBlock = fluid.getFluid().getBlock();
        if (Blocks.WATER.equals(fluidBlock)) {
            fluidBlock = Blocks.FLOWING_WATER;
        } else if (Blocks.LAVA.equals(fluidBlock)) {
            fluidBlock = Blocks.FLOWING_LAVA;
        }
        boolean bl = canPlace = b == null || b.isAir(state, (IBlockAccess)world, pos) || b.isReplaceable((IBlockAccess)world, pos);
        if (fluidBlock != null && canPlace && fluid.amount >= 1000) {
            boolean placed = false;
            if (fluidBlock instanceof BlockFluidBase) {
                BlockFluidBase blockFluid = (BlockFluidBase)fluidBlock;
                placed = world.setBlockState(pos, fluidBlock.getStateFromMeta(blockFluid.getMaxRenderHeightMeta()));
            } else {
                placed = world.setBlockState(pos, fluidBlock.getDefaultState());
            }
            if (placed) {
                fluid.amount -= 1000;
            }
            return placed;
        }
        return false;
    }

    public static IBlockState getStateFromItemStack(ItemStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        Block block = Utils.getBlockFromItem(stack.getItem());
        if (block != null) {
            return block.getStateFromMeta(stack.getItemDamage());
        }
        return null;
    }

    public static Block getBlockFromItem(Item item) {
        if (item == Items.CAULDRON) {
            return Blocks.CAULDRON;
        }
        return Block.getBlockFromItem((Item)item);
    }

    public static boolean canInsertStackIntoInventory(TileEntity inventory, ItemStack stack, EnumFacing side) {
        IItemHandler handler;
        ItemStack temp;
        return !stack.isEmpty() && inventory != null && inventory.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) && ((temp = ItemHandlerHelper.insertItem((IItemHandler)(handler = (IItemHandler)inventory.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)), (ItemStack)stack.copy(), (boolean)true)).isEmpty() || temp.getCount() < stack.getCount());
    }

    public static ItemStack insertStackIntoInventory(TileEntity inventory, ItemStack stack, EnumFacing side) {
        IItemHandler handler;
        ItemStack temp;
        if (!stack.isEmpty() && inventory != null && inventory.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) && ((temp = ItemHandlerHelper.insertItem((IItemHandler)(handler = (IItemHandler)inventory.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)), (ItemStack)stack.copy(), (boolean)true)).isEmpty() || temp.getCount() < stack.getCount())) {
            return ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false);
        }
        return stack;
    }

    public static ItemStack insertStackIntoInventory(TileEntity inventory, ItemStack stack, EnumFacing side, boolean simulate) {
        if (inventory != null && !stack.isEmpty() && inventory.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            IItemHandler handler = (IItemHandler)inventory.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
            return ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack.copy(), (boolean)simulate);
        }
        return stack;
    }

    public static void dropStackAtPos(World world, BlockPos pos, ItemStack stack, EnumFacing facing) {
        if (!stack.isEmpty()) {
            EntityItem ei = new EntityItem(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, stack.copy());
            ei.motionY = 0.025000000372529;
            if (facing != null) {
                ei.motionX = 0.075f * (float)facing.getFrontOffsetX();
                ei.motionZ = 0.075f * (float)facing.getFrontOffsetZ();
            }
            world.spawnEntity((Entity)ei);
        }
    }

    public static void dropStackAtPos(World world, BlockPos pos, ItemStack stack) {
        Utils.dropStackAtPos(world, pos, stack, null);
    }

    public static ItemStack addToEmptyInventorySlot(IInventory inventory, int slot, ItemStack stack) {
        if (!inventory.isItemValidForSlot(slot, stack)) {
            return stack;
        }
        int stackLimit = inventory.getInventoryStackLimit();
        inventory.setInventorySlotContents(slot, Utils.copyStackWithAmount(stack, Math.min(stack.getCount(), stackLimit)));
        return stackLimit >= stack.getCount() ? ItemStack.EMPTY : stack.splitStack(stack.getCount() - stackLimit);
    }

    public static ItemStack addToOccupiedSlot(IInventory inventory, int slot, ItemStack stack, ItemStack existingStack) {
        int stackLimit = Math.min(inventory.getInventoryStackLimit(), stack.getMaxStackSize());
        if (stack.getCount() + existingStack.getCount() > stackLimit) {
            int stackDiff = stackLimit - existingStack.getCount();
            existingStack.setCount(stackLimit);
            stack.shrink(stackDiff);
            inventory.setInventorySlotContents(slot, existingStack);
            return stack;
        }
        existingStack.grow(Math.min(stack.getCount(), stackLimit));
        inventory.setInventorySlotContents(slot, existingStack);
        return stackLimit >= stack.getCount() ? ItemStack.EMPTY : stack.splitStack(stack.getCount() - stackLimit);
    }

    public static ItemStack fillFluidContainer(IFluidHandler handler, ItemStack containerIn, ItemStack containerOut, @Nullable EntityPlayer player) {
        FluidActionResult result;
        if (containerIn == null || containerIn.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (containerIn.hasTagCompound() && containerIn.getTagCompound().hasNoTags()) {
            containerIn.setTagCompound(null);
        }
        if ((result = FluidUtil.tryFillContainer((ItemStack)containerIn, (IFluidHandler)handler, (int)Integer.MAX_VALUE, (EntityPlayer)player, (boolean)false)).isSuccess()) {
            ItemStack full = result.getResult();
            if (containerOut.isEmpty() || OreDictionary.itemMatches((ItemStack)containerOut, (ItemStack)full, (boolean)true)) {
                if (!containerOut.isEmpty() && containerOut.getCount() + full.getCount() > containerOut.getMaxStackSize()) {
                    return ItemStack.EMPTY;
                }
                result = FluidUtil.tryFillContainer((ItemStack)containerIn, (IFluidHandler)handler, (int)Integer.MAX_VALUE, (EntityPlayer)player, (boolean)true);
                if (result.isSuccess()) {
                    return result.getResult();
                }
            }
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack drainFluidContainer(IFluidHandler handler, ItemStack containerIn, ItemStack containerOut, @Nullable EntityPlayer player) {
        FluidActionResult result;
        if (containerIn == null || containerIn.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (containerIn.hasTagCompound() && containerIn.getTagCompound().hasNoTags()) {
            containerIn.setTagCompound(null);
        }
        if ((result = FluidUtil.tryEmptyContainer((ItemStack)containerIn, (IFluidHandler)handler, (int)Integer.MAX_VALUE, (EntityPlayer)player, (boolean)false)).isSuccess()) {
            ItemStack empty = result.getResult();
            if (containerOut.isEmpty() || OreDictionary.itemMatches((ItemStack)containerOut, (ItemStack)empty, (boolean)true)) {
                if (!containerOut.isEmpty() && containerOut.getCount() + empty.getCount() > containerOut.getMaxStackSize()) {
                    return ItemStack.EMPTY;
                }
                result = FluidUtil.tryEmptyContainer((ItemStack)containerIn, (IFluidHandler)handler, (int)Integer.MAX_VALUE, (EntityPlayer)player, (boolean)true);
                if (result.isSuccess()) {
                    return result.getResult();
                }
            }
        }
        return ItemStack.EMPTY;
    }

    public static boolean isFluidRelatedItemStack(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        return stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
    }

    public static IRecipe findRecipe(InventoryCrafting crafting, World world) {
        return CraftingManager.findMatchingRecipe((InventoryCrafting)crafting, (World)world);
    }

    public static NonNullList<ItemStack> createNonNullItemStackListFromArray(ItemStack[] stacks) {
        NonNullList list = NonNullList.withSize((int)stacks.length, (Object)ItemStack.EMPTY);
        for (int i = 0; i < stacks.length; ++i) {
            list.set(i, (Object)stacks[i]);
        }
        return list;
    }

    public static NonNullList<ItemStack> createNonNullItemStackListFromItemStack(ItemStack stack) {
        NonNullList list = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
        list.set(0, (Object)stack);
        return list;
    }

    public static HashSet<BlockPos> rayTrace(Vec3d start, Vec3d end, World world) {
        Vec3d tmp;
        HashSet<BlockPos> ret = new HashSet<BlockPos>();
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        if (start.x > end.x) {
            Vec3d tmp2 = start;
            start = end;
            end = tmp2;
        }
        double min = start.x;
        double dif = end.x - min;
        double lengthAdd = Math.ceil(min) - start.x;
        Vec3d mov = start.subtract(end);
        if (mov.x != 0.0) {
            mov = Utils.scalarProd(mov, 1.0 / mov.x);
            Utils.ray(dif, mov, start, lengthAdd, ret, world, checked, Blocks.DIAMOND_ORE);
        }
        if (mov.y != 0.0) {
            if (start.y > end.y) {
                tmp = start;
                start = end;
                end = tmp;
            }
            min = start.y;
            dif = end.y - min;
            lengthAdd = Math.ceil(min) - start.y;
            mov = start.subtract(end);
            mov = Utils.scalarProd(mov, 1.0 / mov.y);
            Utils.ray(dif, mov, start, lengthAdd, ret, world, checked, Blocks.IRON_ORE);
        }
        if (mov.z != 0.0) {
            if (start.z > end.z) {
                tmp = start;
                start = end;
                end = tmp;
            }
            min = start.z;
            dif = end.z - min;
            lengthAdd = Math.ceil(min) - start.z;
            mov = start.subtract(end);
            mov = Utils.scalarProd(mov, 1.0 / mov.z);
            Utils.ray(dif, mov, start, lengthAdd, ret, world, checked, Blocks.GOLD_ORE);
        }
        return ret;
    }

    private static void ray(double dif, Vec3d mov, Vec3d start, double lengthAdd, HashSet<BlockPos> ret, World world, HashSet<BlockPos> checked, Block tmp) {
        boolean place = false;
        double standartOff = 0.0625;
        int i = 0;
        while ((double)i < dif) {
            Block b;
            IBlockState state;
            Vec3d pos = Utils.addVectors(start, Utils.scalarProd(mov, (double)i + lengthAdd + standartOff));
            Vec3d posNext = Utils.addVectors(start, Utils.scalarProd(mov, (double)(i + 1) + lengthAdd + standartOff));
            Vec3d posPrev = Utils.addVectors(start, Utils.scalarProd(mov, (double)i + lengthAdd - standartOff));
            Vec3d posVeryPrev = Utils.addVectors(start, Utils.scalarProd(mov, (double)(i - 1) + lengthAdd - standartOff));
            BlockPos blockPos = new BlockPos((int)Math.floor(pos.x), (int)Math.floor(pos.y), (int)Math.floor(pos.z));
            if (!checked.contains(blockPos) && (double)i + lengthAdd + standartOff < dif) {
                state = world.getBlockState(blockPos);
                b = state.getBlock();
                if (b.canCollideCheck(state, false) && state.collisionRayTrace(world, blockPos, pos, posNext) != null) {
                    ret.add(blockPos);
                }
                checked.add(blockPos);
            }
            if (!checked.contains(blockPos = new BlockPos((int)Math.floor(posPrev.x), (int)Math.floor(posPrev.y), (int)Math.floor(posPrev.z))) && (double)i + lengthAdd - standartOff < dif) {
                state = world.getBlockState(blockPos);
                b = state.getBlock();
                if (b.canCollideCheck(state, false) && state.collisionRayTrace(world, blockPos, posVeryPrev, posPrev) != null) {
                    ret.add(blockPos);
                }
                checked.add(blockPos);
            }
            ++i;
        }
    }

    public static Vec3d scalarProd(Vec3d v, double s) {
        return new Vec3d(v.x * s, v.y * s, v.z * s);
    }

    public static BlockPos rayTraceForFirst(Vec3d start, Vec3d end, World w, Set<BlockPos> ignore) {
        HashSet<BlockPos> trace = Utils.rayTrace(start, end, w);
        for (BlockPos cc : ignore) {
            trace.remove(cc);
        }
        if (start.x != end.x) {
            trace = Utils.findMinOrMax(trace, start.x > end.x, 0);
        }
        if (start.y != end.y) {
            trace = Utils.findMinOrMax(trace, start.y > end.y, 0);
        }
        if (start.z != end.z) {
            trace = Utils.findMinOrMax(trace, start.z > end.z, 0);
        }
        if (trace.size() > 0) {
            BlockPos ret = trace.iterator().next();
            return ret;
        }
        return null;
    }

    public static HashSet<BlockPos> findMinOrMax(HashSet<BlockPos> in, boolean max, int coord) {
        int curr;
        HashSet<BlockPos> ret = new HashSet<BlockPos>();
        int currMinMax = max ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        for (BlockPos cc : in) {
            curr = coord == 0 ? cc.getX() : (coord == 1 ? cc.getY() : cc.getY());
            if (!(max ^ curr < currMinMax)) continue;
            currMinMax = curr;
        }
        for (BlockPos cc : in) {
            curr = coord == 0 ? cc.getX() : (coord == 1 ? cc.getY() : cc.getZ());
            if (curr != currMinMax) continue;
            ret.add(cc);
        }
        return ret;
    }

    public static TileEntity getExistingTileEntity(World world, BlockPos pos) {
        if (world.isBlockLoaded(pos)) {
            return world.getTileEntity(pos);
        }
        return null;
    }

    public static NonNullList<ItemStack> readInventory(NBTTagList nbt, int size) {
        NonNullList inv = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
        int max = nbt.tagCount();
        for (int i = 0; i < max; ++i) {
            NBTTagCompound itemTag = nbt.getCompoundTagAt(i);
            int slot = itemTag.getByte("Slot") & 0xFF;
            if (slot < 0 || slot >= size) continue;
            inv.set(slot, (Object)new ItemStack(itemTag));
        }
        return inv;
    }

    public static NBTTagList writeInventory(ItemStack[] inv) {
        NBTTagList invList = new NBTTagList();
        for (int i = 0; i < inv.length; ++i) {
            if (inv[i].isEmpty()) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.setByte("Slot", (byte)i);
            inv[i].writeToNBT(itemTag);
            invList.appendTag((NBTBase)itemTag);
        }
        return invList;
    }

    public static NBTTagList writeInventory(Collection<ItemStack> inv) {
        NBTTagList invList = new NBTTagList();
        byte slot = 0;
        for (ItemStack s : inv) {
            if (!s.isEmpty()) {
                NBTTagCompound itemTag = new NBTTagCompound();
                itemTag.setByte("Slot", slot);
                s.writeToNBT(itemTag);
                invList.appendTag((NBTBase)itemTag);
            }
            slot = (byte)(slot + 1);
        }
        return invList;
    }

    public static NonNullList<ItemStack> loadItemStacksFromNBT(NBTBase nbt) {
        NonNullList itemStacks = NonNullList.create();
        if (nbt instanceof NBTTagCompound) {
            ItemStack stack = new ItemStack((NBTTagCompound)nbt);
            itemStacks.add((Object)stack);
            return itemStacks;
        }
        if (nbt instanceof NBTTagList) {
            NBTTagList list = (NBTTagList)nbt;
            return Utils.readInventory(list, list.tagCount());
        }
        return itemStacks;
    }

    public static void modifyInvStackSize(NonNullList<ItemStack> inv, int slot, int amount) {
        if (slot >= 0 && slot < inv.size() && !((ItemStack)inv.get(slot)).isEmpty()) {
            ((ItemStack)inv.get(slot)).grow(amount);
            if (((ItemStack)inv.get(slot)).getCount() <= 0) {
                inv.set(slot, (Object)ItemStack.EMPTY);
            }
        }
    }

    public static void shuffleLootItems(List<ItemStack> stacks, int slotAmount, Random rand) {
        ArrayList list = Lists.newArrayList();
        Iterator<ItemStack> iterator = stacks.iterator();
        while (iterator.hasNext()) {
            ItemStack itemstack = iterator.next();
            if (itemstack.getCount() <= 0) {
                iterator.remove();
                continue;
            }
            if (itemstack.getCount() <= 1) continue;
            list.add(itemstack);
            iterator.remove();
        }
        slotAmount -= stacks.size();
        while (slotAmount > 0 && list.size() > 0) {
            ItemStack itemstack2 = (ItemStack)list.remove(MathHelper.getInt((Random)rand, (int)0, (int)(list.size() - 1)));
            int i = MathHelper.getInt((Random)rand, (int)1, (int)(itemstack2.getCount() / 2));
            itemstack2.shrink(i);
            ItemStack itemstack1 = itemstack2.copy();
            itemstack1.setCount(i);
            if (itemstack2.getCount() > 1 && rand.nextBoolean()) {
                list.add(itemstack2);
            } else {
                stacks.add(itemstack2);
            }
            if (itemstack1.getCount() > 1 && rand.nextBoolean()) {
                list.add(itemstack1);
                continue;
            }
            stacks.add(itemstack1);
        }
        stacks.addAll(list);
        Collections.shuffle(stacks, rand);
    }

    public static LootTable loadBuiltinLootTable(ResourceLocation resource, LootTableManager lootTableManager) {
        String s;
        URL url = Utils.class.getResource("/assets/" + resource.getResourceDomain() + "/loot_tables/" + resource.getResourcePath() + ".json");
        if (url == null) {
            return LootTable.EMPTY_LOOT_TABLE;
        }
        try {
            s = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
            return LootTable.EMPTY_LOOT_TABLE;
        }
        try {
            return ForgeHooks.loadLootTable((Gson)GSON_INSTANCE, (ResourceLocation)resource, (String)s, (boolean)false, (LootTableManager)lootTableManager);
        }
        catch (JsonParseException jsonparseexception) {
            jsonparseexception.printStackTrace();
            return LootTable.EMPTY_LOOT_TABLE;
        }
    }

    public static int calcRedstoneFromInventory(IIEInventory inv) {
        if (inv == null) {
            return 0;
        }
        int max = inv.getComparatedSize();
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < max; ++j) {
            ItemStack itemstack = (ItemStack)inv.getInventory().get(j);
            if (itemstack.isEmpty()) continue;
            f += (float)itemstack.getCount() / (float)Math.min(inv.getSlotLimit(j), itemstack.getMaxStackSize());
            ++i;
        }
        return MathHelper.floor((float)((f /= (float)max) * 14.0f)) + (i > 0 ? 1 : 0);
    }

    public static Map<String, Object> saveStack(ItemStack stack) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (!stack.isEmpty()) {
            ret.put("size", stack.getCount());
            ret.put("name", Item.REGISTRY.getNameForObject((Object)stack.getItem()));
            ret.put("nameUnlocalized", stack.getUnlocalizedName());
            ret.put("label", stack.getDisplayName());
            ret.put("damage", stack.getItemDamage());
            ret.put("maxDamage", stack.getMaxDamage());
            ret.put("maxSize", stack.getMaxStackSize());
            ret.put("hasTag", stack.hasTagCompound());
        }
        return ret;
    }

    public static Map<String, Object> saveFluidTank(FluidTank tank) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (tank != null && tank.getFluid() != null) {
            ret.put("name", tank.getFluid().getFluid().getUnlocalizedName());
            ret.put("amount", tank.getFluidAmount());
            ret.put("capacity", tank.getCapacity());
            ret.put("hasTag", tank.getFluid().tag != null);
        }
        return ret;
    }

    public static Map<String, Object> saveFluidStack(FluidStack tank) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (tank != null && tank.getFluid() != null) {
            ret.put("name", tank.getFluid().getUnlocalizedName());
            ret.put("amount", tank.amount);
            ret.put("hasTag", tank.tag != null);
        }
        return ret;
    }

    public static class InventoryCraftingFalse
    extends InventoryCrafting {
        private static final Container nullContainer = new Container(){

            public void onCraftMatrixChanged(IInventory paramIInventory) {
            }

            public boolean canInteractWith(EntityPlayer p_75145_1_) {
                return false;
            }
        };

        public InventoryCraftingFalse(int w, int h) {
            super(nullContainer, w, h);
        }

        public static InventoryCrafting createFilledCraftingInventory(int w, int h, NonNullList<ItemStack> stacks) {
            InventoryCraftingFalse invC = new InventoryCraftingFalse(w, h);
            for (int j = 0; j < w * h; ++j) {
                if (((ItemStack)stacks.get(j)).isEmpty()) continue;
                invC.setInventorySlotContents(j, ((ItemStack)stacks.get(j)).copy());
            }
            return invC;
        }
    }
}

