/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.common.entities.EntitySkylineHook;
import blusunrize.immersiveengineering.common.items.ItemSkyhook;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class SkylineHelper {
    public static ImmersiveNetHandler.Connection getTargetConnection(World world, BlockPos pos, EntityLivingBase living, ImmersiveNetHandler.Connection invalidCon) {
        if (!(world.getTileEntity(pos) instanceof IImmersiveConnectable)) {
            return null;
        }
        Set<ImmersiveNetHandler.Connection> outputs = ImmersiveNetHandler.INSTANCE.getConnections(world, pos);
        if (outputs != null && outputs.size() > 0) {
            Vec3d vec = living.getLookVec();
            vec = vec.normalize();
            ImmersiveNetHandler.Connection line = null;
            for (ImmersiveNetHandler.Connection c : outputs) {
                if (c == null || c.hasSameConnectors(invalidCon)) continue;
                if (line == null) {
                    line = c;
                    continue;
                }
                Vec3d lineVec = new Vec3d((double)(line.end.getX() - line.start.getX()), (double)(line.end.getY() - line.start.getY()), (double)(line.end.getZ() - line.start.getZ())).normalize();
                Vec3d conVec = new Vec3d((double)(c.end.getX() - c.start.getX()), (double)(c.end.getY() - c.start.getY()), (double)(c.end.getZ() - c.start.getZ())).normalize();
                if (!(conVec.distanceTo(vec) < lineVec.distanceTo(vec))) continue;
                line = c;
            }
            return line;
        }
        return null;
    }

    public static EntitySkylineHook spawnHook(EntityPlayer player, TileEntity start, ImmersiveNetHandler.Connection connection) {
        BlockPos cc0 = connection.end == Utils.toCC(start) ? connection.start : connection.end;
        BlockPos cc1 = connection.end == Utils.toCC(start) ? connection.end : connection.start;
        IImmersiveConnectable iicStart = ApiUtils.toIIC(cc1, player.world);
        IImmersiveConnectable iicEnd = ApiUtils.toIIC(cc0, player.world);
        Vec3d vStart = new Vec3d((Vec3i)cc1);
        Vec3d vEnd = new Vec3d((Vec3i)cc0);
        if (iicStart != null) {
            vStart = Utils.addVectors(vStart, iicStart.getConnectionOffset(connection));
        }
        if (iicEnd != null) {
            vEnd = Utils.addVectors(vEnd, iicEnd.getConnectionOffset(connection));
        }
        Vec3d[] steps = SkylineHelper.getConnectionCatenary(connection, vStart, vEnd);
        double dx = steps[0].x - vStart.x;
        double dy = steps[0].y - vStart.y;
        double dz = steps[0].z - vStart.z;
        double d = 1.0;
        EntitySkylineHook hook = new EntitySkylineHook(player.world, vStart.x, vStart.y, vStart.z, connection, cc0, steps);
        float speed = 1.0f;
        if (!player.getActiveItemStack().isEmpty() && player.getActiveItemStack().getItem() instanceof ItemSkyhook) {
            speed = ((ItemSkyhook)player.getActiveItemStack().getItem()).getSkylineSpeed(player.getActiveItemStack());
        }
        Vec3d moveVec = SkylineHelper.getSubMovementVector(vStart, steps[0], speed);
        hook.motionX = moveVec.x;
        hook.motionY = moveVec.y;
        hook.motionZ = moveVec.z;
        if (!player.world.isRemote) {
            player.world.spawnEntity((Entity)hook);
        }
        ItemSkyhook.existingHooks.put(player.getName(), hook);
        player.startRiding((Entity)hook);
        return hook;
    }

    public static Vec3d[] getConnectionCatenary(ImmersiveNetHandler.Connection connection, Vec3d start, Vec3d end) {
        boolean vertical;
        boolean bl = vertical = connection.end.getX() == connection.start.getX() && connection.end.getZ() == connection.start.getZ();
        if (vertical) {
            return new Vec3d[]{new Vec3d(end.x, end.y, end.z)};
        }
        double dx = end.x - start.x;
        double dy = end.y - start.y;
        double dz = end.z - start.z;
        double dw = Math.sqrt(dx * dx + dz * dz);
        double k = Math.sqrt(dx * dx + dy * dy + dz * dz) * connection.cableType.getSlack();
        double l = 0.0;
        for (int limiter = 0; !vertical && limiter < 300; ++limiter) {
            if (!(Math.sinh(l += 0.01) / l >= Math.sqrt(k * k - dy * dy) / dw)) continue;
        }
        double a = dw / 2.0 / l;
        double p = (0.0 + dw - a * Math.log((k + dy) / (k - dy))) * 0.5;
        double q = (dy + 0.0 - k * Math.cosh(l) / Math.sinh(l)) * 0.5;
        int vertices = 16;
        Vec3d[] vex = new Vec3d[vertices];
        for (int i = 0; i < vertices; ++i) {
            float n1 = (float)(i + 1) / (float)vertices;
            double x1 = 0.0 + dx * (double)n1;
            double z1 = 0.0 + dz * (double)n1;
            double y1 = a * Math.cosh((Math.sqrt(x1 * x1 + z1 * z1) - p) / a) + q;
            vex[i] = new Vec3d(start.x + x1, start.y + y1, start.z + z1);
        }
        return vex;
    }

    public static Vec3d getSubMovementVector(Vec3d start, Vec3d target, float speed) {
        Vec3d movementVec = new Vec3d(target.x - start.x, target.y - start.y, target.z - start.z);
        int lPixel = (int)Math.max(1.0, movementVec.lengthVector() / (0.125 * (double)speed));
        return new Vec3d(movementVec.x / (double)lPixel, movementVec.y / (double)lPixel, movementVec.z / (double)lPixel);
    }

    public static boolean isInBlock(EntityPlayer player, World w) {
        BlockPos init = player.getPosition();
        AxisAlignedBB hitbox = player.getEntityBoundingBox();
        hitbox = new AxisAlignedBB(hitbox.minX - 1.0, hitbox.minY - 1.0, hitbox.minZ - 1.0, hitbox.maxX, hitbox.maxY, hitbox.maxZ);
        for (int xOff = 0; xOff < 2; ++xOff) {
            for (int yOff = 0; yOff < 3; ++yOff) {
                for (int zOff = 0; zOff < 2; ++zOff) {
                    Vec3d v = new Vec3d((double)(init.getX() + xOff), (double)(init.getY() + yOff), (double)(init.getZ() + zOff));
                    if (!hitbox.contains(v) || w.isAirBlock(new BlockPos(v))) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

