/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import java.util.HashSet;
import java.util.function.Predicate;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RotationUtil {
    public static HashSet<Predicate<IBlockState>> permittedRotation = new HashSet();
    public static HashSet<Predicate<TileEntity>> permittedTileRotation = new HashSet();

    public static boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        TileEntity tile;
        IBlockState state = world.getBlockState(pos);
        for (Predicate<IBlockState> pred : permittedRotation) {
            if (pred.test(state)) continue;
            return false;
        }
        if (state.getBlock().hasTileEntity(state) && (tile = world.getTileEntity(pos)) != null) {
            for (Predicate<TileEntity> pred : permittedTileRotation) {
                if (pred.test(tile)) continue;
                return false;
            }
        }
        return state.getBlock().rotateBlock(world, pos, axis);
    }

    public static boolean rotateEntity(Entity entity, EntityPlayer player) {
        if (entity instanceof EntityArmorStand) {
            // empty if block
        }
        return false;
    }

    static {
        permittedRotation.add(state -> state.getBlock() != Blocks.PISTON && state.getBlock() != Blocks.STICKY_PISTON || (Boolean)state.getValue((IProperty)BlockPistonBase.EXTENDED) == false);
        permittedRotation.add(state -> state.getBlock() != Blocks.BED);
        permittedRotation.add(state -> state.getBlock() != Blocks.END_PORTAL_FRAME && state.getBlock() != Blocks.SKULL);
        permittedTileRotation.add(tile -> {
            if (tile instanceof TileEntityChest) {
                TileEntityChest chest = (TileEntityChest)tile;
                return chest.adjacentChestXNeg != null || chest.adjacentChestXPos != null || chest.adjacentChestZNeg != null || chest.adjacentChestZPos != null;
            }
            return true;
        });
    }
}

