/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fluids.FluidStack;

public class ItemNBTHelper {
    public static NBTTagCompound getTag(ItemStack stack) {
        if (!stack.hasTagCompound()) {
            stack.setTagCompound(new NBTTagCompound());
        }
        return stack.getTagCompound();
    }

    public static boolean hasTag(ItemStack stack) {
        return stack.hasTagCompound();
    }

    public static boolean hasKey(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) && ItemNBTHelper.getTag(stack).hasKey(key);
    }

    public static void remove(ItemStack stack, String key) {
        if (ItemNBTHelper.hasKey(stack, key)) {
            ItemNBTHelper.getTag(stack).removeTag(key);
            if (ItemNBTHelper.getTag(stack).hasNoTags()) {
                stack.setTagCompound(null);
            }
        }
    }

    public static void setInt(ItemStack stack, String key, int val) {
        ItemNBTHelper.getTag(stack).setInteger(key, val);
    }

    public static void modifyInt(ItemStack stack, String key, int mod) {
        ItemNBTHelper.modifyInt(ItemNBTHelper.getTag(stack), key, mod);
    }

    public static void modifyInt(NBTTagCompound tagCompound, String key, int mod) {
        tagCompound.setInteger(key, tagCompound.getInteger(key) + mod);
    }

    public static int getInt(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? ItemNBTHelper.getTag(stack).getInteger(key) : 0;
    }

    public static void setString(ItemStack stack, String key, String val) {
        ItemNBTHelper.getTag(stack).setString(key, val);
    }

    public static String getString(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? ItemNBTHelper.getTag(stack).getString(key) : "";
    }

    public static void setLong(ItemStack stack, String key, long val) {
        ItemNBTHelper.getTag(stack).setLong(key, val);
    }

    public static long getLong(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? ItemNBTHelper.getTag(stack).getLong(key) : 0L;
    }

    public static void setIntArray(ItemStack stack, String key, int[] val) {
        ItemNBTHelper.getTag(stack).setIntArray(key, val);
    }

    public static int[] getIntArray(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? ItemNBTHelper.getTag(stack).getIntArray(key) : new int[]{};
    }

    public static void setFloat(ItemStack stack, String key, float val) {
        ItemNBTHelper.getTag(stack).setFloat(key, val);
    }

    public static void modifyFloat(NBTTagCompound tagCompound, String key, float mod) {
        tagCompound.setFloat(key, tagCompound.getFloat(key) + mod);
    }

    public static float getFloat(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? ItemNBTHelper.getTag(stack).getFloat(key) : 0.0f;
    }

    public static void setBoolean(ItemStack stack, String key, boolean val) {
        ItemNBTHelper.getTag(stack).setBoolean(key, val);
    }

    public static boolean getBoolean(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) && ItemNBTHelper.getTag(stack).getBoolean(key);
    }

    public static void setTagCompound(ItemStack stack, String key, NBTTagCompound val) {
        ItemNBTHelper.getTag(stack).setTag(key, (NBTBase)val);
    }

    public static NBTTagCompound getTagCompound(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? ItemNBTHelper.getTag(stack).getCompoundTag(key) : new NBTTagCompound();
    }

    public static void setFluidStack(ItemStack stack, String key, FluidStack val) {
        if (val != null && val.getFluid() != null) {
            ItemNBTHelper.setTagCompound(stack, key, val.writeToNBT(new NBTTagCompound()));
        } else {
            ItemNBTHelper.remove(stack, key);
        }
    }

    public static FluidStack getFluidStack(ItemStack stack, String key) {
        if (ItemNBTHelper.hasTag(stack)) {
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)ItemNBTHelper.getTagCompound(stack, key));
        }
        return null;
    }

    public static void setItemStack(ItemStack stack, String key, ItemStack val) {
        ItemNBTHelper.getTag(stack).setTag(key, (NBTBase)val.writeToNBT(new NBTTagCompound()));
    }

    public static ItemStack getItemStack(ItemStack stack, String key) {
        if (ItemNBTHelper.hasTag(stack) && ItemNBTHelper.getTag(stack).hasKey(key)) {
            return new ItemStack(ItemNBTHelper.getTagCompound(stack, key));
        }
        return ItemStack.EMPTY;
    }

    public static void setLore(ItemStack stack, String ... lore) {
        NBTTagCompound displayTag = ItemNBTHelper.getTagCompound(stack, "display");
        NBTTagList list = new NBTTagList();
        for (String s : lore) {
            list.appendTag((NBTBase)new NBTTagString(s));
        }
        displayTag.setTag("Lore", (NBTBase)list);
        ItemNBTHelper.setTagCompound(stack, "display", displayTag);
    }

    public static int insertFluxItem(ItemStack container, int energy, int maxEnergy, boolean simulate) {
        int stored = ItemNBTHelper.getFluxStoredInItem(container);
        int accepted = Math.min(energy, maxEnergy - stored);
        if (!simulate) {
            ItemNBTHelper.setInt(container, "energy", stored += accepted);
        }
        return accepted;
    }

    public static int extractFluxFromItem(ItemStack container, int energy, boolean simulate) {
        int stored = ItemNBTHelper.getFluxStoredInItem(container);
        int extracted = Math.min(energy, stored);
        if (!simulate) {
            ItemNBTHelper.setInt(container, "energy", stored -= extracted);
        }
        return extracted;
    }

    public static int getFluxStoredInItem(ItemStack container) {
        return ItemNBTHelper.getInt(container, "energy");
    }

    public static ItemStack stackWithData(ItemStack stack, Object ... data) {
        assert (data.length % 2 == 0);
        for (int i = 0; i < data.length / 2; ++i) {
            Object key = data[i];
            Object value = data[i + 1];
            if (!(key instanceof String)) continue;
            if (value instanceof Boolean) {
                ItemNBTHelper.setBoolean(stack, (String)key, (Boolean)value);
                continue;
            }
            if (value instanceof Integer) {
                ItemNBTHelper.setInt(stack, (String)key, (Integer)value);
                continue;
            }
            if (value instanceof Float) {
                ItemNBTHelper.setFloat(stack, (String)key, ((Float)value).floatValue());
                continue;
            }
            if (value instanceof Long) {
                ItemNBTHelper.setLong(stack, (String)key, (Long)value);
                continue;
            }
            if (value instanceof String) {
                ItemNBTHelper.setString(stack, (String)key, (String)value);
                continue;
            }
            if (value instanceof NBTTagCompound) {
                ItemNBTHelper.setTagCompound(stack, (String)key, (NBTTagCompound)value);
                continue;
            }
            if (value instanceof int[]) {
                ItemNBTHelper.setIntArray(stack, (String)key, (int[])value);
                continue;
            }
            if (value instanceof ItemStack) {
                ItemNBTHelper.setItemStack(stack, (String)key, (ItemStack)value);
                continue;
            }
            if (!(value instanceof FluidStack)) continue;
            ItemNBTHelper.setFluidStack(stack, (String)key, (FluidStack)value);
        }
        return stack;
    }

    public static NBTTagCompound combineTags(NBTTagCompound target, NBTTagCompound add, Pattern pattern) {
        if (target == null || target.hasNoTags()) {
            return add.copy();
        }
        for (String key : add.getKeySet()) {
            if (pattern != null && !pattern.matcher(key).matches()) continue;
            if (!target.hasKey(key)) {
                target.setTag(key, add.getTag(key));
                continue;
            }
            switch (add.getTagId(key)) {
                case 1: {
                    target.setByte(key, (byte)(target.getByte(key) + add.getByte(key)));
                    break;
                }
                case 2: {
                    target.setShort(key, (short)(target.getShort(key) + add.getShort(key)));
                    break;
                }
                case 3: {
                    target.setInteger(key, target.getInteger(key) + add.getInteger(key));
                    break;
                }
                case 4: {
                    target.setLong(key, target.getLong(key) + add.getLong(key));
                    break;
                }
                case 5: {
                    target.setFloat(key, target.getFloat(key) + add.getFloat(key));
                    break;
                }
                case 6: {
                    target.setDouble(key, target.getDouble(key) + add.getDouble(key));
                    break;
                }
                case 7: {
                    byte[] bytesTarget = target.getByteArray(key);
                    byte[] bytesAdd = add.getByteArray(key);
                    byte[] bytes = new byte[bytesTarget.length + bytesAdd.length];
                    System.arraycopy(bytesTarget, 0, bytes, 0, bytesTarget.length);
                    System.arraycopy(bytesAdd, 0, bytes, bytesTarget.length, bytesAdd.length);
                    target.setByteArray(key, bytes);
                    break;
                }
                case 8: {
                    target.setString(key, target.getString(key) + add.getString(key));
                    break;
                }
                case 9: {
                    NBTTagList listTarget = (NBTTagList)target.getTag(key);
                    NBTTagList listAdd = (NBTTagList)add.getTag(key);
                    for (int i = 0; i < listAdd.tagCount(); ++i) {
                        listTarget.appendTag(listAdd.get(i));
                    }
                    target.setTag(key, (NBTBase)listTarget);
                    break;
                }
                case 10: {
                    ItemNBTHelper.combineTags(target.getCompoundTag(key), add.getCompoundTag(key), null);
                    break;
                }
                case 11: {
                    int[] intsTarget = target.getIntArray(key);
                    int[] intsAdd = add.getIntArray(key);
                    int[] ints = new int[intsTarget.length + intsAdd.length];
                    System.arraycopy(intsTarget, 0, ints, 0, intsTarget.length);
                    System.arraycopy(intsAdd, 0, ints, intsTarget.length, intsAdd.length);
                    target.setIntArray(key, ints);
                }
            }
        }
        return target;
    }
}

