/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class IEPotions {
    public static Potion flammable;
    public static Potion slippery;
    public static Potion conductive;
    public static Potion sticky;
    public static Potion stunned;
    public static Potion concreteFeet;
    public static Potion flashed;

    public static void init() {
        flammable = new IEPotion(new ResourceLocation("immersiveengineering", "flammable"), true, 9387807, 0, false, 0, true, true).setPotionName("immersiveengineering.potion.flammable");
        slippery = new IEPotion(new ResourceLocation("immersiveengineering", "slippery"), true, 1511427, 0, false, 1, true, true).setPotionName("immersiveengineering.potion.slippery");
        conductive = new IEPotion(new ResourceLocation("immersiveengineering", "conductive"), true, 0x690000, 0, false, 2, true, true).setPotionName("immersiveengineering.potion.conductive");
        sticky = new IEPotion(new ResourceLocation("immersiveengineering", "sticky"), true, 10250240, 0, false, 3, true, true).setPotionName("immersiveengineering.potion.sticky").registerPotionAttributeModifier(SharedMonsterAttributes.MOVEMENT_SPEED, Utils.generateNewUUID().toString(), -0.5000000029802323, 2);
        stunned = new IEPotion(new ResourceLocation("immersiveengineering", "stunned"), true, 6441624, 0, false, 4, true, true).setPotionName("immersiveengineering.potion.stunned");
        concreteFeet = new IEPotion(new ResourceLocation("immersiveengineering", "concreteFeet"), true, 6441624, 0, false, 5, true, true).setPotionName("immersiveengineering.potion.concreteFeet").registerPotionAttributeModifier(SharedMonsterAttributes.MOVEMENT_SPEED, Utils.generateNewUUID().toString(), -2.0, 2);
        flashed = new IEPotion(new ResourceLocation("immersiveengineering", "flashed"), true, 6441624, 0, false, 6, true, true).setPotionName("immersiveengineering.potion.flashed").registerPotionAttributeModifier(SharedMonsterAttributes.MOVEMENT_SPEED, Utils.generateNewUUID().toString(), (double)-0.15f, 2);
        IEApi.potions = new Potion[]{flammable, slippery, conductive, sticky, stunned, concreteFeet, flashed};
    }

    public static class IEPotion
    extends Potion {
        static ResourceLocation tex = new ResourceLocation("immersiveengineering", "textures/gui/potioneffects.png");
        final int tickrate;
        final boolean halfTickRateWIthAmplifier;
        boolean showInInventory = true;
        boolean showInHud = true;

        public IEPotion(ResourceLocation resource, boolean isBad, int colour, int tick, boolean halveTick, int icon, boolean showInInventory, boolean showInHud) {
            super(isBad, colour);
            this.setPotionName("potion." + resource.getResourcePath());
            this.showInInventory = showInInventory;
            this.showInHud = showInHud;
            this.tickrate = tick;
            this.halfTickRateWIthAmplifier = halveTick;
            this.setIconIndex(icon % 8, icon / 8);
            ForgeRegistries.POTIONS.register(this.setRegistryName(resource));
        }

        public boolean shouldRender(PotionEffect effect) {
            return this.showInInventory;
        }

        public boolean shouldRenderInvText(PotionEffect effect) {
            return this.showInInventory;
        }

        public boolean shouldRenderHUD(PotionEffect effect) {
            return this.showInHud;
        }

        public int getStatusIconIndex() {
            Minecraft.getMinecraft().getTextureManager().bindTexture(tex);
            return super.getStatusIconIndex();
        }

        public boolean isReady(int duration, int amplifier) {
            if (this.tickrate < 0) {
                return false;
            }
            int k = this.tickrate >> amplifier;
            return k <= 0 || duration % k == 0;
        }

        public void performEffect(EntityLivingBase living, int amplifier) {
            PotionEffect effect;
            IBlockState state;
            if (this == slippery) {
                EntityEquipmentSlot hand;
                if (living.onGround) {
                    living.moveRelative(0.0f, 0.0f, 1.0f, 0.005f);
                }
                EntityEquipmentSlot entityEquipmentSlot = hand = living.getRNG().nextBoolean() ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND;
                if (!living.world.isRemote && living.getRNG().nextInt(300) == 0 && !living.getItemStackFromSlot(hand).isEmpty()) {
                    EntityItem dropped = living.entityDropItem(living.getItemStackFromSlot(hand).copy(), 1.0f);
                    dropped.setPickupDelay(20);
                    living.setItemStackToSlot(hand, null);
                }
            } else if (this == concreteFeet && !living.world.isRemote && (state = living.world.getBlockState(living.getPosition())).getBlock() != IEContent.blockStoneDecoration && state.getBlock() != IEContent.blockStoneDecorationSlabs && state.getBlock() != IEContent.blockStoneDevice && (effect = living.getActivePotionEffect((Potion)this)) != null) {
                effect.duration = 0;
            }
        }
    }
}

