/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChance;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraft.world.storage.loot.functions.SetNBT;

public class IELootEntry
extends LootEntryItem {
    public static LootFunction blueprintRename;
    ItemStack stack;

    public IELootEntry(String entryName, @Nonnull ItemStack stack, int weight, int quality, LootFunction ... functions) {
        super(stack.getItem(), weight, quality, IELootEntry.buildFunctions(stack, functions), new LootCondition[0], entryName);
        this.stack = stack;
    }

    static LootFunction[] buildFunctions(ItemStack stack, LootFunction[] functions) {
        ArrayList<Object> totalFunctions = new ArrayList<Object>();
        for (LootFunction f : functions) {
            totalFunctions.add(f);
        }
        if (stack.getMetadata() != 0) {
            totalFunctions.add(new SetMetadata(new LootCondition[0], new RandomValueRange((float)stack.getMetadata(), (float)stack.getMetadata())));
        }
        if (stack.getCount() > 1) {
            totalFunctions.add(new SetCount(new LootCondition[0], new RandomValueRange((float)stack.getMetadata(), (float)stack.getMetadata())));
        }
        if (stack.getTagCompound() != null) {
            totalFunctions.add(new SetNBT(new LootCondition[0], stack.getTagCompound()));
        }
        return totalFunctions.toArray(new LootFunction[totalFunctions.size()]);
    }

    public void addLoot(Collection<ItemStack> stacks, Random rand, LootContext context) {
        ItemStack itemstack = this.stack.copy();
        int i = 0;
        if (itemstack.getCount() > 0) {
            if (itemstack.getCount() < this.stack.getItem().getItemStackLimit(itemstack)) {
                stacks.add(itemstack);
            } else {
                ItemStack itemstack1;
                for (i = itemstack.getCount(); i > 0; i -= itemstack1.getCount()) {
                    itemstack1 = itemstack.copy();
                    itemstack1.setCount(Math.min(itemstack.getMaxStackSize(), i));
                    stacks.add(itemstack1);
                }
            }
        }
    }

    static {
        NBTTagCompound tag = new NBTTagCompound();
        tag.setTag("display", (NBTBase)new NBTTagCompound());
        tag.getCompoundTag("display").setString("name", "Super Special BluPrintz");
        NBTTagList list = new NBTTagList();
        list.appendTag((NBTBase)new NBTTagString("Congratulations!"));
        list.appendTag((NBTBase)new NBTTagString("You have found an easter egg!"));
        tag.getCompoundTag("display").setTag("Lore", (NBTBase)list);
        blueprintRename = new SetNBT(new LootCondition[]{new RandomChance(0.125f)}, tag);
    }
}

