/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;

public class IEItemFluidHandler
extends FluidHandlerItemStack {
    public IEItemFluidHandler(ItemStack container, int capacity) {
        super(container, capacity);
    }

    public int getCapacity() {
        if (this.container.getItem() instanceof IEItemInterfaces.IAdvancedFluidItem) {
            return ((IEItemInterfaces.IAdvancedFluidItem)this.container.getItem()).getCapacity(this.container, this.capacity);
        }
        return this.capacity;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        if (this.container.getItem() instanceof IEItemInterfaces.IAdvancedFluidItem) {
            return ((IEItemInterfaces.IAdvancedFluidItem)this.container.getItem()).allowFluid(this.container, fluid);
        }
        return true;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new FluidTankProperties[]{new FluidTankProperties(this.getFluid(), this.getCapacity())};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.container.getCount() != 1 || resource == null || resource.amount <= 0 || !this.canFillFluidType(resource)) {
            return 0;
        }
        FluidStack contained = this.getFluid();
        if (contained == null) {
            int fillAmount = Math.min(this.getCapacity(), resource.amount);
            if (doFill) {
                FluidStack filled = resource.copy();
                filled.amount = fillAmount;
                this.setFluid(filled);
            }
            return fillAmount;
        }
        if (contained.isFluidEqual(resource)) {
            int fillAmount = Math.min(this.getCapacity() - contained.amount, resource.amount);
            if (doFill && fillAmount > 0) {
                contained.amount += fillAmount;
                this.setFluid(contained);
            }
            return fillAmount;
        }
        return 0;
    }
}

